/*
 * Decompiled with CFR 0.152.
 */
package org.necrotic.client.graphics.gameframe.impl;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Iterator;
import org.necrotic.Configuration;
import org.necrotic.client.Client;
import org.necrotic.client.RSInterface;
import org.necrotic.client.cache.definition.MobDefinition;
import org.necrotic.client.cache.node.Deque;
import org.necrotic.client.entity.player.Player;
import org.necrotic.client.entity.player.PlayerHandler;
import org.necrotic.client.graphics.DrawingArea;
import org.necrotic.client.graphics.Sprite;
import org.necrotic.client.graphics.fonts.TextClass;
import org.necrotic.client.graphics.gameframe.GameFrame;
import org.necrotic.client.renderable.NPC;

public class MapArea
extends GameFrame {
    private static final DecimalFormat df;
    public Orb hitpoints = new Orb(OrbType.HITPOINTS);
    public Orb prayer = new Orb(OrbType.PRAYER);
    public Orb run = new Orb(OrbType.RUN);
    public Orb summoning = new Orb(OrbType.SUMMONING);
    private final Orb[] allOrbs = new Orb[]{this.prayer, this.hitpoints, this.run, this.summoning};
    private final NumberFormat format = NumberFormat.getInstance();

    public MapArea(int posX, int posY, int width, int height) {
        super(posX, posY, width, height);
    }

    public void displayMoneyPouch(Client client) {
        boolean fixed = GameFrame.getScreenMode() == GameFrame.ScreenMode.FIXED;
        int x = fixed ? 446 : Client.clientWidth - 146;
        int y = fixed ? 0 : 118;
        int color = 0xFFFFFF;
        long amount = 0L;
        String value = Client.instance.getMoneyInPouch();
        try {
            if (RSInterface.interfaceCache[8135].message != null && !RSInterface.interfaceCache[8135].message.equalsIgnoreCase("")) {
                amount = Long.parseLong(RSInterface.interfaceCache[8135].message);
            }
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        color = MapArea.getAmountColor(amount);
        client.smallText.drawRegularText(true, x + 55 - (value != null ? value.length() * 6 : 0), color, value, (fixed ? 100 : 64) + y);
    }

    public static int getAmountColor(long amount) {
        if (amount >= 10000000000L) {
            return 65535;
        }
        if (amount >= 10000000L) {
            return 65408;
        }
        if (amount >= 100000L) {
            return 0xFFFFFF;
        }
        if (amount >= 1L) {
            return 0xFFFF00;
        }
        return 0xFFFFFF;
    }

    public void displayXPCounter(Client client) {
        boolean fixed = GameFrame.getScreenMode() == GameFrame.ScreenMode.FIXED;
        int x = fixed ? 404 : Client.clientWidth - 318;
        int y = fixed ? 0 : -36;
        int currentIndex = 0;
        int offsetY = 0;
        int stop = 70;
        Client.spritesMap.get(346).drawSprite(x, fixed ? 50 : 48 + y);
        client.normalText.drawRegularText(true, x + 3, 0xFFFFFF, "XP:", (fixed ? 63 : 61) + y);
        String str = df.format(PlayerHandler.totalXP);
        int width = client.normalText.getTextWidth(str);
        if (PlayerHandler.totalXP >= 0L && PlayerHandler.totalXP < 1000000000L) {
            client.normalText.drawRegularText(true, x + 99 - width, 0xFFFFFF, str, (fixed ? 63 : 61) + y);
        } else {
            client.normalText.drawRegularText(true, x + 99 - client.normalText.getTextWidth("Lots!"), 0xFF0000, "Lots!", (fixed ? 63 : 61) + y);
        }
        if (!PlayerHandler.gains.isEmpty()) {
            Iterator it = PlayerHandler.gains.iterator();
            while (it.hasNext()) {
                XPGain gain = (XPGain)it.next();
                if (gain.getY() < stop) {
                    if (gain.getY() <= 10) {
                        gain.increaseAlpha();
                    }
                    if (gain.getY() >= stop - 10) {
                        gain.decreaseAlpha();
                    }
                    gain.increaseY();
                } else if (gain.getY() == stop) {
                    it.remove();
                }
                int spriteId = gain.getSkill() + 498;
                if (gain.getSkill() == 7) {
                    spriteId = 510;
                } else if (gain.getSkill() == 8) {
                    spriteId = 512;
                } else if (gain.getSkill() == 9) {
                    spriteId = 511;
                } else if (gain.getSkill() == 10) {
                    spriteId = 515;
                } else if (gain.getSkill() == 11) {
                    spriteId = 516;
                }
                Sprite sprite = Client.spritesMap.get(spriteId);
                if (PlayerHandler.gains.size() > 1) {
                    offsetY = (fixed ? 0 : -20) + currentIndex * 28;
                }
                if (gain.getY() < stop) {
                    sprite.drawSprite(x + 15 - sprite.myWidth / 2, gain.getY() + offsetY + 66 - sprite.myHeight / 2, gain.getAlpha());
                    client.newSmallFont.drawBasicString("<trans=" + gain.getAlpha() + ">+" + this.format.format(gain.getXP()) + "xp", x + 30, gain.getY() + offsetY + 70, 0xCC6600, 0, false);
                }
                ++currentIndex;
            }
        }
    }

    @Override
    public boolean isHovering(Client client, GameFrame.ScreenMode screenMode) {
        if (!this.isVisible()) {
            return false;
        }
        for (Orb orb : this.allOrbs) {
            if (!orb.isHovering(client, orb.getDrawX(), orb.getDrawY())) continue;
            return true;
        }
        if (client.inSprite(false, client.compass, this.getOffSetX() + (screenMode == GameFrame.ScreenMode.FIXED ? 6 : 5), this.getOffSetY() + (screenMode == GameFrame.ScreenMode.FIXED ? 8 : 5))) {
            return true;
        }
        return client.mouseInCircle(this.getOffSetX() + Client.spritesMap.get((int)13).myWidth / 2, this.getOffSetY() + Client.spritesMap.get((int)13).myHeight / 2, Client.spritesMap.get((int)13).myWidth / 2);
    }

    public void loadOrbs(Client client, GameFrame.ScreenMode screenMode) {
        try {
            this.prayer.setOrbValues(new OrbValue(client.currentStats[5], client.maxStats[5]));
            this.prayer.draw(client, GameFrame.getScreenMode() != GameFrame.ScreenMode.FIXED ? Client.clientWidth - 215 : 186, GameFrame.getScreenMode() != GameFrame.ScreenMode.FIXED ? 73 : 54, screenMode);
            this.hitpoints.setOrbValues(new OrbValue(client.currentStats[3], client.maxStats[3]));
            this.hitpoints.draw(client, GameFrame.getScreenMode() != GameFrame.ScreenMode.FIXED ? Client.clientWidth - 212 : 172, GameFrame.getScreenMode() != GameFrame.ScreenMode.FIXED ? 39 : 15, screenMode);
            this.run.setOrbValues(new OrbValue(client.energy, 100));
            this.run.draw(client, GameFrame.getScreenMode() != GameFrame.ScreenMode.FIXED ? Client.clientWidth - 203 : 184, GameFrame.getScreenMode() != GameFrame.ScreenMode.FIXED ? 107 : 93, screenMode);
            if (client.inSprite(false, Client.spritesMap.get(345), this.getxPos() - (GameFrame.getScreenMode() == GameFrame.ScreenMode.FIXED ? 2 : 40), this.getyPos() + (GameFrame.getScreenMode() == GameFrame.ScreenMode.FIXED ? 46 : 2))) {
                Client.spritesMap.get(344).drawSprite(this.getOffSetX() - (GameFrame.getScreenMode() == GameFrame.ScreenMode.FIXED ? 2 : 40), this.getOffSetY() + (GameFrame.getScreenMode() == GameFrame.ScreenMode.FIXED ? 46 : 2));
            } else {
                Client.spritesMap.get(345).drawSprite(this.getOffSetX() - (GameFrame.getScreenMode() == GameFrame.ScreenMode.FIXED ? 2 : 40), this.getOffSetY() + (GameFrame.getScreenMode() == GameFrame.ScreenMode.FIXED ? 46 : 2));
            }
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
    }

    public void processMinimapActions(Client client) {
        if (this.run.isHovering(client, this.run.getDrawX(), this.run.getDrawY())) {
            client.menuActionName[1] = "Rest";
            client.menuActionID[1] = 1036;
            client.menuActionName[2] = !this.run.getOrbState() ? "Turn run mode on" : "Turn run mode off";
            client.menuActionID[2] = 1050;
            client.menuActionRow = 3;
        }
        if (this.prayer.isHovering(client, this.prayer.getDrawX(), this.prayer.getDrawY())) {
            String prayerType = client.prayerInterfaceType == 5608 ? "prayers" : "curses";
            boolean inProcess = Client.tabInterfaceIDs[5] == 17200 || Client.tabInterfaceIDs[5] == 17234;
            client.menuActionName[client.menuActionRow] = (inProcess ? "Finish" : "Select") + " quick " + prayerType + (inProcess ? " selection" : "");
            client.menuActionID[client.menuActionRow] = 1046;
            client.menuActionName[++client.menuActionRow] = "Turn quick " + prayerType + " " + (this.prayer.getOrbState() ? "off" : "on");
            client.menuActionID[client.menuActionRow] = 1045;
            ++client.menuActionRow;
        }
        if (this.summoning.isHovering(client, this.summoning.getDrawX(), this.summoning.getDrawY())) {
            client.menuActionName[1] = "Dismiss familiar";
            client.menuActionID[1] = 1039;
            client.menuActionName[2] = "Call familiar";
            client.menuActionID[2] = 1037;
            client.menuActionRow = 3;
        }
        if (client.getClickMode2() == 1 && client.mouseX >= Client.clientWidth - Client.spritesMap.get((int)342).myWidth && client.mouseX < Client.clientWidth && client.mouseY >= 0 && client.mouseY <= Client.spritesMap.get((int)342).myHeight) {
            if (client.tabArea.componentHidden()) {
                client.tabArea.setHideComponent(false);
            }
            Client.setTab(14);
        }
        if (client.inSprite(false, Client.spritesMap.get(345), this.getxPos() - (GameFrame.getScreenMode() == GameFrame.ScreenMode.FIXED ? 2 : 40), this.getyPos() + (GameFrame.getScreenMode() == GameFrame.ScreenMode.FIXED ? 46 : 2))) {
            client.menuActionName[1] = "Toggle Exp Lock";
            client.menuActionID[1] = 1095;
            client.menuActionName[2] = "Reset counter";
            client.menuActionID[2] = 1013;
            client.menuActionName[3] = PlayerHandler.showXP ? "Hide counter" : "Show counter";
            client.menuActionID[3] = 1006;
            client.menuActionRow = 4;
        }
        if (client.inSprite(false, Client.spritesMap.get(457), this.getxPos() + (GameFrame.getScreenMode() != GameFrame.ScreenMode.FIXED ? 130 : 6), this.getyPos() + (GameFrame.getScreenMode() != GameFrame.ScreenMode.FIXED ? 132 : 124))) {
            client.menuActionName[1] = "Vote Now";
            client.menuActionID[1] = 1042;
            client.menuActionRow = 2;
        }
        if (client.mouseX >= Client.clientWidth - (MapArea.getScreenMode() == GameFrame.ScreenMode.FIXED ? 242 : 164) && client.mouseX <= Client.clientWidth - (MapArea.getScreenMode() == GameFrame.ScreenMode.FIXED ? 203 : 129) && client.mouseY > (MapArea.getScreenMode() == GameFrame.ScreenMode.FIXED ? 6 : 0) && client.mouseY < (MapArea.getScreenMode() == GameFrame.ScreenMode.FIXED ? 42 : 37)) {
            client.menuActionName[1] = "Face North";
            client.menuActionID[1] = 1014;
            client.menuActionRow = 2;
        }
    }

    @Override
    protected void render(Client client, GameFrame.ScreenMode screenMode) {
        if (this.isVisible()) {
            client.rotateCam();
            if (screenMode == GameFrame.ScreenMode.FIXED) {
                client.mapAreaIP.initDrawingArea();
            }
            if (client.minimapStatus == 2) {
                this.loadOrbs(client, screenMode);
                client.compass.rotate(33, client.cameraRotation, client.compassArray2, 256, client.compassArray1, 25, this.getOffSetY() + (screenMode == GameFrame.ScreenMode.FIXED ? 8 : 4), this.getOffSetX() + (screenMode == GameFrame.ScreenMode.FIXED ? 7 : 5), 33, 25);
                client.gameScreenIP.initDrawingArea();
                return;
            }
            int i = client.cameraRotation + client.minimapRotation & 0x7FF;
            int playerPosX = 48 + Client.myPlayer.x / 32;
            int playerPosY = 464 - Client.myPlayer.y / 32;
            client.miniMapRegions.rotate(152, i, client.mapImagePixelCutRight, 256 + client.minimapZoom, client.mapImagePixelCutLeft, playerPosY, this.getOffSetY() + (screenMode == GameFrame.ScreenMode.FIXED ? 10 : 5), this.getOffSetX() + (screenMode == GameFrame.ScreenMode.FIXED ? 31 : 11), 152, playerPosX);
            client.compass.rotate(33, client.cameraRotation, client.compassArray2, 256, client.compassArray1, 25, this.getOffSetY() + (screenMode == GameFrame.ScreenMode.FIXED ? 8 : 5), this.getOffSetX() + (screenMode == GameFrame.ScreenMode.FIXED ? 7 : 5), 33, 25);
            for (int j5 = 0; j5 < client.anInt1071; ++j5) {
                try {
                    int mapX = client.anIntArray1072[j5] * 4 + 2 - Client.myPlayer.x / 32;
                    int mapY = client.anIntArray1073[j5] * 4 + 2 - Client.myPlayer.y / 32;
                    client.markMinimap(client.aClass30_Sub2_Sub1_Sub1Array1140[j5], mapX, mapY);
                    for (int iconI = 0; iconI < client.customMinimapIcons.size(); ++iconI) {
                        client.markMinimap(client.customMinimapIcons.get(iconI).getSprite(), (client.customMinimapIcons.get(iconI).getX() - client.regionBaseX) * 4 + 2 - Client.myPlayer.x / 32, (client.customMinimapIcons.get(iconI).getY() - client.regionBaseY) * 4 + 2 - Client.myPlayer.y / 32);
                    }
                    continue;
                }
                catch (Exception mapX) {
                    // empty catch block
                }
            }
            for (int k5 = 0; k5 < 104; ++k5) {
                for (int l5 = 0; l5 < 104; ++l5) {
                    Deque class19 = client.groundArray[client.plane][k5][l5];
                    if (class19 == null) continue;
                    int l = k5 * 4 + 2 - Client.myPlayer.x / 32;
                    int j3 = l5 * 4 + 2 - Client.myPlayer.y / 32;
                    client.markMinimap(client.mapDotItem, l, j3);
                }
            }
            for (int i6 = 0; i6 < client.npcCount; ++i6) {
                NPC npc = client.npcArray[client.npcIndices[i6]];
                if (npc == null || !npc.isVisible()) continue;
                MobDefinition entityDef = npc.definitionOverride;
                if (entityDef.childrenIDs != null) {
                    entityDef = entityDef.method161();
                }
                if (entityDef == null || !entityDef.drawYellowDotOnMap || !entityDef.disableRightClick) continue;
                int i1 = npc.x / 32 - Client.myPlayer.x / 32;
                int k3 = npc.y / 32 - Client.myPlayer.y / 32;
                client.markMinimap(client.mapDotNPC, i1, k3);
            }
            for (int j6 = 0; j6 < client.playerCount; ++j6) {
                Player player = client.playerArray[client.playerIndices[j6]];
                if (player == null || !player.isVisible()) continue;
                int x = player.x / 32 - Client.myPlayer.x / 32;
                int y = player.y / 32 - Client.myPlayer.y / 32;
                boolean isInFriends = false;
                boolean isInClan = false;
                for (int j3 = 0; j3 < client.clanMembers.length; ++j3) {
                    if (client.clanMembers[j3] == null || !client.clanMembers[j3].equalsIgnoreCase(player.name)) continue;
                    isInClan = true;
                    break;
                }
                long l6 = TextClass.longForName(player.name);
                for (int k6 = 0; k6 < client.friendCount; ++k6) {
                    if (l6 != client.friendsListAsLongs[k6] || client.friendsNodeIDs[k6] == 0) continue;
                    isInFriends = true;
                    break;
                }
                boolean isInTeam = false;
                if (Client.myPlayer.team != 0 && player.team != 0 && Client.myPlayer.team == player.team) {
                    isInTeam = true;
                }
                if (isInFriends) {
                    client.markMinimap(client.mapDotFriend, x, y);
                    continue;
                }
                if (isInClan) {
                    client.markMinimap(client.mapDotClan, x, y);
                    continue;
                }
                if (isInTeam) {
                    client.markMinimap(client.mapDotTeam, x, y);
                    continue;
                }
                client.markMinimap(client.mapDotPlayer, x, y);
            }
            if (client.anInt855 != 0 && Client.loopCycle % 20 < 10) {
                Player class30_sub2_sub4_sub1_sub2_1;
                NPC class30_sub2_sub4_sub1_sub1_1;
                if (client.anInt855 == 1 && client.anInt1222 >= 0 && client.anInt1222 < client.npcArray.length && (class30_sub2_sub4_sub1_sub1_1 = client.npcArray[client.anInt1222]) != null) {
                    int k1 = class30_sub2_sub4_sub1_sub1_1.x / 32 - Client.myPlayer.x / 32;
                    int i4 = class30_sub2_sub4_sub1_sub1_1.y / 32 - Client.myPlayer.y / 32;
                    client.drawMinimapFlag(client.mapMarker, i4, k1);
                }
                if (client.anInt855 == 2 || client.anInt855 == 5) {
                    int l1 = (client.anInt934 - client.regionBaseX) * 4 + 2 - Client.myPlayer.x / 32;
                    int j4 = (client.anInt935 - client.regionBaseY) * 4 + 2 - Client.myPlayer.y / 32;
                    client.drawMinimapFlag(client.mapMarker, j4, l1);
                }
                if (client.anInt855 == 10 && client.anInt933 >= 0 && client.anInt933 < client.playerArray.length && (class30_sub2_sub4_sub1_sub2_1 = client.playerArray[client.anInt933]) != null) {
                    int i2 = class30_sub2_sub4_sub1_sub2_1.x / 32 - Client.myPlayer.x / 32;
                    int k4 = class30_sub2_sub4_sub1_sub2_1.y / 32 - Client.myPlayer.y / 32;
                    client.drawMinimapFlag(client.mapMarker, k4, i2);
                }
            }
            if (client.destX != 0) {
                int j2 = client.destX * 4 + 2 - Client.myPlayer.x / 32;
                int l4 = client.destY * 4 + 2 - Client.myPlayer.y / 32;
                client.markMinimap(client.mapFlag, j2, l4);
            }
            client.compass.rotate(33, client.cameraRotation, client.compassArray2, 256, client.compassArray1, 25, this.getOffSetY() + (screenMode == GameFrame.ScreenMode.FIXED ? 8 : 4), this.getOffSetX() + (screenMode == GameFrame.ScreenMode.FIXED ? 7 : 5), 33, 25);
            Client.spritesMap.get(screenMode == GameFrame.ScreenMode.FIXED ? 14 : 13).drawSprite(this.getOffSetX() - (screenMode == GameFrame.ScreenMode.FIXED ? 1 : 0), this.getOffSetY() - (screenMode == GameFrame.ScreenMode.FIXED ? 0 : 1));
            if (client.inSprite(false, Client.spritesMap.get(927), this.getxPos() + (screenMode != GameFrame.ScreenMode.FIXED ? 130 : 6), this.getyPos() + (screenMode != GameFrame.ScreenMode.FIXED ? 132 : 124))) {
                Client.spritesMap.get(927).drawSprite(this.getOffSetX() + (screenMode != GameFrame.ScreenMode.FIXED ? 130 : 6), this.getOffSetY() + (screenMode != GameFrame.ScreenMode.FIXED ? 132 : 124));
            } else {
                Client.spritesMap.get(927).drawSprite(this.getOffSetX() + (screenMode != GameFrame.ScreenMode.FIXED ? 130 : 6), this.getOffSetY() + (screenMode != GameFrame.ScreenMode.FIXED ? 132 : 124));
            }
            this.loadOrbs(client, screenMode);
            if (Client.showDonatorNotification && (Client.notificationIntensity += 0.001) > 90.0) {
                Client.notificationIntensity = 90.0;
            }
            if (client.mouseX >= Client.clientWidth - Client.spritesMap.get((int)342).myWidth && client.mouseX < Client.clientWidth && client.mouseY >= 0 && client.mouseY <= Client.spritesMap.get((int)342).myHeight) {
                Client.spritesMap.get(342).drawSprite(this.getOffSetX() + (GameFrame.getScreenMode() != GameFrame.ScreenMode.FIXED ? 149 : 225), 0);
            } else {
                Client.spritesMap.get(341).drawSprite(this.getOffSetX() + (GameFrame.getScreenMode() != GameFrame.ScreenMode.FIXED ? 149 : 225), 0);
            }
            if (client.inSprite(false, Client.spritesMap.get(342), this.getxPos() + (GameFrame.getScreenMode() != GameFrame.ScreenMode.FIXED ? 149 : 225), 0)) {
                Client.spritesMap.get(342).drawSprite(this.getOffSetX() + (GameFrame.getScreenMode() != GameFrame.ScreenMode.FIXED ? 149 : 225), 0);
            } else {
                Client.spritesMap.get(341).drawSprite(this.getOffSetX() + (GameFrame.getScreenMode() != GameFrame.ScreenMode.FIXED ? 149 : 225), 0);
            }
            if (client.inSprite(false, Client.spritesMap.get(456), this.getxPos() + (screenMode != GameFrame.ScreenMode.FIXED ? 130 : 6), this.getyPos() + (screenMode != GameFrame.ScreenMode.FIXED ? 132 : 124))) {
                Client.spritesMap.get(456).drawSprite(this.getOffSetX() + (screenMode != GameFrame.ScreenMode.FIXED ? 130 : 6), this.getOffSetY() + (screenMode != GameFrame.ScreenMode.FIXED ? 132 : 124));
            } else {
                Client.spritesMap.get(457).drawSprite(this.getOffSetX() + (screenMode != GameFrame.ScreenMode.FIXED ? 130 : 6), this.getOffSetY() + (screenMode != GameFrame.ScreenMode.FIXED ? 132 : 124));
            }
            if (Client.tabID == 14) {
                Client.spritesMap.get(343).drawSprite(this.getOffSetX() + (GameFrame.getScreenMode() != GameFrame.ScreenMode.FIXED ? 149 : 225), 0);
            }
            if (client.inSprite(false, Client.spritesMap.get(458), this.getxPos() + (GameFrame.getScreenMode() != GameFrame.ScreenMode.FIXED ? 128 : 204), 0)) {
                Client.spritesMap.get(459).drawSprite(this.getOffSetX() + (GameFrame.getScreenMode() != GameFrame.ScreenMode.FIXED ? 128 : 204), 0);
            } else {
                Client.spritesMap.get(458).drawSprite(this.getOffSetX() + (GameFrame.getScreenMode() != GameFrame.ScreenMode.FIXED ? 128 : 204), 0);
            }
            DrawingArea.drawPixels(3, 76 + (GameFrame.getScreenMode() != GameFrame.ScreenMode.FIXED ? 4 : 8) + this.getOffSetY(), 76 + (GameFrame.getScreenMode() != GameFrame.ScreenMode.FIXED ? 9 : 29) + this.getOffSetX(), 0xFFFFFF, 3);
            if (client.menuOpen && client.menuScreenArea == 3) {
                client.drawMenu();
            }
        }
        client.gameScreenIP.initDrawingArea();
    }

    static {
        DecimalFormatSymbols dfs = new DecimalFormatSymbols();
        dfs.setGroupingSeparator(',');
        df = new DecimalFormat("", dfs);
    }

    public static class XPGain {
        private int alpha = 0;
        private final int skill;
        private final int xp;
        private int y;

        public XPGain(int skill, int xp) {
            this.skill = skill;
            this.xp = xp;
        }

        public void decreaseAlpha() {
            this.alpha -= this.alpha > 0 ? 30 : 0;
            this.alpha = this.alpha > 256 ? 256 : this.alpha;
        }

        public int getAlpha() {
            return this.alpha;
        }

        public int getSkill() {
            return this.skill;
        }

        public int getXP() {
            return this.xp;
        }

        public int getY() {
            return this.y;
        }

        public void increaseAlpha() {
            this.alpha += this.alpha < 256 ? 30 : 0;
            this.alpha = this.alpha > 256 ? 256 : this.alpha;
        }

        public void increaseY() {
            ++this.y;
        }
    }

    static class OrbValue {
        private final int currentValue;
        private final int maxValue;

        public OrbValue(int currentValue, int maxValue) {
            this.currentValue = currentValue;
            this.maxValue = maxValue;
        }

        public int getCurrentValue() {
            return this.currentValue;
        }

        public int getMaxValue() {
            return this.maxValue;
        }
    }

    static enum OrbType {
        HITPOINTS(new int[]{329, -1, 330}, new int[]{1, 2}),
        PRAYER(new int[]{331, 332, 333}, new int[]{-2, -2}),
        RUN(new int[]{337, 338, 335, 336}, new int[]{0, -1}),
        SUMMONING(new int[]{367, 369, 368}, new int[]{0, 0});

        private final int[] offsets;
        private final int[] spriteIDs;

        private OrbType(int[] spriteIDs, int[] offsets) {
            this.spriteIDs = spriteIDs;
            this.offsets = offsets;
        }

        public int[] getOffSets() {
            return this.offsets;
        }

        public int[] getSpriteIDs() {
            return this.spriteIDs;
        }
    }

    public class Orb {
        private int drawX;
        private int drawY;
        private double fillOrb;
        private boolean orbActive;
        private final OrbType type;
        private OrbValue values;

        public Orb(OrbType type) {
            this.type = type;
        }

        public void draw(Client client, int xPos, int yPos, GameFrame.ScreenMode screenMode) {
            int depleteFill;
            this.drawX = xPos;
            this.drawY = yPos;
            int currentValue = this.values.getCurrentValue();
            int maxValue = this.values.getMaxValue();
            if (this.type == OrbType.HITPOINTS && !Configuration.CONSTITUTION_ENABLED) {
                currentValue /= 10;
                maxValue /= 10;
            }
            int level = (int)((double)currentValue / (double)maxValue * 100.0);
            Client.spritesMap.get(screenMode == GameFrame.ScreenMode.FIXED ? (this.isHovering(client, xPos, yPos) && this.type != OrbType.HITPOINTS ? 334 : 16) : (this.isHovering(client, xPos, yPos) && this.type != OrbType.HITPOINTS ? 366 : 15)).drawSprite(xPos, yPos);
            if (level >= 101) {
                client.newSmallFont.drawCenteredString(Integer.toString(currentValue), xPos + (screenMode == GameFrame.ScreenMode.FIXED ? 42 : 15), yPos + 26, 65280, 0);
            } else if (level >= 75) {
                client.newSmallFont.drawCenteredString(Integer.toString(currentValue), xPos + (screenMode == GameFrame.ScreenMode.FIXED ? 42 : 15), yPos + 26, 65280, 0);
            } else if (level >= 50) {
                client.newSmallFont.drawCenteredString(Integer.toString(currentValue), xPos + (screenMode == GameFrame.ScreenMode.FIXED ? 42 : 15), yPos + 26, 0xFFFF00, 0);
            } else if (level >= 25) {
                client.newSmallFont.drawCenteredString(Integer.toString(currentValue), xPos + (screenMode == GameFrame.ScreenMode.FIXED ? 42 : 15), yPos + 26, 16557575, 0);
            } else if (level >= 0) {
                client.newSmallFont.drawCenteredString(Integer.toString(currentValue), xPos + (screenMode == GameFrame.ScreenMode.FIXED ? 42 : 15), yPos + 26, 16059661, 0);
            }
            Client.spritesMap.get(this.orbActive ? this.type.getSpriteIDs()[1] : this.type.getSpriteIDs()[0]).drawSprite(xPos + (screenMode == GameFrame.ScreenMode.FIXED ? 3 : 27), yPos + 3);
            double percent = (double)level / 100.0;
            this.fillOrb = 27.0 * percent;
            Client.spritesMap.get((int)327).myHeight = depleteFill = 27 - (int)this.fillOrb;
            Client.spritesMap.get(327).drawSprite(xPos + (screenMode == GameFrame.ScreenMode.FIXED ? 3 : 27), yPos + 3);
            Client.spritesMap.get(this.type.getSpriteIDs()[this.type == OrbType.RUN ? (this.orbActive ? 3 : 2) : 2]).drawSprite(xPos + (screenMode == GameFrame.ScreenMode.FIXED ? 9 : 33) + this.type.getOffSets()[0], yPos + 9 + this.type.getOffSets()[1]);
        }

        public int getDrawX() {
            return this.drawX;
        }

        public int getDrawY() {
            return this.drawY;
        }

        public boolean getOrbState() {
            return this.orbActive;
        }

        public boolean isHovering(Client client, int xPos, int yPos) {
            if (GameFrame.getScreenMode() == GameFrame.ScreenMode.FIXED) {
                return client.inSprite(false, Client.spritesMap.get(15), MapArea.this.getxPos() + xPos, MapArea.this.getyPos() + yPos);
            }
            return client.inSprite(false, Client.spritesMap.get(15), xPos, yPos);
        }

        public void setOrbState(boolean active) {
            this.orbActive = active;
        }

        public void setOrbValues(OrbValue values) {
            this.values = values;
        }
    }
}

