/*
 * Decompiled with CFR 0.152.
 */
package org.necrotic.client.graphics.overlay;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import org.necrotic.client.Client;
import org.necrotic.client.graphics.DrawingArea;
import org.necrotic.client.graphics.Sprite;
import org.necrotic.client.graphics.gameframe.GameFrame;
import org.necrotic.client.graphics.overlay.BorderOverlay;
import org.necrotic.client.graphics.overlay.Overlay;
import org.necrotic.client.graphics.overlay.PlainOverlay;

public class OverlayManager {
    private static final List<Overlay> overlays = new CopyOnWriteArrayList<Overlay>();
    private static final List<BorderOverlay> otherOverlays = new CopyOnWriteArrayList<BorderOverlay>();
    private static final List<PlainOverlay> plains = new CopyOnWriteArrayList<PlainOverlay>();
    private static final AtomicInteger atomicInteger = new AtomicInteger(0);

    public static void add(Overlay overlay) {
        overlays.stream().filter(o -> o.getSprite() == overlay.getSprite()).findFirst().ifPresent(overlays::remove);
        overlays.add(overlay);
    }

    public static void add(BorderOverlay overlay) {
        otherOverlays.stream().filter(o -> o.getOverlay() == overlay.getOverlay()).findFirst().ifPresent(otherOverlays::remove);
        otherOverlays.add(overlay);
    }

    public static void add(PlainOverlay overlay) {
        plains.stream().filter(o -> o.getOverlay() == overlay.getOverlay()).findFirst().ifPresent(plains::remove);
        plains.add(overlay);
    }

    public static void draw() {
        int yDraw;
        atomicInteger.getAndIncrement();
        int xDraw = GameFrame.getScreenMode() == GameFrame.ScreenMode.FIXED ? Client.clientWidth - 325 : Client.clientWidth - 276;
        int n = yDraw = GameFrame.getScreenMode() == GameFrame.ScreenMode.FIXED ? Client.clientHeight - 210 : Client.clientHeight - 170;
        if (GameFrame.getScreenMode() != GameFrame.ScreenMode.FIXED && Client.instance.getWidth() >= 1000) {
            yDraw = Client.clientHeight - 48;
        } else if (GameFrame.getScreenMode() != GameFrame.ScreenMode.FIXED && Client.instance.getWidth() >= 800) {
            yDraw = Client.clientHeight - 86;
        }
        for (Overlay overlay : overlays) {
            if (overlay.getTimeLeft() <= 0L) {
                overlays.remove(overlay);
                continue;
            }
            Sprite sprite = Client.spritesMap.get(overlay.getSprite());
            String string = OverlayManager.formatMinutes(overlay.getTimeLeft());
            if (sprite == null) continue;
            if (GameFrame.getScreenMode() == GameFrame.ScreenMode.FIXED) {
                DrawingArea.method338(yDraw - 21, 28, 150, 0, 63, xDraw + 5);
                DrawingArea.method335(4405810, yDraw - 20, 61, 26, 150, xDraw + 6);
                Client.instance.newSmallFont.drawBasicString(string, xDraw + 32, yDraw - 2, 0xFFFFFF, 1);
                sprite.drawSprite(xDraw + 2, yDraw - 22);
            } else {
                DrawingArea.method338(yDraw - 21, 28, 150, 0, 63, xDraw + 5);
                DrawingArea.method335(4405810, yDraw - 20, 61, 26, 150, xDraw + 6);
                Client.instance.newSmallFont.drawBasicString(string, xDraw + 32, yDraw - 1, 0xFFFFFF, 1);
                sprite.drawSprite(xDraw + 2, yDraw - 23);
            }
            yDraw -= 30;
        }
        for (BorderOverlay borderOverlay : otherOverlays) {
            Sprite sprite;
            Sprite background;
            int y;
            int x;
            if (borderOverlay.getTimeLeft() <= 0L) {
                otherOverlays.remove(borderOverlay);
                continue;
            }
            if (borderOverlay.getOverlay().getId() >= 100) {
                x = GameFrame.getScreenMode() == GameFrame.ScreenMode.FIXED ? borderOverlay.getOverlay().getX() : borderOverlay.getOverlay().getX() - borderOverlay.getOverlay().getX() / 7;
                int n2 = y = GameFrame.getScreenMode() == GameFrame.ScreenMode.FIXED ? borderOverlay.getOverlay().getY() : borderOverlay.getOverlay().getY() - borderOverlay.getOverlay().getY() / 7;
                if (GameFrame.getScreenMode() != GameFrame.ScreenMode.FIXED && Client.instance.getWidth() >= 1000) {
                    y = Client.clientHeight - 48;
                } else if (GameFrame.getScreenMode() != GameFrame.ScreenMode.FIXED && Client.instance.getWidth() >= 800) {
                    y = Client.clientHeight - 86;
                }
                background = Client.spritesMap.get(borderOverlay.getOverlay().getBackgroundSprite());
                sprite = borderOverlay.getOverlay().getSprite() != -1 ? Client.spritesMap.get(borderOverlay.getOverlay().getSprite()) : null;
                if (GameFrame.getScreenMode() == GameFrame.ScreenMode.FIXED) {
                    background.drawSprite1(x, y);
                    if (sprite != null) {
                        sprite.drawSprite1(x + 20, y + 5);
                    }
                    if (borderOverlay.getOverlay().getOther() != null) {
                        Client.instance.newFancyFont.drawCenteredString(borderOverlay.getOverlay().getOther(), x + 245, y + 23, borderOverlay.getOverlay().getTextColor(), 1);
                    }
                }
                if (borderOverlay.getTimeLeft() > 120L || borderOverlay.getTimeLeft() % 3L != 0L) continue;
                DrawingArea.renderGlow(x + background.myWidth / 2, y + background.myHeight / 2, borderOverlay.getOverlay().getPulse(), background.myWidth / 2, background.myHeight / 2);
                continue;
            }
            x = GameFrame.getScreenMode() == GameFrame.ScreenMode.FIXED ? borderOverlay.getOverlay().getX() : borderOverlay.getOverlay().getX() - borderOverlay.getOverlay().getX() / 7;
            int n3 = y = GameFrame.getScreenMode() == GameFrame.ScreenMode.FIXED ? borderOverlay.getOverlay().getY() : borderOverlay.getOverlay().getY() - borderOverlay.getOverlay().getY() / 7;
            if (GameFrame.getScreenMode() != GameFrame.ScreenMode.FIXED && Client.instance.getWidth() >= 1000) {
                y = Client.clientHeight - 48;
            } else if (GameFrame.getScreenMode() != GameFrame.ScreenMode.FIXED && Client.instance.getWidth() >= 800) {
                y = Client.clientHeight - 86;
            }
            background = Client.spritesMap.get(borderOverlay.getOverlay().getBackgroundSprite());
            sprite = borderOverlay.getOverlay().getSprite() != -1 ? Client.spritesMap.get(borderOverlay.getOverlay().getSprite()) : null;
            String string = OverlayManager.formatMinutes(borderOverlay.getTimeLeft());
            if (GameFrame.getScreenMode() == GameFrame.ScreenMode.FIXED) {
                background.drawSprite1(x, y);
                if (sprite != null) {
                    sprite.drawSprite1(x + 20, y + 5);
                }
                if (borderOverlay.getOverlay().getOther() != null) {
                    Client.instance.newFancyFont.drawBasicString(borderOverlay.getOverlay().getOther(), x + 112, y + 23, borderOverlay.getOverlay().getTextColor(), 1);
                    Client.instance.newFancyFont.drawBasicString(string, x + 282, y + 23, 16716947, 1);
                } else {
                    Client.instance.newFancyFont.drawBasicString(string, x + 112, y + 23, borderOverlay.getOverlay().getTextColor(), 1);
                }
            }
            if (borderOverlay.getTimeLeft() > 120L || borderOverlay.getTimeLeft() % 3L != 0L) continue;
            DrawingArea.renderGlow(x + background.myWidth / 2, y + background.myHeight / 2, borderOverlay.getOverlay().getPulse(), background.myWidth / 2, background.myHeight / 2);
        }
    }

    private static String formatMinutes(long seconds) {
        int i = (int)(seconds / 60L);
        long j = seconds - (long)i * 60L;
        String str1 = "" + i;
        String str2 = "" + j;
        if (j < 10L) {
            str2 = "0" + str2;
        }
        if (i < 10) {
            str1 = "0" + str1;
        }
        return str1 + ":" + str2;
    }
}

