/*
 * Decompiled with CFR 0.152.
 */
package org.necrotic.client.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import org.necrotic.client.GameRenderer;

public final class Connection
implements Runnable {
    private final GameRenderer applet;
    private byte[] buffer;
    private int buffIndex;
    private boolean closed;
    private boolean error;
    private final InputStream in;
    private final OutputStream out;
    private final Socket socket;
    private int writeIndex;
    private boolean writing;

    public Connection(GameRenderer applet, Socket socket) throws IOException {
        this.applet = applet;
        this.socket = socket;
        this.error = false;
        this.writing = false;
        socket.setSoTimeout(30000);
        socket.setTcpNoDelay(true);
        this.in = socket.getInputStream();
        this.out = socket.getOutputStream();
    }

    public int available() throws IOException {
        if (this.closed) {
            return 0;
        }
        return this.in.available();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.closed = true;
        try {
            if (this.in != null) {
                this.in.close();
            }
            if (this.out != null) {
                this.out.close();
            }
            if (this.socket != null) {
                this.socket.close();
            }
        }
        catch (IOException _ex) {
            _ex.printStackTrace();
        }
        this.writing = false;
        Connection connection = this;
        synchronized (connection) {
            this.notify();
        }
        this.buffer = null;
    }

    public void flushInputStream(byte[] buffer, int length) throws IOException {
        int totalRead = 0;
        if (this.closed) {
            return;
        }
        while (length > 0) {
            int readLength = this.in.read(buffer, totalRead, length);
            if (readLength <= 0) {
                throw new IOException("EOF");
            }
            totalRead += readLength;
            length -= readLength;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueBytes(int i, byte[] abyte0) throws IOException {
        if (this.closed) {
            return;
        }
        if (this.error) {
            this.error = false;
            throw new IOException("Error in writer thread");
        }
        if (this.buffer == null) {
            this.buffer = new byte[5000];
        }
        Connection connection = this;
        synchronized (connection) {
            for (int l = 0; l < i; ++l) {
                this.buffer[this.buffIndex] = abyte0[l];
                this.buffIndex = (this.buffIndex + 1) % 5000;
                if (this.buffIndex != (this.writeIndex + 4900) % 5000) continue;
                throw new IOException("buffer overflow");
            }
            if (!this.writing) {
                this.writing = true;
                this.applet.startRunnable(this, 3);
            }
            this.notify();
        }
    }

    public int read() throws IOException {
        if (this.closed) {
            return 0;
        }
        return this.in.read();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (this.writing) {
            int i;
            int j;
            Connection connection = this;
            synchronized (connection) {
                if (this.buffIndex == this.writeIndex) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (!this.writing) {
                    return;
                }
                j = this.writeIndex;
                i = this.buffIndex >= this.writeIndex ? this.buffIndex - this.writeIndex : 5000 - this.writeIndex;
            }
            if (i <= 0) continue;
            try {
                this.out.write(this.buffer, j, i);
            }
            catch (IOException _ex) {
                this.error = true;
            }
            this.writeIndex = (this.writeIndex + i) % 5000;
            try {
                if (this.buffIndex != this.writeIndex) continue;
                this.out.flush();
            }
            catch (IOException _ex) {
                this.error = true;
            }
        }
    }
}

