/*
 * Decompiled with CFR 0.152.
 */
package org.necrotic.client.tools;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;

public final class FileUtilities {
    public static int TotalRead = 0;
    public static int TotalWrite = 0;
    public static int CompleteWrite = 0;

    protected static byte[] getBytesFromFile(File file) throws IOException {
        byte[] buffer = new byte[(int)file.length()];
        try (DataInputStream dis = new DataInputStream(new FileInputStream(file));){
            dis.readFully(buffer);
            byte[] byArray = buffer;
            return byArray;
        }
    }

    public static void delete(String root) throws IOException {
        Files.walkFileTree(Paths.get(root, new String[0]), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) throws IOException {
                Files.delete(path);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path path, IOException cause) throws IOException {
                if (cause == null) {
                    Files.delete(path);
                    return FileVisitResult.CONTINUE;
                }
                throw cause;
            }
        });
    }

    public static final byte[] ReadFile(String s2) {
        try {
            File file = new File(s2);
            int i = (int)file.length();
            byte[] abyte0 = new byte[i];
            DataInputStream datainputstream = new DataInputStream(new BufferedInputStream(new FileInputStream(s2)));
            datainputstream.readFully(abyte0, 0, i);
            datainputstream.close();
            ++TotalRead;
            return abyte0;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static final void WriteFile(String s2, byte[] abyte0) {
        try {
            new File(new File(s2).getParent()).mkdirs();
            FileOutputStream fileoutputstream = new FileOutputStream(s2);
            fileoutputstream.write(abyte0, 0, abyte0.length);
            fileoutputstream.close();
            ++TotalWrite;
            ++CompleteWrite;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public static boolean FileExists(String file) {
        File f = new File(file);
        return f.exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] readFile(String name) {
        try {
            RandomAccessFile raf = new RandomAccessFile(name, "r");
            MappedByteBuffer buf = raf.getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, raf.length());
            try {
                if (buf.hasArray()) {
                    byte[] byArray = buf.array();
                    return byArray;
                }
                byte[] array = new byte[buf.remaining()];
                buf.get(array);
                byte[] byArray = array;
                return byArray;
            }
            finally {
                raf.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

