/*
 * Decompiled with CFR 0.152.
 */
package org.necrotic.client.tools;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class Hashing {
    private static final char[] hexdigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getLocalChecksum(String location) {
        File local = new File(location);
        try (FileInputStream fis = new FileInputStream(local);){
            String string = Hashing.calculateMd5(fis);
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getRemoteChecksum(String location) {
        try (InputStream stream = new URL(location).openStream();){
            String string = Hashing.calculateMd5(stream);
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String calculateMd5(InputStream instream) {
        return Hashing.calculateDigest(instream);
    }

    private static String calculateDigest(InputStream instream) {
        byte[] buffer = new byte[4096];
        MessageDigest messageDigest = Hashing.getMessageDigest("SHA-256");
        messageDigest.reset();
        try {
            int bytesRead;
            while ((bytesRead = instream.read(buffer)) != -1) {
                messageDigest.update(buffer, 0, bytesRead);
            }
        }
        catch (IOException e) {
            System.err.println("Error making a 'SHA-256' digest on the inputstream");
        }
        return Hashing.toHex(messageDigest.digest());
    }

    public static String toHex(byte[] ba) {
        int baLen = ba.length;
        char[] hexchars = new char[baLen * 2];
        int cIdx = 0;
        for (byte b : ba) {
            hexchars[cIdx++] = hexdigit[b >> 4 & 0xF];
            hexchars[cIdx++] = hexdigit[b & 0xF];
        }
        return String.valueOf(hexchars);
    }

    public static MessageDigest getMessageDigest(String algorithm) {
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            System.err.println("The '" + algorithm + "' algorithm is not available");
        }
        return messageDigest;
    }
}

