/*
 * Decompiled with CFR 0.152.
 */
package org.necrotic.client.tools;

import java.awt.Graphics;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.JPanel;
import org.necrotic.client.cache.definition.ItemDefinition;
import org.necrotic.client.graphics.RSImageProducer;
import org.necrotic.client.graphics.Sprite;
import org.necrotic.client.tools.ItemEditor;
import org.necrotic.client.world.Rasterizer;

public class ItemPanel
extends JPanel {
    public ItemEditor itemEditor;
    private RSImageProducer imageProducer;
    private Sprite invBackground = null;
    private Sprite invTransBackground = null;
    public boolean saved = false;

    public ItemPanel(ItemEditor editor) {
        this.itemEditor = editor;
        this.imageProducer = new RSImageProducer(240, 334);
        this.invBackground = new Sprite("invedit");
        this.invTransBackground = new Sprite("invbacktrans");
    }

    public byte[] read(File file) {
        try {
            byte[] buffer = new byte[4096];
            ByteArrayOutputStream ous = new ByteArrayOutputStream();
            FileInputStream ios = new FileInputStream(file);
            int read = 0;
            while ((read = ((InputStream)ios).read(buffer)) != -1) {
                ous.write(buffer, 0, read);
            }
            try {
                ous.close();
                ((InputStream)ios).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return ous.toByteArray();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    @Override
    public void paintComponent(Graphics g2) {
        super.paintComponent(g2);
        this.imageProducer.initDrawingArea();
        Rasterizer.setAllPixelsToZero();
        Sprite inventoryModel = ItemDefinition.getSprite(this.itemEditor.getItemID(), 1, this.itemEditor.isSelected() ? 0xFFFFFF : 0);
        Sprite bigInventoryModel = ItemDefinition.getSprite(this.itemEditor.getItemID(), 1, 0, 3.0, false);
        this.invBackground.drawSprite(0, 0);
        this.invTransBackground.drawSprite(40, 44);
        if (inventoryModel != null) {
            inventoryModel.drawSprite(41, 45);
            bigInventoryModel.drawSprite(58, 100);
        } else {
            this.repaint();
        }
        this.imageProducer.drawGraphics(g2, 0, 0);
    }
}

