/*
 * Decompiled with CFR 0.152.
 */
package org.necrotic.client.world;

import org.necrotic.Configuration;
import org.necrotic.client.OnDemandTextureLoader;
import org.necrotic.client.cache.Archive;
import org.necrotic.client.graphics.Background;
import org.necrotic.client.graphics.DrawingArea;
import org.necrotic.client.world.Texture;

public final class Rasterizer
extends DrawingArea {
    public static int fieldOfView = 512;
    public static boolean saveDepth;
    public static OnDemandTextureLoader onDemandTextureLoader;
    public static float[] depthBuffer;
    public static final int TEXTURE_AMOUNT = 98;
    public static Background[] textures;
    public static boolean restrict_edges;
    public static int[] SINE;
    public static int[] COSINE;
    private static boolean aBoolean1463;
    private static boolean[] aBooleanArray1475;
    public static int alpha;
    public static int textureCount;
    private static int poolSize;
    public static int cycle;
    private static int[] shadowDecay;
    public static final int[] anIntArray1469;
    private static int[] averageTextureRGB;
    public static int[] textureCycle;
    public static int[] hsl2rgb;
    private static int[][] texelPool;
    private static int[][] activeTexels;
    private static int[][] texturePalette;
    public static int centerX;
    public static int centerY;
    public static int[] lineOffsets;
    public static boolean lowDetail;
    public static boolean notTextured;
    private static int[] OFFSETS_512_334;
    private static int[] OFFSETS_765_503;
    public static boolean repeatTexture;
    public static boolean forceRepeat;
    private static int textureMipmap;

    public static void clearDepthBuffer() {
        if (depthBuffer == null || depthBuffer.length != raster.length) {
            depthBuffer = new float[raster.length];
        }
        for (int i = 0; i < depthBuffer.length; ++i) {
            Rasterizer.depthBuffer[i] = Float.MAX_VALUE;
        }
    }

    public static void drawFog(int rgb, int begin, int end) {
        float length = end - begin;
        for (int i = 0; i < raster.length; ++i) {
            float factor = (depthBuffer[i] - (float)begin) / length;
            Rasterizer.raster[i] = Rasterizer.blend(raster[i], rgb, factor);
        }
    }

    private static int blend(int c1, int c2, float factor) {
        if (factor >= 1.0f) {
            return c2;
        }
        if (factor <= 0.0f) {
            return c1;
        }
        int r1 = c1 >> 16 & 0xFF;
        int g1 = c1 >> 8 & 0xFF;
        int b1 = c1 & 0xFF;
        int r2 = c2 >> 16 & 0xFF;
        int g2 = c2 >> 8 & 0xFF;
        int b2 = c2 & 0xFF;
        int r3 = r2 - r1;
        int g3 = g2 - g1;
        int b3 = b2 - b1;
        int r = (int)((float)r1 + (float)r3 * factor);
        int g4 = (int)((float)g1 + (float)g3 * factor);
        int b = (int)((float)b1 + (float)b3 * factor);
        return (r << 16) + (g4 << 8) + b;
    }

    public static int[] getOffsets(int j, int k) {
        if (j == 512 && k == 334 && OFFSETS_512_334 != null) {
            return OFFSETS_512_334;
        }
        if (j == 766 && k == 503 && OFFSETS_765_503 != null) {
            return OFFSETS_765_503;
        }
        int[] t = new int[k];
        for (int l = 0; l < k; ++l) {
            t[l] = j * l;
        }
        if (j == 512 && k == 334) {
            OFFSETS_512_334 = t;
        }
        if (j == 766 && k == 503) {
            OFFSETS_765_503 = t;
        }
        return t;
    }

    public static void method364() {
        lineOffsets = new int[DrawingArea.height];
        for (int j = 0; j < DrawingArea.height; ++j) {
            Rasterizer.lineOffsets[j] = DrawingArea.width * j;
        }
        centerX = DrawingArea.width / 2;
        centerY = DrawingArea.height / 2;
    }

    public static void clearTextureCache() {
        texelPool = null;
        for (int j = 0; j < 98; ++j) {
            Rasterizer.activeTexels[j] = null;
        }
    }

    public static void initiateRequestBuffers() {
        if (texelPool == null) {
            poolSize = 20;
            texelPool = lowDetail ? new int[poolSize][16384] : new int[poolSize][65536];
            for (int k = 0; k < 98; ++k) {
                Rasterizer.activeTexels[k] = null;
            }
        }
    }

    public static void loadTextures(Archive streamLoader) {
        textureCount = 0;
        for (int i = 0; i < 98; ++i) {
            try {
                Rasterizer.textures[i] = new Background(streamLoader, String.valueOf(i), 0);
                if (lowDetail && Rasterizer.textures[i].maxWidth == 128) {
                    textures[i].method356();
                } else {
                    textures[i].method357();
                }
                ++textureCount;
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static int getAverageTextureRGB(int textureId) {
        if (textures[textureId] == null) {
            onDemandTextureLoader.loadTexture(textureId);
        }
        if (averageTextureRGB[textureId] != 0) {
            return averageTextureRGB[textureId];
        }
        int redSum = 0;
        int greenSum = 0;
        int blueSum = 0;
        int length = texturePalette[textureId].length;
        for (int i = 0; i < length; ++i) {
            redSum += texturePalette[textureId][i] >> 16 & 0xFF;
            greenSum += texturePalette[textureId][i] >> 8 & 0xFF;
            blueSum += texturePalette[textureId][i] & 0xFF;
        }
        int averageRGB = (redSum / length << 16) + (greenSum / length << 8) + blueSum / length;
        if ((averageRGB = Rasterizer.setGamma(averageRGB, 1.4)) == 0) {
            averageRGB = 1;
        }
        Rasterizer.averageTextureRGB[textureId] = averageRGB;
        return averageRGB;
    }

    public static void pushTexture(int textureId) {
        if (activeTexels[textureId] == null) {
            return;
        }
        Rasterizer.texelPool[Rasterizer.poolSize++] = activeTexels[textureId];
        Rasterizer.activeTexels[textureId] = null;
    }

    private static int[] getTexels(int textureId) {
        int[] texels;
        if (textures[textureId] == null) {
            onDemandTextureLoader.loadTexture(textureId);
        }
        ++cycle;
        if (activeTexels[textureId] != null) {
            return activeTexels[textureId];
        }
        if (poolSize > 0) {
            texels = texelPool[--poolSize];
            Rasterizer.texelPool[Rasterizer.poolSize] = null;
        } else {
            int j = 0;
            int k = -1;
            for (int l = 0; l < textureCount; ++l) {
                if (activeTexels[l] == null || textureCycle[l] >= j && k != -1) continue;
                j = textureCycle[l];
                k = l;
            }
            texels = activeTexels[k];
            Rasterizer.activeTexels[k] = null;
        }
        Rasterizer.activeTexels[textureId] = texels;
        Background background = textures[textureId];
        int[] ai1 = texturePalette[textureId];
        if (lowDetail) {
            Rasterizer.aBooleanArray1475[textureId] = false;
            for (int i1 = 0; i1 < 4096; ++i1) {
                texels[i1] = ai1[background.imgPixels[i1]] & 0xF8F8FF;
                int i2 = texels[i1];
                if (i2 == 0) {
                    Rasterizer.aBooleanArray1475[textureId] = true;
                }
                texels[4096 + i1] = i2 - (i2 >>> 3) & 0xF8F8FF;
                texels[8192 + i1] = i2 - (i2 >>> 2) & 0xF8F8FF;
                texels[12288 + i1] = i2 - (i2 >>> 2) - (i2 >>> 3) & 0xF8F8FF;
            }
        } else {
            if (background.imgWidth == 64) {
                for (int j1 = 0; j1 < 128; ++j1) {
                    for (int j2 = 0; j2 < 128; ++j2) {
                        texels[j2 + (j1 << 7)] = ai1[background.imgPixels[(j2 >> 1) + (j1 >> 1 << 6)]];
                    }
                }
            } else {
                for (int k1 = 0; k1 < 16384; ++k1) {
                    texels[k1] = ai1[background.imgPixels[k1]];
                }
            }
            Rasterizer.aBooleanArray1475[textureId] = false;
            for (int l1 = 0; l1 < 16384; ++l1) {
                int n = l1;
                texels[n] = texels[n] & 0xF8F8FF;
                int k2 = texels[l1];
                if (k2 == 0) {
                    Rasterizer.aBooleanArray1475[textureId] = true;
                }
                texels[16384 + l1] = k2 - (k2 >>> 3) & 0xF8F8FF;
                texels[32768 + l1] = k2 - (k2 >>> 2) & 0xF8F8FF;
                texels[49152 + l1] = k2 - (k2 >>> 2) - (k2 >>> 3) & 0xF8F8FF;
            }
        }
        return texels;
    }

    public static void adjustBrightness(double d) {
        Texture.setBrightness(d);
        int j = 0;
        for (int k = 0; k < 512; ++k) {
            double d1 = (double)(k / 8) / 64.0 + 0.0078125;
            double d2 = (double)(k & 7) / 8.0 + 0.0625;
            for (int k1 = 0; k1 < 128; ++k1) {
                double d3;
                double d4 = d3 = (double)k1 / 128.0;
                double d5 = d3;
                double d6 = d3;
                if (d2 != 0.0) {
                    double d7 = d3 < 0.5 ? d3 * (1.0 + d2) : d3 + d2 - d3 * d2;
                    double d8 = 2.0 * d3 - d7;
                    double d9 = d1 + 0.3333333333333333;
                    if (d9 > 1.0) {
                        d9 -= 1.0;
                    }
                    double d10 = d1;
                    double d11 = d1 - 0.3333333333333333;
                    if (d11 < 0.0) {
                        d11 += 1.0;
                    }
                    d4 = 6.0 * d9 < 1.0 ? d8 + (d7 - d8) * 6.0 * d9 : (2.0 * d9 < 1.0 ? d7 : (3.0 * d9 < 2.0 ? d8 + (d7 - d8) * (0.6666666666666666 - d9) * 6.0 : d8));
                    d5 = 6.0 * d10 < 1.0 ? d8 + (d7 - d8) * 6.0 * d10 : (2.0 * d10 < 1.0 ? d7 : (3.0 * d10 < 2.0 ? d8 + (d7 - d8) * (0.6666666666666666 - d10) * 6.0 : d8));
                    d6 = 6.0 * d11 < 1.0 ? d8 + (d7 - d8) * 6.0 * d11 : (2.0 * d11 < 1.0 ? d7 : (3.0 * d11 < 2.0 ? d8 + (d7 - d8) * (0.6666666666666666 - d11) * 6.0 : d8));
                }
                int l1 = (int)(d4 * 256.0);
                int i2 = (int)(d5 * 256.0);
                int j2 = (int)(d6 * 256.0);
                int k2 = (l1 << 16) + (i2 << 8) + j2;
                if ((k2 = Rasterizer.setGamma(k2, d)) == 0) {
                    k2 = 1;
                }
                Rasterizer.hsl2rgb[j++] = k2;
            }
        }
        for (int l = 0; l < textureCount; ++l) {
            if (textures[l] == null) continue;
            int[] ai = Rasterizer.textures[l].palette;
            Rasterizer.texturePalette[l] = new int[ai.length];
            for (int j1 = 0; j1 < ai.length; ++j1) {
                Rasterizer.texturePalette[l][j1] = Rasterizer.setGamma(ai[j1], d);
                if ((texturePalette[l][j1] & 0xF8F8FF) != 0 || j1 == 0) continue;
                Rasterizer.texturePalette[l][j1] = 1;
            }
        }
        for (int i1 = 0; i1 < textureCount; ++i1) {
            Rasterizer.pushTexture(i1);
        }
    }

    public static void adjustBrightnessForTexture(int id, double d) {
        Texture.setBrightness(d);
        if (textures[id] != null) {
            int[] palette = Rasterizer.textures[id].palette;
            Rasterizer.texturePalette[id] = new int[palette.length];
            for (int j1 = 0; j1 < palette.length; ++j1) {
                Rasterizer.texturePalette[id][j1] = Rasterizer.setGamma(palette[j1], d);
                if ((texturePalette[id][j1] & 0xF8F8FF) != 0 || j1 == 0) continue;
                Rasterizer.texturePalette[id][j1] = 1;
            }
        }
        Rasterizer.pushTexture(id);
    }

    private static int setGamma(int rgb, double gamma) {
        double d1 = (double)(rgb >> 16) / 256.0;
        double d2 = (double)(rgb >> 8 & 0xFF) / 256.0;
        double d3 = (double)(rgb & 0xFF) / 256.0;
        d1 = Math.pow(d1, gamma);
        d2 = Math.pow(d2, gamma);
        d3 = Math.pow(d3, gamma);
        int j = (int)(d1 * 256.0);
        int k = (int)(d2 * 256.0);
        int l = (int)(d3 * 256.0);
        return (j << 16) + (k << 8) + l;
    }

    public static void drawGouraudTriangle(int y_a, int y_b, int y_c, int x_a, int x_b, int x_c, int hsl1, int hsl2, int hsl3, float z_a, float z_b, float z_c) {
        Rasterizer.drawGouraudTriangle(y_a, y_b, y_c, x_a, x_b, x_c, hsl1, hsl2, hsl3, z_a, z_b, z_c, false);
    }

    public static void drawGouraudTriangle(int y_a, int y_b, int y_c, int x_a, int x_b, int x_c, int hsl1, int hsl2, int hsl3, float z_a, float z_b, float z_c, boolean ignoreBuffer) {
        boolean bl = saveDepth = Configuration.DEPTH_BUFFER && !ignoreBuffer;
        if (Configuration.hdShading) {
            Rasterizer.drawShadedGouraudTriangle(y_a, y_b, y_c, x_a, x_b, x_c, hsl1, hsl2, hsl3, z_a, z_b, z_c);
        } else {
            Rasterizer.drawLDGouraudTriangle(y_a, y_b, y_c, x_a, x_b, x_c, hsl1, hsl2, hsl3, z_a, z_b, z_c);
        }
    }

    public static void drawShadedGouraudTriangle(int y_a, int y_b, int y_c, int x_a, int x_b, int x_c, int hsl1, int hsl2, int hsl3, float z_a, float z_b, float z_c) {
        if (z_a < 0.0f || z_b < 0.0f || z_c < 0.0f) {
            return;
        }
        int rgb1 = hsl2rgb[hsl1];
        int rgb2 = hsl2rgb[hsl2];
        int rgb3 = hsl2rgb[hsl3];
        int r1 = rgb1 >> 16 & 0xFF;
        int g1 = rgb1 >> 8 & 0xFF;
        int b1 = rgb1 & 0xFF;
        int r2 = rgb2 >> 16 & 0xFF;
        int g2 = rgb2 >> 8 & 0xFF;
        int b2 = rgb2 & 0xFF;
        int r3 = rgb3 >> 16 & 0xFF;
        int g3 = rgb3 >> 8 & 0xFF;
        int b3 = rgb3 & 0xFF;
        int a_to_b = 0;
        int dr1 = 0;
        int dg1 = 0;
        int db1 = 0;
        if (y_b != y_a) {
            a_to_b = (x_b - x_a << 16) / (y_b - y_a);
            dr1 = (r2 - r1 << 16) / (y_b - y_a);
            dg1 = (g2 - g1 << 16) / (y_b - y_a);
            db1 = (b2 - b1 << 16) / (y_b - y_a);
        }
        int b_to_c = 0;
        int dr2 = 0;
        int dg2 = 0;
        int db2 = 0;
        if (y_c != y_b) {
            b_to_c = (x_c - x_b << 16) / (y_c - y_b);
            dr2 = (r3 - r2 << 16) / (y_c - y_b);
            dg2 = (g3 - g2 << 16) / (y_c - y_b);
            db2 = (b3 - b2 << 16) / (y_c - y_b);
        }
        int c_to_a = 0;
        int dr3 = 0;
        int dg3 = 0;
        int db3 = 0;
        if (y_c != y_a) {
            c_to_a = (x_a - x_c << 16) / (y_a - y_c);
            dr3 = (r1 - r3 << 16) / (y_a - y_c);
            dg3 = (g1 - g3 << 16) / (y_a - y_c);
            db3 = (b1 - b3 << 16) / (y_a - y_c);
        }
        float b_aX = x_b - x_a;
        float b_aY = y_b - y_a;
        float c_aX = x_c - x_a;
        float c_aY = y_c - y_a;
        float b_aZ = z_b - z_a;
        float c_aZ = z_c - z_a;
        float div = b_aX * c_aY - c_aX * b_aY;
        float depth_slope = (b_aZ * c_aY - c_aZ * b_aY) / div;
        float depth_increment = (c_aZ * b_aX - b_aZ * c_aX) / div;
        if (y_a <= y_b && y_a <= y_c) {
            if (y_a >= DrawingArea.clipBottom) {
                return;
            }
            if (y_b > DrawingArea.clipBottom) {
                y_b = DrawingArea.clipBottom;
            }
            if (y_c > DrawingArea.clipBottom) {
                y_c = DrawingArea.clipBottom;
            }
            z_a = z_a - depth_slope * (float)x_a + depth_slope;
            if (y_b < y_c) {
                x_c = x_a <<= 16;
                r3 = r1 <<= 16;
                g3 = g1 <<= 16;
                b3 = b1 <<= 16;
                if (y_a < 0) {
                    x_c -= c_to_a * y_a;
                    x_a -= a_to_b * y_a;
                    r3 -= dr3 * y_a;
                    g3 -= dg3 * y_a;
                    b3 -= db3 * y_a;
                    r1 -= dr1 * y_a;
                    g1 -= dg1 * y_a;
                    b1 -= db1 * y_a;
                    z_a -= depth_increment * (float)y_a;
                    y_a = 0;
                }
                x_b <<= 16;
                r2 <<= 16;
                g2 <<= 16;
                b2 <<= 16;
                if (y_b < 0) {
                    x_b -= b_to_c * y_b;
                    r2 -= dr2 * y_b;
                    g2 -= dg2 * y_b;
                    b2 -= db2 * y_b;
                    y_b = 0;
                }
                if (y_a != y_b && c_to_a < a_to_b || y_a == y_b && c_to_a > b_to_c) {
                    y_c -= y_b;
                    y_b -= y_a;
                    y_a = lineOffsets[y_a];
                    while (--y_b >= 0) {
                        Rasterizer.drawShadedGouraudScanline(DrawingArea.raster, y_a, x_c >> 16, x_a >> 16, r3, g3, b3, r1, g1, b1, z_a, depth_slope);
                        x_c += c_to_a;
                        x_a += a_to_b;
                        r3 += dr3;
                        g3 += dg3;
                        b3 += db3;
                        r1 += dr1;
                        g1 += dg1;
                        b1 += db1;
                        z_a += depth_increment;
                        y_a += DrawingArea.width;
                    }
                    while (--y_c >= 0) {
                        Rasterizer.drawShadedGouraudScanline(DrawingArea.raster, y_a, x_c >> 16, x_b >> 16, r3, g3, b3, r2, g2, b2, z_a, depth_slope);
                        x_c += c_to_a;
                        x_b += b_to_c;
                        r3 += dr3;
                        g3 += dg3;
                        b3 += db3;
                        r2 += dr2;
                        g2 += dg2;
                        b2 += db2;
                        y_a += DrawingArea.width;
                        z_a += depth_increment;
                    }
                    return;
                }
                y_c -= y_b;
                y_b -= y_a;
                y_a = lineOffsets[y_a];
                while (--y_b >= 0) {
                    Rasterizer.drawShadedGouraudScanline(DrawingArea.raster, y_a, x_a >> 16, x_c >> 16, r1, g1, b1, r3, g3, b3, z_a, depth_slope);
                    x_c += c_to_a;
                    x_a += a_to_b;
                    r3 += dr3;
                    g3 += dg3;
                    b3 += db3;
                    r1 += dr1;
                    g1 += dg1;
                    b1 += db1;
                    z_a += depth_increment;
                    y_a += DrawingArea.width;
                }
                while (--y_c >= 0) {
                    Rasterizer.drawShadedGouraudScanline(DrawingArea.raster, y_a, x_b >> 16, x_c >> 16, r2, g2, b2, r3, g3, b3, z_a, depth_slope);
                    x_c += c_to_a;
                    x_b += b_to_c;
                    r3 += dr3;
                    g3 += dg3;
                    b3 += db3;
                    r2 += dr2;
                    g2 += dg2;
                    b2 += db2;
                    y_a += DrawingArea.width;
                    z_a += depth_increment;
                }
                return;
            }
            x_b = x_a <<= 16;
            r2 = r1 <<= 16;
            g2 = g1 <<= 16;
            b2 = b1 <<= 16;
            if (y_a < 0) {
                x_b -= c_to_a * y_a;
                x_a -= a_to_b * y_a;
                r2 -= dr3 * y_a;
                g2 -= dg3 * y_a;
                b2 -= db3 * y_a;
                r1 -= dr1 * y_a;
                g1 -= dg1 * y_a;
                b1 -= db1 * y_a;
                z_a -= depth_increment * (float)y_a;
                y_a = 0;
            }
            x_c <<= 16;
            r3 <<= 16;
            g3 <<= 16;
            b3 <<= 16;
            if (y_c < 0) {
                x_c -= b_to_c * y_c;
                r3 -= dr2 * y_c;
                g3 -= dg2 * y_c;
                b3 -= db2 * y_c;
                y_c = 0;
            }
            if (y_a != y_c && c_to_a < a_to_b || y_a == y_c && b_to_c > a_to_b) {
                y_b -= y_c;
                y_c -= y_a;
                y_a = lineOffsets[y_a];
                while (--y_c >= 0) {
                    Rasterizer.drawShadedGouraudScanline(DrawingArea.raster, y_a, x_b >> 16, x_a >> 16, r2, g2, b2, r1, g1, b1, z_a, depth_slope);
                    x_b += c_to_a;
                    x_a += a_to_b;
                    r2 += dr3;
                    g2 += dg3;
                    b2 += db3;
                    r1 += dr1;
                    g1 += dg1;
                    b1 += db1;
                    z_a += depth_increment;
                    y_a += DrawingArea.width;
                }
                while (--y_b >= 0) {
                    Rasterizer.drawShadedGouraudScanline(DrawingArea.raster, y_a, x_c >> 16, x_a >> 16, r3, g3, b3, r1, g1, b1, z_a, depth_slope);
                    x_c += b_to_c;
                    x_a += a_to_b;
                    r3 += dr2;
                    g3 += dg2;
                    b3 += db2;
                    r1 += dr1;
                    g1 += dg1;
                    b1 += db1;
                    y_a += DrawingArea.width;
                    z_a += depth_increment;
                }
                return;
            }
            y_b -= y_c;
            y_c -= y_a;
            y_a = lineOffsets[y_a];
            while (--y_c >= 0) {
                Rasterizer.drawShadedGouraudScanline(DrawingArea.raster, y_a, x_a >> 16, x_b >> 16, r1, g1, b1, r2, g2, b2, z_a, depth_slope);
                x_b += c_to_a;
                x_a += a_to_b;
                r2 += dr3;
                g2 += dg3;
                b2 += db3;
                r1 += dr1;
                g1 += dg1;
                b1 += db1;
                z_a += depth_increment;
                y_a += DrawingArea.width;
            }
            while (--y_b >= 0) {
                Rasterizer.drawShadedGouraudScanline(DrawingArea.raster, y_a, x_a >> 16, x_c >> 16, r1, g1, b1, r3, g3, b3, z_a, depth_slope);
                x_c += b_to_c;
                x_a += a_to_b;
                r3 += dr2;
                g3 += dg2;
                b3 += db2;
                r1 += dr1;
                g1 += dg1;
                b1 += db1;
                y_a += DrawingArea.width;
                z_a += depth_increment;
            }
            return;
        }
        if (y_b <= y_c) {
            if (y_b >= DrawingArea.clipBottom) {
                return;
            }
            if (y_c > DrawingArea.clipBottom) {
                y_c = DrawingArea.clipBottom;
            }
            if (y_a > DrawingArea.clipBottom) {
                y_a = DrawingArea.clipBottom;
            }
            z_b = z_b - depth_slope * (float)x_b + depth_slope;
            if (y_c < y_a) {
                x_a = x_b <<= 16;
                r1 = r2 <<= 16;
                g1 = g2 <<= 16;
                b1 = b2 <<= 16;
                if (y_b < 0) {
                    x_a -= a_to_b * y_b;
                    x_b -= b_to_c * y_b;
                    r1 -= dr1 * y_b;
                    g1 -= dg1 * y_b;
                    b1 -= db1 * y_b;
                    r2 -= dr2 * y_b;
                    g2 -= dg2 * y_b;
                    b2 -= db2 * y_b;
                    z_b -= depth_increment * (float)y_b;
                    y_b = 0;
                }
                x_c <<= 16;
                r3 <<= 16;
                g3 <<= 16;
                b3 <<= 16;
                if (y_c < 0) {
                    x_c -= c_to_a * y_c;
                    r3 -= dr3 * y_c;
                    g3 -= dg3 * y_c;
                    b3 -= db3 * y_c;
                    y_c = 0;
                }
                if (y_b != y_c && a_to_b < b_to_c || y_b == y_c && a_to_b > c_to_a) {
                    y_a -= y_c;
                    y_c -= y_b;
                    y_b = lineOffsets[y_b];
                    while (--y_c >= 0) {
                        Rasterizer.drawShadedGouraudScanline(DrawingArea.raster, y_b, x_a >> 16, x_b >> 16, r1, g1, b1, r2, g2, b2, z_b, depth_slope);
                        x_a += a_to_b;
                        x_b += b_to_c;
                        r1 += dr1;
                        g1 += dg1;
                        b1 += db1;
                        r2 += dr2;
                        g2 += dg2;
                        b2 += db2;
                        z_b += depth_increment;
                        y_b += DrawingArea.width;
                    }
                    while (--y_a >= 0) {
                        Rasterizer.drawShadedGouraudScanline(DrawingArea.raster, y_b, x_a >> 16, x_c >> 16, r1, g1, b1, r3, g3, b3, z_b, depth_slope);
                        x_a += a_to_b;
                        x_c += c_to_a;
                        r1 += dr1;
                        g1 += dg1;
                        b1 += db1;
                        r3 += dr3;
                        g3 += dg3;
                        b3 += db3;
                        y_b += DrawingArea.width;
                        z_b += depth_increment;
                    }
                    return;
                }
                y_a -= y_c;
                y_c -= y_b;
                y_b = lineOffsets[y_b];
                while (--y_c >= 0) {
                    Rasterizer.drawShadedGouraudScanline(DrawingArea.raster, y_b, x_b >> 16, x_a >> 16, r2, g2, b2, r1, g1, b1, z_b, depth_slope);
                    x_a += a_to_b;
                    x_b += b_to_c;
                    r1 += dr1;
                    g1 += dg1;
                    b1 += db1;
                    r2 += dr2;
                    g2 += dg2;
                    b2 += db2;
                    z_b += depth_increment;
                    y_b += DrawingArea.width;
                }
                while (--y_a >= 0) {
                    Rasterizer.drawShadedGouraudScanline(DrawingArea.raster, y_b, x_c >> 16, x_a >> 16, r3, g3, b3, r1, g1, b1, z_b, depth_slope);
                    x_a += a_to_b;
                    x_c += c_to_a;
                    r1 += dr1;
                    g1 += dg1;
                    b1 += db1;
                    r3 += dr3;
                    g3 += dg3;
                    b3 += db3;
                    y_b += DrawingArea.width;
                    z_b += depth_increment;
                }
                return;
            }
            x_c = x_b <<= 16;
            r3 = r2 <<= 16;
            g3 = g2 <<= 16;
            b3 = b2 <<= 16;
            if (y_b < 0) {
                x_c -= a_to_b * y_b;
                x_b -= b_to_c * y_b;
                r3 -= dr1 * y_b;
                g3 -= dg1 * y_b;
                b3 -= db1 * y_b;
                r2 -= dr2 * y_b;
                g2 -= dg2 * y_b;
                b2 -= db2 * y_b;
                z_b -= depth_increment * (float)y_b;
                y_b = 0;
            }
            x_a <<= 16;
            r1 <<= 16;
            g1 <<= 16;
            b1 <<= 16;
            if (y_a < 0) {
                x_a -= c_to_a * y_a;
                r1 -= dr3 * y_a;
                g1 -= dg3 * y_a;
                b1 -= db3 * y_a;
                y_a = 0;
            }
            if (a_to_b < b_to_c) {
                y_c -= y_a;
                y_a -= y_b;
                y_b = lineOffsets[y_b];
                while (--y_a >= 0) {
                    Rasterizer.drawShadedGouraudScanline(DrawingArea.raster, y_b, x_c >> 16, x_b >> 16, r3, g3, b3, r2, g2, b2, z_b, depth_slope);
                    x_c += a_to_b;
                    x_b += b_to_c;
                    r3 += dr1;
                    g3 += dg1;
                    b3 += db1;
                    r2 += dr2;
                    g2 += dg2;
                    b2 += db2;
                    z_b += depth_increment;
                    y_b += DrawingArea.width;
                }
                while (--y_c >= 0) {
                    Rasterizer.drawShadedGouraudScanline(DrawingArea.raster, y_b, x_a >> 16, x_b >> 16, r1, g1, b1, r2, g2, b2, z_b, depth_slope);
                    x_a += c_to_a;
                    x_b += b_to_c;
                    r1 += dr3;
                    g1 += dg3;
                    b1 += db3;
                    r2 += dr2;
                    g2 += dg2;
                    b2 += db2;
                    y_b += DrawingArea.width;
                    z_b += depth_increment;
                }
                return;
            }
            y_c -= y_a;
            y_a -= y_b;
            y_b = lineOffsets[y_b];
            while (--y_a >= 0) {
                Rasterizer.drawShadedGouraudScanline(DrawingArea.raster, y_b, x_b >> 16, x_c >> 16, r2, g2, b2, r3, g3, b3, z_b, depth_slope);
                x_c += a_to_b;
                x_b += b_to_c;
                r3 += dr1;
                g3 += dg1;
                b3 += db1;
                r2 += dr2;
                g2 += dg2;
                b2 += db2;
                z_b += depth_increment;
                y_b += DrawingArea.width;
            }
            while (--y_c >= 0) {
                Rasterizer.drawShadedGouraudScanline(DrawingArea.raster, y_b, x_b >> 16, x_a >> 16, r2, g2, b2, r1, g1, b1, z_b, depth_slope);
                x_a += c_to_a;
                x_b += b_to_c;
                r1 += dr3;
                g1 += dg3;
                b1 += db3;
                r2 += dr2;
                g2 += dg2;
                b2 += db2;
                y_b += DrawingArea.width;
                z_b += depth_increment;
            }
            return;
        }
        if (y_c >= DrawingArea.clipBottom) {
            return;
        }
        if (y_a > DrawingArea.clipBottom) {
            y_a = DrawingArea.clipBottom;
        }
        if (y_b > DrawingArea.clipBottom) {
            y_b = DrawingArea.clipBottom;
        }
        z_c = z_c - depth_slope * (float)x_c + depth_slope;
        if (y_a < y_b) {
            x_b = x_c <<= 16;
            r2 = r3 <<= 16;
            g2 = g3 <<= 16;
            b2 = b3 <<= 16;
            if (y_c < 0) {
                x_b -= b_to_c * y_c;
                x_c -= c_to_a * y_c;
                r2 -= dr2 * y_c;
                g2 -= dg2 * y_c;
                b2 -= db2 * y_c;
                r3 -= dr3 * y_c;
                g3 -= dg3 * y_c;
                b3 -= db3 * y_c;
                z_c -= depth_increment * (float)y_c;
                y_c = 0;
            }
            x_a <<= 16;
            r1 <<= 16;
            g1 <<= 16;
            b1 <<= 16;
            if (y_a < 0) {
                x_a -= a_to_b * y_a;
                r1 -= dr1 * y_a;
                g1 -= dg1 * y_a;
                b1 -= db1 * y_a;
                y_a = 0;
            }
            if (b_to_c < c_to_a) {
                y_b -= y_a;
                y_a -= y_c;
                y_c = lineOffsets[y_c];
                while (--y_a >= 0) {
                    Rasterizer.drawShadedGouraudScanline(DrawingArea.raster, y_c, x_b >> 16, x_c >> 16, r2, g2, b2, r3, g3, b3, z_c, depth_slope);
                    x_b += b_to_c;
                    x_c += c_to_a;
                    r2 += dr2;
                    g2 += dg2;
                    b2 += db2;
                    r3 += dr3;
                    g3 += dg3;
                    b3 += db3;
                    z_c += depth_increment;
                    y_c += DrawingArea.width;
                }
                while (--y_b >= 0) {
                    Rasterizer.drawShadedGouraudScanline(DrawingArea.raster, y_c, x_b >> 16, x_a >> 16, r2, g2, b2, r1, g1, b1, z_c, depth_slope);
                    x_b += b_to_c;
                    x_a += a_to_b;
                    r2 += dr2;
                    g2 += dg2;
                    b2 += db2;
                    r1 += dr1;
                    g1 += dg1;
                    b1 += db1;
                    y_c += DrawingArea.width;
                    z_c += depth_increment;
                }
                return;
            }
            y_b -= y_a;
            y_a -= y_c;
            y_c = lineOffsets[y_c];
            while (--y_a >= 0) {
                Rasterizer.drawShadedGouraudScanline(DrawingArea.raster, y_c, x_c >> 16, x_b >> 16, r3, g3, b3, r2, g2, b2, z_c, depth_slope);
                x_b += b_to_c;
                x_c += c_to_a;
                r2 += dr2;
                g2 += dg2;
                b2 += db2;
                r3 += dr3;
                g3 += dg3;
                b3 += db3;
                z_c += depth_increment;
                y_c += DrawingArea.width;
            }
            while (--y_b >= 0) {
                Rasterizer.drawShadedGouraudScanline(DrawingArea.raster, y_c, x_a >> 16, x_b >> 16, r1, g1, b1, r2, g2, b2, z_c, depth_slope);
                x_b += b_to_c;
                x_a += a_to_b;
                r2 += dr2;
                g2 += dg2;
                b2 += db2;
                r1 += dr1;
                g1 += dg1;
                b1 += db1;
                z_c += depth_increment;
                y_c += DrawingArea.width;
            }
            return;
        }
        x_a = x_c <<= 16;
        r1 = r3 <<= 16;
        g1 = g3 <<= 16;
        b1 = b3 <<= 16;
        if (y_c < 0) {
            x_a -= b_to_c * y_c;
            x_c -= c_to_a * y_c;
            r1 -= dr2 * y_c;
            g1 -= dg2 * y_c;
            b1 -= db2 * y_c;
            r3 -= dr3 * y_c;
            g3 -= dg3 * y_c;
            b3 -= db3 * y_c;
            z_c -= depth_increment * (float)y_c;
            y_c = 0;
        }
        x_b <<= 16;
        r2 <<= 16;
        g2 <<= 16;
        b2 <<= 16;
        if (y_b < 0) {
            x_b -= a_to_b * y_b;
            r2 -= dr1 * y_b;
            g2 -= dg1 * y_b;
            b2 -= db1 * y_b;
            y_b = 0;
        }
        if (b_to_c < c_to_a) {
            y_a -= y_b;
            y_b -= y_c;
            y_c = lineOffsets[y_c];
            while (--y_b >= 0) {
                Rasterizer.drawShadedGouraudScanline(DrawingArea.raster, y_c, x_a >> 16, x_c >> 16, r1, g1, b1, r3, g3, b3, z_c, depth_slope);
                x_a += b_to_c;
                x_c += c_to_a;
                r1 += dr2;
                g1 += dg2;
                b1 += db2;
                r3 += dr3;
                g3 += dg3;
                b3 += db3;
                z_c += depth_increment;
                y_c += DrawingArea.width;
            }
            while (--y_a >= 0) {
                Rasterizer.drawShadedGouraudScanline(DrawingArea.raster, y_c, x_b >> 16, x_c >> 16, r2, g2, b2, r3, g3, b3, z_c, depth_slope);
                x_b += a_to_b;
                x_c += c_to_a;
                r2 += dr1;
                g2 += dg1;
                b2 += db1;
                r3 += dr3;
                g3 += dg3;
                b3 += db3;
                z_c += depth_increment;
                y_c += DrawingArea.width;
            }
            return;
        }
        y_a -= y_b;
        y_b -= y_c;
        y_c = lineOffsets[y_c];
        while (--y_b >= 0) {
            Rasterizer.drawShadedGouraudScanline(DrawingArea.raster, y_c, x_c >> 16, x_a >> 16, r3, g3, b3, r1, g1, b1, z_c, depth_slope);
            x_a += b_to_c;
            x_c += c_to_a;
            r1 += dr2;
            g1 += dg2;
            b1 += db2;
            r3 += dr3;
            g3 += dg3;
            b3 += db3;
            z_c += depth_increment;
            y_c += DrawingArea.width;
        }
        while (--y_a >= 0) {
            Rasterizer.drawShadedGouraudScanline(DrawingArea.raster, y_c, x_c >> 16, x_b >> 16, r3, g3, b3, r2, g2, b2, z_c, depth_slope);
            x_b += a_to_b;
            x_c += c_to_a;
            r2 += dr1;
            g2 += dg1;
            b2 += db1;
            r3 += dr3;
            g3 += dg3;
            b3 += db3;
            y_c += DrawingArea.width;
            z_c += depth_increment;
        }
    }

    public static void drawShadedGouraudScanline(int[] dest, int offset, int x1, int x2, int r1, int g1, int b1, int r2, int g2, int b2, float depth, float depth_slope) {
        block12: {
            int n = x2 - x1;
            if (n <= 0) {
                return;
            }
            r2 = (r2 - r1) / n;
            g2 = (g2 - g1) / n;
            b2 = (b2 - b1) / n;
            if (restrict_edges) {
                if (x2 > DrawingArea.maxRight) {
                    n -= x2 - DrawingArea.maxRight;
                    x2 = DrawingArea.maxRight;
                }
                if (x1 < 0) {
                    n = x2;
                    r1 -= x1 * r2;
                    g1 -= x1 * g2;
                    b1 -= x1 * b2;
                    x1 = 0;
                }
            }
            if (x1 >= x2) break block12;
            offset += x1;
            depth += depth_slope * (float)x1;
            if (alpha == 0) {
                while (--n >= 0) {
                    if (!saveDepth || depth <= DrawingArea.depthBuffer[offset]) {
                        dest[offset] = r1 & 0xFF0000 | g1 >> 8 & 0xFF00 | b1 >> 16 & 0xFF;
                        if (saveDepth) {
                            DrawingArea.depthBuffer[offset] = depth;
                        }
                    }
                    depth += depth_slope;
                    r1 += r2;
                    g1 += g2;
                    b1 += b2;
                    ++offset;
                }
            } else {
                int a1 = alpha;
                int a2 = 256 - alpha;
                while (--n >= 0) {
                    if (!saveDepth || depth <= DrawingArea.depthBuffer[offset]) {
                        int rgb = r1 & 0xFF0000 | g1 >> 8 & 0xFF00 | b1 >> 16 & 0xFF;
                        rgb = ((rgb & 0xFF00FF) * a2 >> 8 & 0xFF00FF) + ((rgb & 0xFF00) * a2 >> 8 & 0xFF00);
                        int dst = dest[offset];
                        dest[offset] = rgb + ((dst & 0xFF00FF) * a1 >> 8 & 0xFF00FF) + ((dst & 0xFF00) * a1 >> 8 & 0xFF00);
                        if (saveDepth) {
                            DrawingArea.depthBuffer[offset] = depth;
                        }
                    }
                    depth += depth_slope;
                    r1 += r2;
                    g1 += g2;
                    b1 += b2;
                    ++offset;
                }
            }
        }
    }

    public static void drawLDGouraudTriangle(int y_a, int y_b, int y_c, int x_a, int x_b, int x_c, int hsl1, int hsl2, int hsl3, float z_a, float z_b, float z_c) {
        int a_to_b = 0;
        int dhsl1 = 0;
        if (y_b != y_a) {
            a_to_b = (x_b - x_a << 16) / (y_b - y_a);
            dhsl1 = (hsl2 - hsl1 << 15) / (y_b - y_a);
        }
        int b_to_c = 0;
        int dhsl2 = 0;
        if (y_c != y_b) {
            b_to_c = (x_c - x_b << 16) / (y_c - y_b);
            dhsl2 = (hsl3 - hsl2 << 15) / (y_c - y_b);
        }
        int c_to_a = 0;
        int dhsl3 = 0;
        if (y_c != y_a) {
            c_to_a = (x_a - x_c << 16) / (y_a - y_c);
            dhsl3 = (hsl1 - hsl3 << 15) / (y_a - y_c);
        }
        float b_aX = x_b - x_a;
        float b_aY = y_b - y_a;
        float c_aX = x_c - x_a;
        float c_aY = y_c - y_a;
        float b_aZ = z_b - z_a;
        float c_aZ = z_c - z_a;
        float div = b_aX * c_aY - c_aX * b_aY;
        float depth_slope = (b_aZ * c_aY - c_aZ * b_aY) / div;
        float depth_increment = (c_aZ * b_aX - b_aZ * c_aX) / div;
        if (y_a <= y_b && y_a <= y_c) {
            if (y_a >= DrawingArea.clipBottom) {
                return;
            }
            if (y_b > DrawingArea.clipBottom) {
                y_b = DrawingArea.clipBottom;
            }
            if (y_c > DrawingArea.clipBottom) {
                y_c = DrawingArea.clipBottom;
            }
            z_a = z_a - depth_slope * (float)x_a + depth_slope;
            if (y_b < y_c) {
                x_c = x_a <<= 16;
                hsl3 = hsl1 <<= 15;
                if (y_a < 0) {
                    x_c -= c_to_a * y_a;
                    x_a -= a_to_b * y_a;
                    hsl3 -= dhsl3 * y_a;
                    hsl1 -= dhsl1 * y_a;
                    z_a -= depth_increment * (float)y_a;
                    y_a = 0;
                }
                x_b <<= 16;
                hsl2 <<= 15;
                if (y_b < 0) {
                    x_b -= b_to_c * y_b;
                    hsl2 -= dhsl2 * y_b;
                    y_b = 0;
                }
                if (y_a != y_b && c_to_a < a_to_b || y_a == y_b && c_to_a > b_to_c) {
                    y_c -= y_b;
                    y_b -= y_a;
                    y_a = lineOffsets[y_a];
                    while (--y_b >= 0) {
                        Rasterizer.drawGouraudScanline(DrawingArea.raster, y_a, x_c >> 16, x_a >> 16, hsl3 >> 7, hsl1 >> 7, z_a, depth_slope);
                        x_c += c_to_a;
                        x_a += a_to_b;
                        hsl3 += dhsl3;
                        hsl1 += dhsl1;
                        z_a += depth_increment;
                        y_a += DrawingArea.width;
                    }
                    while (--y_c >= 0) {
                        Rasterizer.drawGouraudScanline(DrawingArea.raster, y_a, x_c >> 16, x_b >> 16, hsl3 >> 7, hsl2 >> 7, z_a, depth_slope);
                        x_c += c_to_a;
                        x_b += b_to_c;
                        hsl3 += dhsl3;
                        hsl2 += dhsl2;
                        y_a += DrawingArea.width;
                        z_a += depth_increment;
                    }
                    return;
                }
                y_c -= y_b;
                y_b -= y_a;
                y_a = lineOffsets[y_a];
                while (--y_b >= 0) {
                    Rasterizer.drawGouraudScanline(DrawingArea.raster, y_a, x_a >> 16, x_c >> 16, hsl1 >> 7, hsl3 >> 7, z_a, depth_slope);
                    x_c += c_to_a;
                    x_a += a_to_b;
                    hsl3 += dhsl3;
                    hsl1 += dhsl1;
                    z_a += depth_increment;
                    y_a += DrawingArea.width;
                }
                while (--y_c >= 0) {
                    Rasterizer.drawGouraudScanline(DrawingArea.raster, y_a, x_b >> 16, x_c >> 16, hsl2 >> 7, hsl3 >> 7, z_a, depth_slope);
                    x_c += c_to_a;
                    x_b += b_to_c;
                    hsl3 += dhsl3;
                    hsl2 += dhsl2;
                    y_a += DrawingArea.width;
                    z_a += depth_increment;
                }
                return;
            }
            x_b = x_a <<= 16;
            hsl2 = hsl1 <<= 15;
            if (y_a < 0) {
                x_b -= c_to_a * y_a;
                x_a -= a_to_b * y_a;
                hsl2 -= dhsl3 * y_a;
                hsl1 -= dhsl1 * y_a;
                z_a -= depth_increment * (float)y_a;
                y_a = 0;
            }
            x_c <<= 16;
            hsl3 <<= 15;
            if (y_c < 0) {
                x_c -= b_to_c * y_c;
                hsl3 -= dhsl2 * y_c;
                y_c = 0;
            }
            if (y_a != y_c && c_to_a < a_to_b || y_a == y_c && b_to_c > a_to_b) {
                y_b -= y_c;
                y_c -= y_a;
                y_a = lineOffsets[y_a];
                while (--y_c >= 0) {
                    Rasterizer.drawGouraudScanline(DrawingArea.raster, y_a, x_b >> 16, x_a >> 16, hsl2 >> 7, hsl1 >> 7, z_a, depth_slope);
                    x_b += c_to_a;
                    x_a += a_to_b;
                    hsl2 += dhsl3;
                    hsl1 += dhsl1;
                    z_a += depth_increment;
                    y_a += DrawingArea.width;
                }
                while (--y_b >= 0) {
                    Rasterizer.drawGouraudScanline(DrawingArea.raster, y_a, x_c >> 16, x_a >> 16, hsl3 >> 7, hsl1 >> 7, z_a, depth_slope);
                    x_c += b_to_c;
                    x_a += a_to_b;
                    hsl3 += dhsl2;
                    hsl1 += dhsl1;
                    y_a += DrawingArea.width;
                    z_a += depth_increment;
                }
                return;
            }
            y_b -= y_c;
            y_c -= y_a;
            y_a = lineOffsets[y_a];
            while (--y_c >= 0) {
                Rasterizer.drawGouraudScanline(DrawingArea.raster, y_a, x_a >> 16, x_b >> 16, hsl1 >> 7, hsl2 >> 7, z_a, depth_slope);
                x_b += c_to_a;
                x_a += a_to_b;
                hsl2 += dhsl3;
                hsl1 += dhsl1;
                z_a += depth_increment;
                y_a += DrawingArea.width;
            }
            while (--y_b >= 0) {
                Rasterizer.drawGouraudScanline(DrawingArea.raster, y_a, x_a >> 16, x_c >> 16, hsl1 >> 7, hsl3 >> 7, z_a, depth_slope);
                x_c += b_to_c;
                x_a += a_to_b;
                hsl3 += dhsl2;
                hsl1 += dhsl1;
                y_a += DrawingArea.width;
                z_a += depth_increment;
            }
            return;
        }
        if (y_b <= y_c) {
            if (y_b >= DrawingArea.clipBottom) {
                return;
            }
            if (y_c > DrawingArea.clipBottom) {
                y_c = DrawingArea.clipBottom;
            }
            if (y_a > DrawingArea.clipBottom) {
                y_a = DrawingArea.clipBottom;
            }
            z_b = z_b - depth_slope * (float)x_b + depth_slope;
            if (y_c < y_a) {
                x_a = x_b <<= 16;
                hsl1 = hsl2 <<= 15;
                if (y_b < 0) {
                    x_a -= a_to_b * y_b;
                    x_b -= b_to_c * y_b;
                    hsl1 -= dhsl1 * y_b;
                    hsl2 -= dhsl2 * y_b;
                    z_b -= depth_increment * (float)y_b;
                    y_b = 0;
                }
                x_c <<= 16;
                hsl3 <<= 15;
                if (y_c < 0) {
                    x_c -= c_to_a * y_c;
                    hsl3 -= dhsl3 * y_c;
                    y_c = 0;
                }
                if (y_b != y_c && a_to_b < b_to_c || y_b == y_c && a_to_b > c_to_a) {
                    y_a -= y_c;
                    y_c -= y_b;
                    y_b = lineOffsets[y_b];
                    while (--y_c >= 0) {
                        Rasterizer.drawGouraudScanline(DrawingArea.raster, y_b, x_a >> 16, x_b >> 16, hsl1 >> 7, hsl2 >> 7, z_b, depth_slope);
                        x_a += a_to_b;
                        x_b += b_to_c;
                        hsl1 += dhsl1;
                        hsl2 += dhsl2;
                        z_b += depth_increment;
                        y_b += DrawingArea.width;
                    }
                    while (--y_a >= 0) {
                        Rasterizer.drawGouraudScanline(DrawingArea.raster, y_b, x_a >> 16, x_c >> 16, hsl1 >> 7, hsl3 >> 7, z_b, depth_slope);
                        x_a += a_to_b;
                        x_c += c_to_a;
                        hsl1 += dhsl1;
                        hsl3 += dhsl3;
                        y_b += DrawingArea.width;
                        z_b += depth_increment;
                    }
                    return;
                }
                y_a -= y_c;
                y_c -= y_b;
                y_b = lineOffsets[y_b];
                while (--y_c >= 0) {
                    Rasterizer.drawGouraudScanline(DrawingArea.raster, y_b, x_b >> 16, x_a >> 16, hsl2 >> 7, hsl1 >> 7, z_b, depth_slope);
                    x_a += a_to_b;
                    x_b += b_to_c;
                    hsl1 += dhsl1;
                    hsl2 += dhsl2;
                    z_b += depth_increment;
                    y_b += DrawingArea.width;
                }
                while (--y_a >= 0) {
                    Rasterizer.drawGouraudScanline(DrawingArea.raster, y_b, x_c >> 16, x_a >> 16, hsl3 >> 7, hsl1 >> 7, z_b, depth_slope);
                    x_a += a_to_b;
                    x_c += c_to_a;
                    hsl1 += dhsl1;
                    hsl3 += dhsl3;
                    y_b += DrawingArea.width;
                    z_b += depth_increment;
                }
                return;
            }
            x_c = x_b <<= 16;
            hsl3 = hsl2 <<= 15;
            if (y_b < 0) {
                x_c -= a_to_b * y_b;
                x_b -= b_to_c * y_b;
                hsl3 -= dhsl1 * y_b;
                hsl2 -= dhsl2 * y_b;
                z_b -= depth_increment * (float)y_b;
                y_b = 0;
            }
            x_a <<= 16;
            hsl1 <<= 15;
            if (y_a < 0) {
                x_a -= c_to_a * y_a;
                hsl1 -= dhsl3 * y_a;
                y_a = 0;
            }
            if (a_to_b < b_to_c) {
                y_c -= y_a;
                y_a -= y_b;
                y_b = lineOffsets[y_b];
                while (--y_a >= 0) {
                    Rasterizer.drawGouraudScanline(DrawingArea.raster, y_b, x_c >> 16, x_b >> 16, hsl3 >> 7, hsl2 >> 7, z_b, depth_slope);
                    x_c += a_to_b;
                    x_b += b_to_c;
                    hsl3 += dhsl1;
                    hsl2 += dhsl2;
                    z_b += depth_increment;
                    y_b += DrawingArea.width;
                }
                while (--y_c >= 0) {
                    Rasterizer.drawGouraudScanline(DrawingArea.raster, y_b, x_a >> 16, x_b >> 16, hsl1 >> 7, hsl2 >> 7, z_b, depth_slope);
                    x_a += c_to_a;
                    x_b += b_to_c;
                    hsl1 += dhsl3;
                    hsl2 += dhsl2;
                    y_b += DrawingArea.width;
                    z_b += depth_increment;
                }
                return;
            }
            y_c -= y_a;
            y_a -= y_b;
            y_b = lineOffsets[y_b];
            while (--y_a >= 0) {
                Rasterizer.drawGouraudScanline(DrawingArea.raster, y_b, x_b >> 16, x_c >> 16, hsl2 >> 7, hsl3 >> 7, z_b, depth_slope);
                x_c += a_to_b;
                x_b += b_to_c;
                hsl3 += dhsl1;
                hsl2 += dhsl2;
                z_b += depth_increment;
                y_b += DrawingArea.width;
            }
            while (--y_c >= 0) {
                Rasterizer.drawGouraudScanline(DrawingArea.raster, y_b, x_b >> 16, x_a >> 16, hsl2 >> 7, hsl1 >> 7, z_b, depth_slope);
                x_a += c_to_a;
                x_b += b_to_c;
                hsl1 += dhsl3;
                hsl2 += dhsl2;
                y_b += DrawingArea.width;
                z_b += depth_increment;
            }
            return;
        }
        if (y_c >= DrawingArea.clipBottom) {
            return;
        }
        if (y_a > DrawingArea.clipBottom) {
            y_a = DrawingArea.clipBottom;
        }
        if (y_b > DrawingArea.clipBottom) {
            y_b = DrawingArea.clipBottom;
        }
        z_c = z_c - depth_slope * (float)x_c + depth_slope;
        if (y_a < y_b) {
            x_b = x_c <<= 16;
            hsl2 = hsl3 <<= 15;
            if (y_c < 0) {
                x_b -= b_to_c * y_c;
                x_c -= c_to_a * y_c;
                hsl2 -= dhsl2 * y_c;
                hsl3 -= dhsl3 * y_c;
                z_c -= depth_increment * (float)y_c;
                y_c = 0;
            }
            x_a <<= 16;
            hsl1 <<= 15;
            if (y_a < 0) {
                x_a -= a_to_b * y_a;
                hsl1 -= dhsl1 * y_a;
                y_a = 0;
            }
            if (b_to_c < c_to_a) {
                y_b -= y_a;
                y_a -= y_c;
                y_c = lineOffsets[y_c];
                while (--y_a >= 0) {
                    Rasterizer.drawGouraudScanline(DrawingArea.raster, y_c, x_b >> 16, x_c >> 16, hsl2 >> 7, hsl3 >> 7, z_c, depth_slope);
                    x_b += b_to_c;
                    x_c += c_to_a;
                    hsl2 += dhsl2;
                    hsl3 += dhsl3;
                    z_c += depth_increment;
                    y_c += DrawingArea.width;
                }
                while (--y_b >= 0) {
                    Rasterizer.drawGouraudScanline(DrawingArea.raster, y_c, x_b >> 16, x_a >> 16, hsl2 >> 7, hsl1 >> 7, z_c, depth_slope);
                    x_b += b_to_c;
                    x_a += a_to_b;
                    hsl2 += dhsl2;
                    hsl1 += dhsl1;
                    y_c += DrawingArea.width;
                    z_c += depth_increment;
                }
                return;
            }
            y_b -= y_a;
            y_a -= y_c;
            y_c = lineOffsets[y_c];
            while (--y_a >= 0) {
                Rasterizer.drawGouraudScanline(DrawingArea.raster, y_c, x_c >> 16, x_b >> 16, hsl3 >> 7, hsl2 >> 7, z_c, depth_slope);
                x_b += b_to_c;
                x_c += c_to_a;
                hsl2 += dhsl2;
                hsl3 += dhsl3;
                z_c += depth_increment;
                y_c += DrawingArea.width;
            }
            while (--y_b >= 0) {
                Rasterizer.drawGouraudScanline(DrawingArea.raster, y_c, x_a >> 16, x_b >> 16, hsl1 >> 7, hsl2 >> 7, z_c, depth_slope);
                x_b += b_to_c;
                x_a += a_to_b;
                hsl2 += dhsl2;
                hsl1 += dhsl1;
                z_c += depth_increment;
                y_c += DrawingArea.width;
            }
            return;
        }
        x_a = x_c <<= 16;
        hsl1 = hsl3 <<= 15;
        if (y_c < 0) {
            x_a -= b_to_c * y_c;
            x_c -= c_to_a * y_c;
            hsl1 -= dhsl2 * y_c;
            hsl3 -= dhsl3 * y_c;
            z_c -= depth_increment * (float)y_c;
            y_c = 0;
        }
        x_b <<= 16;
        hsl2 <<= 15;
        if (y_b < 0) {
            x_b -= a_to_b * y_b;
            hsl2 -= dhsl1 * y_b;
            y_b = 0;
        }
        if (b_to_c < c_to_a) {
            y_a -= y_b;
            y_b -= y_c;
            y_c = lineOffsets[y_c];
            while (--y_b >= 0) {
                Rasterizer.drawGouraudScanline(DrawingArea.raster, y_c, x_a >> 16, x_c >> 16, hsl1 >> 7, hsl3 >> 7, z_c, depth_slope);
                x_a += b_to_c;
                x_c += c_to_a;
                hsl1 += dhsl2;
                hsl3 += dhsl3;
                z_c += depth_increment;
                y_c += DrawingArea.width;
            }
            while (--y_a >= 0) {
                Rasterizer.drawGouraudScanline(DrawingArea.raster, y_c, x_b >> 16, x_c >> 16, hsl2 >> 7, hsl3 >> 7, z_c, depth_slope);
                x_b += a_to_b;
                x_c += c_to_a;
                hsl2 += dhsl1;
                hsl3 += dhsl3;
                z_c += depth_increment;
                y_c += DrawingArea.width;
            }
            return;
        }
        y_a -= y_b;
        y_b -= y_c;
        y_c = lineOffsets[y_c];
        while (--y_b >= 0) {
            Rasterizer.drawGouraudScanline(DrawingArea.raster, y_c, x_c >> 16, x_a >> 16, hsl3 >> 7, hsl1 >> 7, z_c, depth_slope);
            x_a += b_to_c;
            x_c += c_to_a;
            hsl1 += dhsl2;
            hsl3 += dhsl3;
            z_c += depth_increment;
            y_c += DrawingArea.width;
        }
        while (--y_a >= 0) {
            Rasterizer.drawGouraudScanline(DrawingArea.raster, y_c, x_c >> 16, x_b >> 16, hsl3 >> 7, hsl2 >> 7, z_c, depth_slope);
            x_b += a_to_b;
            x_c += c_to_a;
            hsl2 += dhsl1;
            hsl3 += dhsl3;
            y_c += DrawingArea.width;
            z_c += depth_increment;
        }
    }

    public static void drawGouraudScanline(int[] raster, int offset, int x1, int x2, int hsl1, int hsl2, float depth, float depth_slope) {
        int dhsl = 0;
        if (restrict_edges) {
            if (x2 > DrawingArea.maxRight) {
                x2 = DrawingArea.maxRight;
            }
            if (x1 < 0) {
                hsl1 -= x1 * dhsl;
                x1 = 0;
            }
        }
        if (x1 < x2) {
            offset += x1;
            depth += depth_slope * (float)x1;
            hsl1 += dhsl * x1;
            if (notTextured) {
                int div = x2 - x1 >> 2;
                dhsl = div > 0 ? (hsl2 - hsl1) * shadowDecay[div] >> 15 : 0;
                if (alpha == 0) {
                    int rgb;
                    if (div > 0) {
                        do {
                            rgb = hsl2rgb[hsl1 >> 8];
                            hsl1 += dhsl;
                            for (int i = 0; i < 4; ++i) {
                                if (!saveDepth || depth <= depthBuffer[offset]) {
                                    raster[offset] = rgb;
                                    if (saveDepth) {
                                        Rasterizer.depthBuffer[offset] = depth;
                                    }
                                }
                                ++offset;
                                depth += depth_slope;
                            }
                        } while (--div > 0);
                    }
                    if ((div = x2 - x1 & 3) > 0) {
                        rgb = hsl2rgb[hsl1 >> 8];
                        do {
                            if (!saveDepth || depth <= depthBuffer[offset]) {
                                raster[offset] = rgb;
                                if (saveDepth) {
                                    Rasterizer.depthBuffer[offset] = depth;
                                }
                            }
                            ++offset;
                            depth += depth_slope;
                        } while (--div > 0);
                    }
                } else {
                    int rgb;
                    int a1 = alpha;
                    int a2 = 256 - alpha;
                    while (--div >= 0) {
                        rgb = hsl2rgb[hsl1 >> 8];
                        hsl1 += dhsl;
                        rgb = ((rgb & 0xFF00FF) * a2 >> 8 & 0xFF00FF) + ((rgb & 0xFF00) * a2 >> 8 & 0xFF00);
                        for (int i = 0; i < 4; ++i) {
                            if (!saveDepth || depth <= depthBuffer[offset]) {
                                raster[offset] = rgb + ((raster[offset] & 0xFF00FF) * a1 >> 8 & 0xFF00FF) + ((raster[offset] & 0xFF00) * a1 >> 8 & 0xFF00);
                                if (saveDepth) {
                                    Rasterizer.depthBuffer[offset] = depth;
                                }
                            }
                            ++offset;
                            depth += depth_slope;
                        }
                    }
                    div = x2 - x1 & 3;
                    if (div > 0) {
                        rgb = hsl2rgb[hsl1 >> 8];
                        rgb = ((rgb & 0xFF00FF) * a2 >> 8 & 0xFF00FF) + ((rgb & 0xFF00) * a2 >> 8 & 0xFF00);
                        do {
                            if (!saveDepth || depth <= depthBuffer[offset]) {
                                raster[offset] = rgb + ((raster[offset] & 0xFF00FF) * a1 >> 8 & 0xFF00FF) + ((raster[offset] & 0xFF00) * a1 >> 8 & 0xFF00);
                                if (saveDepth) {
                                    Rasterizer.depthBuffer[offset] = depth;
                                }
                            }
                            ++offset;
                            depth += depth_slope;
                        } while (--div > 0);
                    }
                }
            } else {
                int i2 = (hsl2 - hsl1) / (x2 - x1);
                int div = x2 - x1;
                if (alpha == 0) {
                    do {
                        if (!saveDepth || depth <= depthBuffer[offset]) {
                            raster[offset] = hsl2rgb[hsl1 >> 8];
                            if (saveDepth) {
                                Rasterizer.depthBuffer[offset] = depth;
                            }
                        }
                        ++offset;
                        hsl1 += i2;
                        depth += depth_slope;
                    } while (--div > 0);
                } else {
                    int a1 = alpha;
                    int a2 = 256 - alpha;
                    do {
                        if (!saveDepth || depth <= depthBuffer[offset]) {
                            int rgb = hsl2rgb[hsl1 >> 8];
                            hsl1 += i2;
                            rgb = ((rgb & 0xFF00FF) * a2 >> 8 & 0xFF00FF) + ((rgb & 0xFF00) * a2 >> 8 & 0xFF00);
                            raster[offset] = rgb + ((raster[offset] & 0xFF00FF) * a1 >> 8 & 0xFF00FF) + ((raster[offset] & 0xFF00) * a1 >> 8 & 0xFF00);
                            if (saveDepth) {
                                Rasterizer.depthBuffer[offset] = depth;
                            }
                        }
                        ++offset;
                        depth += depth_slope;
                    } while (--div > 0);
                }
            }
        }
    }

    public static void drawGouraudTriangle(int y1, int y2, int y3, int x1, int x2, int x3, int hsl1, int hsl2, int hsl3, float z1, float z2, float z3, int bufferOffset) {
        int rgb1 = hsl2rgb[hsl1];
        int rgb2 = hsl2rgb[hsl2];
        int rgb3 = hsl2rgb[hsl3];
        int r1 = rgb1 >> 16 & 0xFF;
        int g1 = rgb1 >> 8 & 0xFF;
        int b1 = rgb1 & 0xFF;
        int r2 = rgb2 >> 16 & 0xFF;
        int g2 = rgb2 >> 8 & 0xFF;
        int b2 = rgb2 & 0xFF;
        int r3 = rgb3 >> 16 & 0xFF;
        int g3 = rgb3 >> 8 & 0xFF;
        int b3 = rgb3 & 0xFF;
        int dx1 = 0;
        int dr1 = 0;
        int dg1 = 0;
        int db1 = 0;
        if (y2 != y1) {
            dx1 = (x2 - x1 << 16) / (y2 - y1);
            dr1 = (r2 - r1 << 16) / (y2 - y1);
            dg1 = (g2 - g1 << 16) / (y2 - y1);
            db1 = (b2 - b1 << 16) / (y2 - y1);
        }
        int dx2 = 0;
        int dr2 = 0;
        int dg2 = 0;
        int db2 = 0;
        if (y3 != y2) {
            dx2 = (x3 - x2 << 16) / (y3 - y2);
            dr2 = (r3 - r2 << 16) / (y3 - y2);
            dg2 = (g3 - g2 << 16) / (y3 - y2);
            db2 = (b3 - b2 << 16) / (y3 - y2);
        }
        int dx3 = 0;
        int dr3 = 0;
        int dg3 = 0;
        int db3 = 0;
        if (y3 != y1) {
            dx3 = (x1 - x3 << 16) / (y1 - y3);
            dr3 = (r1 - r3 << 16) / (y1 - y3);
            dg3 = (g1 - g3 << 16) / (y1 - y3);
            db3 = (b1 - b3 << 16) / (y1 - y3);
        }
        float x21 = x2 - x1;
        float y21 = y2 - y1;
        float x31 = x3 - x1;
        float y31 = y3 - y1;
        float z21 = z2 - z1;
        float z31 = z3 - z1;
        float div = x21 * y31 - x31 * y21;
        float depthSlope = (z21 * y31 - z31 * y21) / div;
        float depthScale = (z31 * x21 - z21 * x31) / div;
        if (y1 <= y2 && y1 <= y3) {
            if (y1 >= clipBottom) {
                return;
            }
            if (y2 > clipBottom) {
                y2 = clipBottom;
            }
            if (y3 > clipBottom) {
                y3 = clipBottom;
            }
            z1 = z1 - depthSlope * (float)x1 + depthSlope;
            if (y2 < y3) {
                x3 = x1 <<= 16;
                r3 = r1 <<= 16;
                g3 = g1 <<= 16;
                b3 = b1 <<= 16;
                if (y1 < 0) {
                    x3 -= dx3 * y1;
                    x1 -= dx1 * y1;
                    r3 -= dr3 * y1;
                    g3 -= dg3 * y1;
                    b3 -= db3 * y1;
                    r1 -= dr1 * y1;
                    g1 -= dg1 * y1;
                    b1 -= db1 * y1;
                    z1 -= depthScale * (float)y1;
                    y1 = 0;
                }
                x2 <<= 16;
                r2 <<= 16;
                g2 <<= 16;
                b2 <<= 16;
                if (y2 < 0) {
                    x2 -= dx2 * y2;
                    r2 -= dr2 * y2;
                    g2 -= dg2 * y2;
                    b2 -= db2 * y2;
                    y2 = 0;
                }
                if (y1 != y2 && dx3 < dx1 || y1 == y2 && dx3 > dx2) {
                    y3 -= y2;
                    y2 -= y1;
                    y1 = lineOffsets[y1];
                    while (--y2 >= 0) {
                        Rasterizer.drawGouraudScanline(raster, y1, x3 >> 16, x1 >> 16, r3, g3, b3, r1, g1, b1, z1, depthSlope, bufferOffset);
                        x3 += dx3;
                        x1 += dx1;
                        r3 += dr3;
                        g3 += dg3;
                        b3 += db3;
                        r1 += dr1;
                        g1 += dg1;
                        b1 += db1;
                        z1 += depthScale;
                        y1 += width;
                    }
                    while (--y3 >= 0) {
                        Rasterizer.drawGouraudScanline(raster, y1, x3 >> 16, x2 >> 16, r3, g3, b3, r2, g2, b2, z1, depthSlope, bufferOffset);
                        x3 += dx3;
                        x2 += dx2;
                        r3 += dr3;
                        g3 += dg3;
                        b3 += db3;
                        r2 += dr2;
                        g2 += dg2;
                        b2 += db2;
                        y1 += width;
                        z1 += depthScale;
                    }
                    return;
                }
                y3 -= y2;
                y2 -= y1;
                y1 = lineOffsets[y1];
                while (--y2 >= 0) {
                    Rasterizer.drawGouraudScanline(raster, y1, x1 >> 16, x3 >> 16, r1, g1, b1, r3, g3, b3, z1, depthSlope, bufferOffset);
                    x3 += dx3;
                    x1 += dx1;
                    r3 += dr3;
                    g3 += dg3;
                    b3 += db3;
                    r1 += dr1;
                    g1 += dg1;
                    b1 += db1;
                    z1 += depthScale;
                    y1 += width;
                }
                while (--y3 >= 0) {
                    Rasterizer.drawGouraudScanline(raster, y1, x2 >> 16, x3 >> 16, r2, g2, b2, r3, g3, b3, z1, depthSlope, bufferOffset);
                    x3 += dx3;
                    x2 += dx2;
                    r3 += dr3;
                    g3 += dg3;
                    b3 += db3;
                    r2 += dr2;
                    g2 += dg2;
                    b2 += db2;
                    y1 += width;
                    z1 += depthScale;
                }
                return;
            }
            x2 = x1 <<= 16;
            r2 = r1 <<= 16;
            g2 = g1 <<= 16;
            b2 = b1 <<= 16;
            if (y1 < 0) {
                x2 -= dx3 * y1;
                x1 -= dx1 * y1;
                r2 -= dr3 * y1;
                g2 -= dg3 * y1;
                b2 -= db3 * y1;
                r1 -= dr1 * y1;
                g1 -= dg1 * y1;
                b1 -= db1 * y1;
                z1 -= depthScale * (float)y1;
                y1 = 0;
            }
            x3 <<= 16;
            r3 <<= 16;
            g3 <<= 16;
            b3 <<= 16;
            if (y3 < 0) {
                x3 -= dx2 * y3;
                r3 -= dr2 * y3;
                g3 -= dg2 * y3;
                b3 -= db2 * y3;
                y3 = 0;
            }
            if (y1 != y3 && dx3 < dx1 || y1 == y3 && dx2 > dx1) {
                y2 -= y3;
                y3 -= y1;
                y1 = lineOffsets[y1];
                while (--y3 >= 0) {
                    Rasterizer.drawGouraudScanline(raster, y1, x2 >> 16, x1 >> 16, r2, g2, b2, r1, g1, b1, z1, depthSlope, bufferOffset);
                    x2 += dx3;
                    x1 += dx1;
                    r2 += dr3;
                    g2 += dg3;
                    b2 += db3;
                    r1 += dr1;
                    g1 += dg1;
                    b1 += db1;
                    z1 += depthScale;
                    y1 += width;
                }
                while (--y2 >= 0) {
                    Rasterizer.drawGouraudScanline(raster, y1, x3 >> 16, x1 >> 16, r3, g3, b3, r1, g1, b1, z1, depthSlope, bufferOffset);
                    x3 += dx2;
                    x1 += dx1;
                    r3 += dr2;
                    g3 += dg2;
                    b3 += db2;
                    r1 += dr1;
                    g1 += dg1;
                    b1 += db1;
                    y1 += width;
                    z1 += depthScale;
                }
                return;
            }
            y2 -= y3;
            y3 -= y1;
            y1 = lineOffsets[y1];
            while (--y3 >= 0) {
                Rasterizer.drawGouraudScanline(raster, y1, x1 >> 16, x2 >> 16, r1, g1, b1, r2, g2, b2, z1, depthSlope, bufferOffset);
                x2 += dx3;
                x1 += dx1;
                r2 += dr3;
                g2 += dg3;
                b2 += db3;
                r1 += dr1;
                g1 += dg1;
                b1 += db1;
                z1 += depthScale;
                y1 += width;
            }
            while (--y2 >= 0) {
                Rasterizer.drawGouraudScanline(raster, y1, x1 >> 16, x3 >> 16, r1, g1, b1, r3, g3, b3, z1, depthSlope, bufferOffset);
                x3 += dx2;
                x1 += dx1;
                r3 += dr2;
                g3 += dg2;
                b3 += db2;
                r1 += dr1;
                g1 += dg1;
                b1 += db1;
                y1 += width;
                z1 += depthScale;
            }
            return;
        }
        if (y2 <= y3) {
            if (y2 >= clipBottom) {
                return;
            }
            if (y3 > clipBottom) {
                y3 = clipBottom;
            }
            if (y1 > clipBottom) {
                y1 = clipBottom;
            }
            z2 = z2 - depthSlope * (float)x2 + depthSlope;
            if (y3 < y1) {
                x1 = x2 <<= 16;
                r1 = r2 <<= 16;
                g1 = g2 <<= 16;
                b1 = b2 <<= 16;
                if (y2 < 0) {
                    x1 -= dx1 * y2;
                    x2 -= dx2 * y2;
                    r1 -= dr1 * y2;
                    g1 -= dg1 * y2;
                    b1 -= db1 * y2;
                    r2 -= dr2 * y2;
                    g2 -= dg2 * y2;
                    b2 -= db2 * y2;
                    z2 -= depthScale * (float)y2;
                    y2 = 0;
                }
                x3 <<= 16;
                r3 <<= 16;
                g3 <<= 16;
                b3 <<= 16;
                if (y3 < 0) {
                    x3 -= dx3 * y3;
                    r3 -= dr3 * y3;
                    g3 -= dg3 * y3;
                    b3 -= db3 * y3;
                    y3 = 0;
                }
                if (y2 != y3 && dx1 < dx2 || y2 == y3 && dx1 > dx3) {
                    y1 -= y3;
                    y3 -= y2;
                    y2 = lineOffsets[y2];
                    while (--y3 >= 0) {
                        Rasterizer.drawGouraudScanline(raster, y2, x1 >> 16, x2 >> 16, r1, g1, b1, r2, g2, b2, z2, depthSlope, bufferOffset);
                        x1 += dx1;
                        x2 += dx2;
                        r1 += dr1;
                        g1 += dg1;
                        b1 += db1;
                        r2 += dr2;
                        g2 += dg2;
                        b2 += db2;
                        z2 += depthScale;
                        y2 += width;
                    }
                    while (--y1 >= 0) {
                        Rasterizer.drawGouraudScanline(raster, y2, x1 >> 16, x3 >> 16, r1, g1, b1, r3, g3, b3, z2, depthSlope, bufferOffset);
                        x1 += dx1;
                        x3 += dx3;
                        r1 += dr1;
                        g1 += dg1;
                        b1 += db1;
                        r3 += dr3;
                        g3 += dg3;
                        b3 += db3;
                        y2 += width;
                        z2 += depthScale;
                    }
                    return;
                }
                y1 -= y3;
                y3 -= y2;
                y2 = lineOffsets[y2];
                while (--y3 >= 0) {
                    Rasterizer.drawGouraudScanline(raster, y2, x2 >> 16, x1 >> 16, r2, g2, b2, r1, g1, b1, z2, depthSlope, bufferOffset);
                    x1 += dx1;
                    x2 += dx2;
                    r1 += dr1;
                    g1 += dg1;
                    b1 += db1;
                    r2 += dr2;
                    g2 += dg2;
                    b2 += db2;
                    z2 += depthScale;
                    y2 += width;
                }
                while (--y1 >= 0) {
                    Rasterizer.drawGouraudScanline(raster, y2, x3 >> 16, x1 >> 16, r3, g3, b3, r1, g1, b1, z2, depthSlope, bufferOffset);
                    x1 += dx1;
                    x3 += dx3;
                    r1 += dr1;
                    g1 += dg1;
                    b1 += db1;
                    r3 += dr3;
                    g3 += dg3;
                    b3 += db3;
                    y2 += width;
                    z2 += depthScale;
                }
                return;
            }
            x3 = x2 <<= 16;
            r3 = r2 <<= 16;
            g3 = g2 <<= 16;
            b3 = b2 <<= 16;
            if (y2 < 0) {
                x3 -= dx1 * y2;
                x2 -= dx2 * y2;
                r3 -= dr1 * y2;
                g3 -= dg1 * y2;
                b3 -= db1 * y2;
                r2 -= dr2 * y2;
                g2 -= dg2 * y2;
                b2 -= db2 * y2;
                z2 -= depthScale * (float)y2;
                y2 = 0;
            }
            x1 <<= 16;
            r1 <<= 16;
            g1 <<= 16;
            b1 <<= 16;
            if (y1 < 0) {
                x1 -= dx3 * y1;
                r1 -= dr3 * y1;
                g1 -= dg3 * y1;
                b1 -= db3 * y1;
                y1 = 0;
            }
            if (dx1 < dx2) {
                y3 -= y1;
                y1 -= y2;
                y2 = lineOffsets[y2];
                while (--y1 >= 0) {
                    Rasterizer.drawGouraudScanline(raster, y2, x3 >> 16, x2 >> 16, r3, g3, b3, r2, g2, b2, z2, depthSlope, bufferOffset);
                    x3 += dx1;
                    x2 += dx2;
                    r3 += dr1;
                    g3 += dg1;
                    b3 += db1;
                    r2 += dr2;
                    g2 += dg2;
                    b2 += db2;
                    z2 += depthScale;
                    y2 += width;
                }
                while (--y3 >= 0) {
                    Rasterizer.drawGouraudScanline(raster, y2, x1 >> 16, x2 >> 16, r1, g1, b1, r2, g2, b2, z2, depthSlope, bufferOffset);
                    x1 += dx3;
                    x2 += dx2;
                    r1 += dr3;
                    g1 += dg3;
                    b1 += db3;
                    r2 += dr2;
                    g2 += dg2;
                    b2 += db2;
                    y2 += width;
                    z2 += depthScale;
                }
                return;
            }
            y3 -= y1;
            y1 -= y2;
            y2 = lineOffsets[y2];
            while (--y1 >= 0) {
                Rasterizer.drawGouraudScanline(raster, y2, x2 >> 16, x3 >> 16, r2, g2, b2, r3, g3, b3, z2, depthSlope, bufferOffset);
                x3 += dx1;
                x2 += dx2;
                r3 += dr1;
                g3 += dg1;
                b3 += db1;
                r2 += dr2;
                g2 += dg2;
                b2 += db2;
                z2 += depthScale;
                y2 += width;
            }
            while (--y3 >= 0) {
                Rasterizer.drawGouraudScanline(raster, y2, x2 >> 16, x1 >> 16, r2, g2, b2, r1, g1, b1, z2, depthSlope, bufferOffset);
                x1 += dx3;
                x2 += dx2;
                r1 += dr3;
                g1 += dg3;
                b1 += db3;
                r2 += dr2;
                g2 += dg2;
                b2 += db2;
                y2 += width;
                z2 += depthScale;
            }
            return;
        }
        if (y3 >= clipBottom) {
            return;
        }
        if (y1 > clipBottom) {
            y1 = clipBottom;
        }
        if (y2 > clipBottom) {
            y2 = clipBottom;
        }
        z3 = z3 - depthSlope * (float)x3 + depthSlope;
        if (y1 < y2) {
            x2 = x3 <<= 16;
            r2 = r3 <<= 16;
            g2 = g3 <<= 16;
            b2 = b3 <<= 16;
            if (y3 < 0) {
                x2 -= dx2 * y3;
                x3 -= dx3 * y3;
                r2 -= dr2 * y3;
                g2 -= dg2 * y3;
                b2 -= db2 * y3;
                r3 -= dr3 * y3;
                g3 -= dg3 * y3;
                b3 -= db3 * y3;
                z3 -= depthScale * (float)y3;
                y3 = 0;
            }
            x1 <<= 16;
            r1 <<= 16;
            g1 <<= 16;
            b1 <<= 16;
            if (y1 < 0) {
                x1 -= dx1 * y1;
                r1 -= dr1 * y1;
                g1 -= dg1 * y1;
                b1 -= db1 * y1;
                y1 = 0;
            }
            if (dx2 < dx3) {
                y2 -= y1;
                y1 -= y3;
                y3 = lineOffsets[y3];
                while (--y1 >= 0) {
                    Rasterizer.drawGouraudScanline(raster, y3, x2 >> 16, x3 >> 16, r2, g2, b2, r3, g3, b3, z3, depthSlope, bufferOffset);
                    x2 += dx2;
                    x3 += dx3;
                    r2 += dr2;
                    g2 += dg2;
                    b2 += db2;
                    r3 += dr3;
                    g3 += dg3;
                    b3 += db3;
                    z3 += depthScale;
                    y3 += width;
                }
                while (--y2 >= 0) {
                    Rasterizer.drawGouraudScanline(raster, y3, x2 >> 16, x1 >> 16, r2, g2, b2, r1, g1, b1, z3, depthSlope, bufferOffset);
                    x2 += dx2;
                    x1 += dx1;
                    r2 += dr2;
                    g2 += dg2;
                    b2 += db2;
                    r1 += dr1;
                    g1 += dg1;
                    b1 += db1;
                    y3 += width;
                    z3 += depthScale;
                }
                return;
            }
            y2 -= y1;
            y1 -= y3;
            y3 = lineOffsets[y3];
            while (--y1 >= 0) {
                Rasterizer.drawGouraudScanline(raster, y3, x3 >> 16, x2 >> 16, r3, g3, b3, r2, g2, b2, z3, depthSlope, bufferOffset);
                x2 += dx2;
                x3 += dx3;
                r2 += dr2;
                g2 += dg2;
                b2 += db2;
                r3 += dr3;
                g3 += dg3;
                b3 += db3;
                z3 += depthScale;
                y3 += width;
            }
            while (--y2 >= 0) {
                Rasterizer.drawGouraudScanline(raster, y3, x1 >> 16, x2 >> 16, r1, g1, b1, r2, g2, b2, z3, depthSlope, bufferOffset);
                x2 += dx2;
                x1 += dx1;
                r2 += dr2;
                g2 += dg2;
                b2 += db2;
                r1 += dr1;
                g1 += dg1;
                b1 += db1;
                z3 += depthScale;
                y3 += width;
            }
            return;
        }
        x1 = x3 <<= 16;
        r1 = r3 <<= 16;
        g1 = g3 <<= 16;
        b1 = b3 <<= 16;
        if (y3 < 0) {
            x1 -= dx2 * y3;
            x3 -= dx3 * y3;
            r1 -= dr2 * y3;
            g1 -= dg2 * y3;
            b1 -= db2 * y3;
            r3 -= dr3 * y3;
            g3 -= dg3 * y3;
            b3 -= db3 * y3;
            z3 -= depthScale * (float)y3;
            y3 = 0;
        }
        x2 <<= 16;
        r2 <<= 16;
        g2 <<= 16;
        b2 <<= 16;
        if (y2 < 0) {
            x2 -= dx1 * y2;
            r2 -= dr1 * y2;
            g2 -= dg1 * y2;
            b2 -= db1 * y2;
            y2 = 0;
        }
        if (dx2 < dx3) {
            y1 -= y2;
            y2 -= y3;
            y3 = lineOffsets[y3];
            while (--y2 >= 0) {
                Rasterizer.drawGouraudScanline(raster, y3, x1 >> 16, x3 >> 16, r1, g1, b1, r3, g3, b3, z3, depthSlope, bufferOffset);
                x1 += dx2;
                x3 += dx3;
                r1 += dr2;
                g1 += dg2;
                b1 += db2;
                r3 += dr3;
                g3 += dg3;
                b3 += db3;
                z3 += depthScale;
                y3 += width;
            }
            while (--y1 >= 0) {
                Rasterizer.drawGouraudScanline(raster, y3, x2 >> 16, x3 >> 16, r2, g2, b2, r3, g3, b3, z3, depthSlope, bufferOffset);
                x2 += dx1;
                x3 += dx3;
                r2 += dr1;
                g2 += dg1;
                b2 += db1;
                r3 += dr3;
                g3 += dg3;
                b3 += db3;
                z3 += depthScale;
                y3 += width;
            }
            return;
        }
        y1 -= y2;
        y2 -= y3;
        y3 = lineOffsets[y3];
        while (--y2 >= 0) {
            Rasterizer.drawGouraudScanline(raster, y3, x3 >> 16, x1 >> 16, r3, g3, b3, r1, g1, b1, z3, depthSlope, bufferOffset);
            x1 += dx2;
            x3 += dx3;
            r1 += dr2;
            g1 += dg2;
            b1 += db2;
            r3 += dr3;
            g3 += dg3;
            b3 += db3;
            z3 += depthScale;
            y3 += width;
        }
        while (--y1 >= 0) {
            Rasterizer.drawGouraudScanline(raster, y3, x3 >> 16, x2 >> 16, r3, g3, b3, r2, g2, b2, z3, depthSlope, bufferOffset);
            x2 += dx1;
            x3 += dx3;
            r2 += dr1;
            g2 += dg1;
            b2 += db1;
            r3 += dr3;
            g3 += dg3;
            b3 += db3;
            y3 += width;
            z3 += depthScale;
        }
    }

    public static void drawGouraudScanline(int[] dest, int offset, int x1, int x2, int r1, int g1, int b1, int r2, int g2, int b2, float z1, float z2, int bufferOffset) {
        block10: {
            int n = x2 - x1;
            if (n <= 0) {
                return;
            }
            r2 = (r2 - r1) / n;
            g2 = (g2 - g1) / n;
            b2 = (b2 - b1) / n;
            if (restrict_edges) {
                if (x2 > DrawingArea.maxRight) {
                    n -= x2 - DrawingArea.maxRight;
                    x2 = DrawingArea.maxRight;
                }
                if (x1 < 0) {
                    n = x2;
                    r1 -= x1 * r2;
                    g1 -= x1 * g2;
                    b1 -= x1 * b2;
                    x1 = 0;
                }
            }
            if (x1 >= x2) break block10;
            offset += x1;
            z1 += z2 * (float)x1;
            if (alpha == 0) {
                while (--n >= 0) {
                    if (z1 < depthBuffer[offset] || z1 < depthBuffer[offset] + (float)bufferOffset) {
                        dest[offset] = r1 & 0xFF0000 | g1 >> 8 & 0xFF00 | b1 >> 16 & 0xFF;
                        Rasterizer.depthBuffer[offset] = z1;
                    }
                    z1 += z2;
                    r1 += r2;
                    g1 += g2;
                    b1 += b2;
                    ++offset;
                }
            } else {
                int opacity = 256 - alpha;
                while (--n >= 0) {
                    int rgb = r1 & 0xFF0000 | g1 >> 8 & 0xFF00 | b1 >> 16 & 0xFF;
                    rgb = ((rgb & 0xFF00FF) * opacity >> 8 & 0xFF00FF) + ((rgb & 0xFF00) * opacity >> 8 & 0xFF00);
                    if (z1 < depthBuffer[offset] || z1 < depthBuffer[offset] + (float)bufferOffset) {
                        dest[offset] = rgb + ((dest[offset] & 0xFF00FF) * alpha >> 8 & 0xFF00FF) + ((dest[offset] & 0xFF00) * alpha >> 8 & 0xFF00);
                        Rasterizer.depthBuffer[offset] = z1;
                    }
                    ++offset;
                    z1 += z2;
                    r1 += r2;
                    g1 += g2;
                    b1 += b2;
                }
            }
        }
    }

    public static void drawFlatTriangle(int y1, int y2, int y3, int x1, int x2, int x3, int rgb, float z1, float z2, float z3, int bufferOffset) {
        int dx1 = 0;
        if (y2 != y1) {
            dx1 = (x2 - x1 << 16) / (y2 - y1);
        }
        int dx2 = 0;
        if (y3 != y2) {
            dx2 = (x3 - x2 << 16) / (y3 - y2);
        }
        int dx3 = 0;
        if (y3 != y1) {
            dx3 = (x1 - x3 << 16) / (y1 - y3);
        }
        float x21 = x2 - x1;
        float y21 = y2 - y1;
        float x31 = x3 - x1;
        float y31 = y3 - y1;
        float z21 = z2 - z1;
        float z31 = z3 - z1;
        float div = x21 * y31 - x31 * y21;
        float depthSlope = (z21 * y31 - z31 * y21) / div;
        float depthScale = (z31 * x21 - z21 * x31) / div;
        if (y1 <= y2 && y1 <= y3) {
            if (y1 >= clipBottom) {
                return;
            }
            if (y2 > clipBottom) {
                y2 = clipBottom;
            }
            if (y3 > clipBottom) {
                y3 = clipBottom;
            }
            z1 = z1 - depthSlope * (float)x1 + depthSlope;
            if (y2 < y3) {
                x3 = x1 <<= 16;
                if (y1 < 0) {
                    x3 -= dx3 * y1;
                    x1 -= dx1 * y1;
                    z1 -= depthScale * (float)y1;
                    y1 = 0;
                }
                x2 <<= 16;
                if (y2 < 0) {
                    x2 -= dx2 * y2;
                    y2 = 0;
                }
                if (y1 != y2 && dx3 < dx1 || y1 == y2 && dx3 > dx2) {
                    y3 -= y2;
                    y2 -= y1;
                    y1 = lineOffsets[y1];
                    while (--y2 >= 0) {
                        Rasterizer.drawFlatScanline(raster, y1, rgb, x3 >> 16, x1 >> 16, z1, depthSlope, bufferOffset);
                        z1 += depthScale;
                        x3 += dx3;
                        x1 += dx1;
                        y1 += width;
                    }
                    while (--y3 >= 0) {
                        Rasterizer.drawFlatScanline(raster, y1, rgb, x3 >> 16, x2 >> 16, z1, depthSlope, bufferOffset);
                        z1 += depthScale;
                        x3 += dx3;
                        x2 += dx2;
                        y1 += width;
                    }
                    return;
                }
                y3 -= y2;
                y2 -= y1;
                y1 = lineOffsets[y1];
                while (--y2 >= 0) {
                    Rasterizer.drawFlatScanline(raster, y1, rgb, x1 >> 16, x3 >> 16, z1, depthSlope, bufferOffset);
                    z1 += depthScale;
                    x3 += dx3;
                    x1 += dx1;
                    y1 += width;
                }
                while (--y3 >= 0) {
                    Rasterizer.drawFlatScanline(raster, y1, rgb, x2 >> 16, x3 >> 16, z1, depthSlope, bufferOffset);
                    z1 += depthScale;
                    x3 += dx3;
                    x2 += dx2;
                    y1 += width;
                }
                return;
            }
            x2 = x1 <<= 16;
            if (y1 < 0) {
                x2 -= dx3 * y1;
                x1 -= dx1 * y1;
                z1 -= depthScale * (float)y1;
                y1 = 0;
            }
            x3 <<= 16;
            if (y3 < 0) {
                x3 -= dx2 * y3;
                y3 = 0;
            }
            if (y1 != y3 && dx3 < dx1 || y1 == y3 && dx2 > dx1) {
                y2 -= y3;
                y3 -= y1;
                y1 = lineOffsets[y1];
                while (--y3 >= 0) {
                    Rasterizer.drawFlatScanline(raster, y1, rgb, x2 >> 16, x1 >> 16, z1, depthSlope, bufferOffset);
                    z1 += depthScale;
                    x2 += dx3;
                    x1 += dx1;
                    y1 += width;
                }
                while (--y2 >= 0) {
                    Rasterizer.drawFlatScanline(raster, y1, rgb, x3 >> 16, x1 >> 16, z1, depthSlope, bufferOffset);
                    z1 += depthScale;
                    x3 += dx2;
                    x1 += dx1;
                    y1 += width;
                }
                return;
            }
            y2 -= y3;
            y3 -= y1;
            y1 = lineOffsets[y1];
            while (--y3 >= 0) {
                Rasterizer.drawFlatScanline(raster, y1, rgb, x1 >> 16, x2 >> 16, z1, depthSlope, bufferOffset);
                z1 += depthScale;
                x2 += dx3;
                x1 += dx1;
                y1 += width;
            }
            while (--y2 >= 0) {
                Rasterizer.drawFlatScanline(raster, y1, rgb, x1 >> 16, x3 >> 16, z1, depthSlope, bufferOffset);
                z1 += depthScale;
                x3 += dx2;
                x1 += dx1;
                y1 += width;
            }
            return;
        }
        if (y2 <= y3) {
            if (y2 >= clipBottom) {
                return;
            }
            if (y3 > clipBottom) {
                y3 = clipBottom;
            }
            if (y1 > clipBottom) {
                y1 = clipBottom;
            }
            z2 = z2 - depthSlope * (float)x2 + depthSlope;
            if (y3 < y1) {
                x1 = x2 <<= 16;
                if (y2 < 0) {
                    x1 -= dx1 * y2;
                    x2 -= dx2 * y2;
                    z2 -= depthScale * (float)y2;
                    y2 = 0;
                }
                x3 <<= 16;
                if (y3 < 0) {
                    x3 -= dx3 * y3;
                    y3 = 0;
                }
                if (y2 != y3 && dx1 < dx2 || y2 == y3 && dx1 > dx3) {
                    y1 -= y3;
                    y3 -= y2;
                    y2 = lineOffsets[y2];
                    while (--y3 >= 0) {
                        Rasterizer.drawFlatScanline(raster, y2, rgb, x1 >> 16, x2 >> 16, z2, depthSlope, bufferOffset);
                        z2 += depthScale;
                        x1 += dx1;
                        x2 += dx2;
                        y2 += width;
                    }
                    while (--y1 >= 0) {
                        Rasterizer.drawFlatScanline(raster, y2, rgb, x1 >> 16, x3 >> 16, z2, depthSlope, bufferOffset);
                        z2 += depthScale;
                        x1 += dx1;
                        x3 += dx3;
                        y2 += width;
                    }
                    return;
                }
                y1 -= y3;
                y3 -= y2;
                y2 = lineOffsets[y2];
                while (--y3 >= 0) {
                    Rasterizer.drawFlatScanline(raster, y2, rgb, x2 >> 16, x1 >> 16, z2, depthSlope, bufferOffset);
                    z2 += depthScale;
                    x1 += dx1;
                    x2 += dx2;
                    y2 += width;
                }
                while (--y1 >= 0) {
                    Rasterizer.drawFlatScanline(raster, y2, rgb, x3 >> 16, x1 >> 16, z2, depthSlope, bufferOffset);
                    z2 += depthScale;
                    x1 += dx1;
                    x3 += dx3;
                    y2 += width;
                }
                return;
            }
            x3 = x2 <<= 16;
            if (y2 < 0) {
                x3 -= dx1 * y2;
                x2 -= dx2 * y2;
                z2 -= depthScale * (float)y2;
                y2 = 0;
            }
            x1 <<= 16;
            if (y1 < 0) {
                x1 -= dx3 * y1;
                y1 = 0;
            }
            if (dx1 < dx2) {
                y3 -= y1;
                y1 -= y2;
                y2 = lineOffsets[y2];
                while (--y1 >= 0) {
                    Rasterizer.drawFlatScanline(raster, y2, rgb, x3 >> 16, x2 >> 16, z2, depthSlope, bufferOffset);
                    z2 += depthScale;
                    x3 += dx1;
                    x2 += dx2;
                    y2 += width;
                }
                while (--y3 >= 0) {
                    Rasterizer.drawFlatScanline(raster, y2, rgb, x1 >> 16, x2 >> 16, z2, depthSlope, bufferOffset);
                    z2 += depthScale;
                    x1 += dx3;
                    x2 += dx2;
                    y2 += width;
                }
                return;
            }
            y3 -= y1;
            y1 -= y2;
            y2 = lineOffsets[y2];
            while (--y1 >= 0) {
                Rasterizer.drawFlatScanline(raster, y2, rgb, x2 >> 16, x3 >> 16, z2, depthSlope, bufferOffset);
                z2 += depthScale;
                x3 += dx1;
                x2 += dx2;
                y2 += width;
            }
            while (--y3 >= 0) {
                Rasterizer.drawFlatScanline(raster, y2, rgb, x2 >> 16, x1 >> 16, z2, depthSlope, bufferOffset);
                z2 += depthScale;
                x1 += dx3;
                x2 += dx2;
                y2 += width;
            }
            return;
        }
        if (y3 >= clipBottom) {
            return;
        }
        if (y1 > clipBottom) {
            y1 = clipBottom;
        }
        if (y2 > clipBottom) {
            y2 = clipBottom;
        }
        z3 = z3 - depthSlope * (float)x3 + depthSlope;
        if (y1 < y2) {
            x2 = x3 <<= 16;
            if (y3 < 0) {
                x2 -= dx2 * y3;
                x3 -= dx3 * y3;
                z3 -= depthScale * (float)y3;
                y3 = 0;
            }
            x1 <<= 16;
            if (y1 < 0) {
                x1 -= dx1 * y1;
                y1 = 0;
            }
            if (dx2 < dx3) {
                y2 -= y1;
                y1 -= y3;
                y3 = lineOffsets[y3];
                while (--y1 >= 0) {
                    Rasterizer.drawFlatScanline(raster, y3, rgb, x2 >> 16, x3 >> 16, z3, depthSlope, bufferOffset);
                    z3 += depthScale;
                    x2 += dx2;
                    x3 += dx3;
                    y3 += width;
                }
                while (--y2 >= 0) {
                    Rasterizer.drawFlatScanline(raster, y3, rgb, x2 >> 16, x1 >> 16, z3, depthSlope, bufferOffset);
                    z3 += depthScale;
                    x2 += dx2;
                    x1 += dx1;
                    y3 += width;
                }
                return;
            }
            y2 -= y1;
            y1 -= y3;
            y3 = lineOffsets[y3];
            while (--y1 >= 0) {
                Rasterizer.drawFlatScanline(raster, y3, rgb, x3 >> 16, x2 >> 16, z3, depthSlope, bufferOffset);
                z3 += depthScale;
                x2 += dx2;
                x3 += dx3;
                y3 += width;
            }
            while (--y2 >= 0) {
                Rasterizer.drawFlatScanline(raster, y3, rgb, x1 >> 16, x2 >> 16, z3, depthSlope, bufferOffset);
                z3 += depthScale;
                x2 += dx2;
                x1 += dx1;
                y3 += width;
            }
            return;
        }
        x1 = x3 <<= 16;
        if (y3 < 0) {
            x1 -= dx2 * y3;
            x3 -= dx3 * y3;
            z3 -= depthScale * (float)y3;
            y3 = 0;
        }
        x2 <<= 16;
        if (y2 < 0) {
            x2 -= dx1 * y2;
            y2 = 0;
        }
        if (dx2 < dx3) {
            y1 -= y2;
            y2 -= y3;
            y3 = lineOffsets[y3];
            while (--y2 >= 0) {
                Rasterizer.drawFlatScanline(raster, y3, rgb, x1 >> 16, x3 >> 16, z3, depthSlope, bufferOffset);
                z3 += depthScale;
                x1 += dx2;
                x3 += dx3;
                y3 += width;
            }
            while (--y1 >= 0) {
                Rasterizer.drawFlatScanline(raster, y3, rgb, x2 >> 16, x3 >> 16, z3, depthSlope, bufferOffset);
                z3 += depthScale;
                x2 += dx1;
                x3 += dx3;
                y3 += width;
            }
            return;
        }
        y1 -= y2;
        y2 -= y3;
        y3 = lineOffsets[y3];
        while (--y2 >= 0) {
            Rasterizer.drawFlatScanline(raster, y3, rgb, x3 >> 16, x1 >> 16, z3, depthSlope, bufferOffset);
            z3 += depthScale;
            x1 += dx2;
            x3 += dx3;
            y3 += width;
        }
        while (--y1 >= 0) {
            Rasterizer.drawFlatScanline(raster, y3, rgb, x3 >> 16, x2 >> 16, z3, depthSlope, bufferOffset);
            z3 += depthScale;
            x2 += dx1;
            x3 += dx3;
            y3 += width;
        }
    }

    private static void drawFlatScanline(int[] dest, int offset, int rgb, int x1, int x2, float z1, float z2, int bufferOffset) {
        if (restrict_edges) {
            if (x2 > DrawingArea.maxRight) {
                x2 = DrawingArea.maxRight;
            }
            if (x1 < 0) {
                z1 -= (float)x1 * z2;
                x1 = 0;
            }
        }
        if (x1 >= x2) {
            return;
        }
        offset += x1;
        z1 += z2 * (float)x1;
        int len = x2 - x1 >> 2;
        if (alpha == 0) {
            while (--len >= 0) {
                if (z1 < depthBuffer[offset] || z1 < depthBuffer[offset] + (float)bufferOffset) {
                    dest[offset] = rgb;
                    Rasterizer.depthBuffer[offset] = z1;
                }
                if ((z1 += z2) < depthBuffer[++offset] || z1 < depthBuffer[offset] + (float)bufferOffset) {
                    dest[offset] = rgb;
                    Rasterizer.depthBuffer[offset] = z1;
                }
                if ((z1 += z2) < depthBuffer[++offset] || z1 < depthBuffer[offset] + (float)bufferOffset) {
                    dest[offset] = rgb;
                    Rasterizer.depthBuffer[offset] = z1;
                }
                if ((z1 += z2) < depthBuffer[++offset] || z1 < depthBuffer[offset] + (float)bufferOffset) {
                    dest[offset] = rgb;
                    Rasterizer.depthBuffer[offset] = z1;
                }
                z1 += z2;
                ++offset;
            }
            len = x2 - x1 & 3;
            while (--len >= 0) {
                if (z1 < depthBuffer[offset] || z1 < depthBuffer[offset] + (float)bufferOffset) {
                    dest[offset] = rgb;
                    Rasterizer.depthBuffer[offset] = z1;
                }
                z1 += z2;
                ++offset;
            }
            return;
        }
        int opacity = 256 - alpha;
        rgb = ((rgb & 0xFF00FF) * opacity >> 8 & 0xFF00FF) + ((rgb & 0xFF00) * opacity >> 8 & 0xFF00);
        while (--len >= 0) {
            if (z1 < depthBuffer[offset] || z1 < depthBuffer[offset] + (float)bufferOffset) {
                dest[offset] = rgb + ((dest[offset] & 0xFF00FF) * alpha >> 8 & 0xFF00FF) + ((dest[offset] & 0xFF00) * alpha >> 8 & 0xFF00);
                Rasterizer.depthBuffer[offset] = z1;
            }
            if ((z1 += z2) < depthBuffer[++offset] || z1 < depthBuffer[offset] + (float)bufferOffset) {
                dest[offset] = rgb + ((dest[offset] & 0xFF00FF) * alpha >> 8 & 0xFF00FF) + ((dest[offset] & 0xFF00) * alpha >> 8 & 0xFF00);
                Rasterizer.depthBuffer[offset] = z1;
            }
            if ((z1 += z2) < depthBuffer[++offset] || z1 < depthBuffer[offset] + (float)bufferOffset) {
                dest[offset] = rgb + ((dest[offset] & 0xFF00FF) * alpha >> 8 & 0xFF00FF) + ((dest[offset] & 0xFF00) * alpha >> 8 & 0xFF00);
                Rasterizer.depthBuffer[offset] = z1;
            }
            if ((z1 += z2) < depthBuffer[++offset] || z1 < depthBuffer[offset] + (float)bufferOffset) {
                dest[offset] = rgb + ((dest[offset] & 0xFF00FF) * alpha >> 8 & 0xFF00FF) + ((dest[offset] & 0xFF00) * alpha >> 8 & 0xFF00);
                Rasterizer.depthBuffer[offset] = z1;
            }
            z1 += z2;
            ++offset;
        }
        len = x2 - x1 & 3;
        while (--len >= 0) {
            if (z1 < depthBuffer[offset] || z1 < depthBuffer[offset] + (float)bufferOffset) {
                dest[offset] = rgb + ((dest[offset] & 0xFF00FF) * alpha >> 8 & 0xFF00FF) + ((dest[offset] & 0xFF00) * alpha >> 8 & 0xFF00);
                Rasterizer.depthBuffer[offset] = z1;
            }
            z1 += z2;
            ++offset;
        }
    }

    public static void drawTexturedTriangle(int y1, int y2, int y3, int x1, int x2, int x3, int c1, int c2, int c3, int tx1, int tx2, int tx3, int ty1, int ty2, int ty3, int tz1, int tz2, int tz3, int tex, float z1, float z2, float z3, int bufferOffset) {
        c1 = 127 - c1 << 1;
        c2 = 127 - c2 << 1;
        c3 = 127 - c3 << 1;
        int[] texels = Rasterizer.getTexels(tex);
        aBoolean1463 = !aBooleanArray1475[tex];
        tx2 = tx1 - tx2;
        ty2 = ty1 - ty2;
        tz2 = tz1 - tz2;
        int l4 = (tx3 -= tx1) * ty1 - (ty3 -= ty1) * tx1 << 14;
        int i5 = (int)(((long)(ty3 * tz1 - (tz3 -= tz1) * ty1) << 3 << 14) / (long)fieldOfView);
        int j5 = (int)(((long)(tz3 * tx1 - tx3 * tz1) << 14) / (long)fieldOfView);
        int k5 = tx2 * ty1 - ty2 * tx1 << 14;
        int l5 = (int)(((long)(ty2 * tz1 - tz2 * ty1) << 3 << 14) / (long)fieldOfView);
        int i6 = (int)(((long)(tz2 * tx1 - tx2 * tz1) << 14) / (long)fieldOfView);
        int j6 = ty2 * tx3 - tx2 * ty3 << 14;
        int k6 = (int)(((long)(tz2 * ty3 - ty2 * tz3) << 3 << 14) / (long)fieldOfView);
        int l6 = (int)(((long)(tx2 * tz3 - tz2 * tx3) << 14) / (long)fieldOfView);
        int i7 = 0;
        int j7 = 0;
        if (y2 != y1) {
            i7 = (x2 - x1 << 16) / (y2 - y1);
            j7 = (c2 - c1 << 16) / (y2 - y1);
        }
        int k7 = 0;
        int l7 = 0;
        if (y3 != y2) {
            k7 = (x3 - x2 << 16) / (y3 - y2);
            l7 = (c3 - c2 << 16) / (y3 - y2);
        }
        int i8 = 0;
        int j8 = 0;
        if (y3 != y1) {
            i8 = (x1 - x3 << 16) / (y1 - y3);
            j8 = (c1 - c3 << 16) / (y1 - y3);
        }
        float x21 = x2 - x1;
        float y21 = y2 - y1;
        float x31 = x3 - x1;
        float y31 = y3 - y1;
        float z21 = z2 - z1;
        float z31 = z3 - z1;
        float div = x21 * y31 - x31 * y21;
        float depthSlope = (z21 * y31 - z31 * y21) / div;
        float depthScale = (z31 * x21 - z21 * x31) / div;
        if (y1 <= y2 && y1 <= y3) {
            if (y1 >= clipBottom) {
                return;
            }
            if (y2 > clipBottom) {
                y2 = clipBottom;
            }
            if (y3 > clipBottom) {
                y3 = clipBottom;
            }
            z1 = z1 - depthSlope * (float)x1 + depthSlope;
            if (y2 < y3) {
                x3 = x1 <<= 16;
                c3 = c1 <<= 16;
                if (y1 < 0) {
                    x3 -= i8 * y1;
                    x1 -= i7 * y1;
                    z1 -= depthScale * (float)y1;
                    c3 -= j8 * y1;
                    c1 -= j7 * y1;
                    y1 = 0;
                }
                x2 <<= 16;
                c2 <<= 16;
                if (y2 < 0) {
                    x2 -= k7 * y2;
                    c2 -= l7 * y2;
                    y2 = 0;
                }
                int k8 = y1 - centerY;
                l4 += j5 * k8;
                k5 += i6 * k8;
                j6 += l6 * k8;
                if (y1 != y2 && i8 < i7 || y1 == y2 && i8 > k7) {
                    y3 -= y2;
                    y2 -= y1;
                    y1 = lineOffsets[y1];
                    while (--y2 >= 0) {
                        Rasterizer.drawTexturedScanline(raster, texels, y1, x3 >> 16, x1 >> 16, c3, c1, l4, k5, j6, i5, l5, k6, z1, depthSlope, bufferOffset);
                        z1 += depthScale;
                        x3 += i8;
                        x1 += i7;
                        c3 += j8;
                        c1 += j7;
                        y1 += width;
                        l4 += j5;
                        k5 += i6;
                        j6 += l6;
                    }
                    while (--y3 >= 0) {
                        Rasterizer.drawTexturedScanline(raster, texels, y1, x3 >> 16, x2 >> 16, c3, c2, l4, k5, j6, i5, l5, k6, z1, depthSlope, bufferOffset);
                        z1 += depthScale;
                        x3 += i8;
                        x2 += k7;
                        c3 += j8;
                        c2 += l7;
                        y1 += width;
                        l4 += j5;
                        k5 += i6;
                        j6 += l6;
                    }
                    return;
                }
                y3 -= y2;
                y2 -= y1;
                y1 = lineOffsets[y1];
                while (--y2 >= 0) {
                    Rasterizer.drawTexturedScanline(raster, texels, y1, x1 >> 16, x3 >> 16, c1, c3, l4, k5, j6, i5, l5, k6, z1, depthSlope, bufferOffset);
                    z1 += depthScale;
                    x3 += i8;
                    x1 += i7;
                    c3 += j8;
                    c1 += j7;
                    y1 += width;
                    l4 += j5;
                    k5 += i6;
                    j6 += l6;
                }
                while (--y3 >= 0) {
                    Rasterizer.drawTexturedScanline(raster, texels, y1, x2 >> 16, x3 >> 16, c2, c3, l4, k5, j6, i5, l5, k6, z1, depthSlope, bufferOffset);
                    z1 += depthScale;
                    x3 += i8;
                    x2 += k7;
                    c3 += j8;
                    c2 += l7;
                    y1 += width;
                    l4 += j5;
                    k5 += i6;
                    j6 += l6;
                }
                return;
            }
            x2 = x1 <<= 16;
            c2 = c1 <<= 16;
            if (y1 < 0) {
                x2 -= i8 * y1;
                z1 -= depthScale * (float)y1;
                x1 -= i7 * y1;
                c2 -= j8 * y1;
                c1 -= j7 * y1;
                y1 = 0;
            }
            x3 <<= 16;
            c3 <<= 16;
            if (y3 < 0) {
                x3 -= k7 * y3;
                c3 -= l7 * y3;
                y3 = 0;
            }
            int l8 = y1 - centerY;
            l4 += j5 * l8;
            k5 += i6 * l8;
            j6 += l6 * l8;
            if (y1 != y3 && i8 < i7 || y1 == y3 && k7 > i7) {
                y2 -= y3;
                y3 -= y1;
                y1 = lineOffsets[y1];
                while (--y3 >= 0) {
                    Rasterizer.drawTexturedScanline(raster, texels, y1, x2 >> 16, x1 >> 16, c2, c1, l4, k5, j6, i5, l5, k6, z1, depthSlope, bufferOffset);
                    z1 += depthScale;
                    x2 += i8;
                    x1 += i7;
                    c2 += j8;
                    c1 += j7;
                    y1 += width;
                    l4 += j5;
                    k5 += i6;
                    j6 += l6;
                }
                while (--y2 >= 0) {
                    Rasterizer.drawTexturedScanline(raster, texels, y1, x3 >> 16, x1 >> 16, c3, c1, l4, k5, j6, i5, l5, k6, z1, depthSlope, bufferOffset);
                    z1 += depthScale;
                    x3 += k7;
                    x1 += i7;
                    c3 += l7;
                    c1 += j7;
                    y1 += width;
                    l4 += j5;
                    k5 += i6;
                    j6 += l6;
                }
                return;
            }
            y2 -= y3;
            y3 -= y1;
            y1 = lineOffsets[y1];
            while (--y3 >= 0) {
                Rasterizer.drawTexturedScanline(raster, texels, y1, x1 >> 16, x2 >> 16, c1, c2, l4, k5, j6, i5, l5, k6, z1, depthSlope, bufferOffset);
                z1 += depthScale;
                x2 += i8;
                x1 += i7;
                c2 += j8;
                c1 += j7;
                y1 += width;
                l4 += j5;
                k5 += i6;
                j6 += l6;
            }
            while (--y2 >= 0) {
                Rasterizer.drawTexturedScanline(raster, texels, y1, x1 >> 16, x3 >> 16, c1, c3, l4, k5, j6, i5, l5, k6, z1, depthSlope, bufferOffset);
                z1 += depthScale;
                x3 += k7;
                x1 += i7;
                c3 += l7;
                c1 += j7;
                y1 += width;
                l4 += j5;
                k5 += i6;
                j6 += l6;
            }
            return;
        }
        if (y2 <= y3) {
            if (y2 >= clipBottom) {
                return;
            }
            if (y3 > clipBottom) {
                y3 = clipBottom;
            }
            if (y1 > clipBottom) {
                y1 = clipBottom;
            }
            z2 = z2 - depthSlope * (float)x2 + depthSlope;
            if (y3 < y1) {
                x1 = x2 <<= 16;
                c1 = c2 <<= 16;
                if (y2 < 0) {
                    x1 -= i7 * y2;
                    x2 -= k7 * y2;
                    z2 -= depthScale * (float)y2;
                    c1 -= j7 * y2;
                    c2 -= l7 * y2;
                    y2 = 0;
                }
                x3 <<= 16;
                c3 <<= 16;
                if (y3 < 0) {
                    x3 -= i8 * y3;
                    c3 -= j8 * y3;
                    y3 = 0;
                }
                int i9 = y2 - centerY;
                l4 += j5 * i9;
                k5 += i6 * i9;
                j6 += l6 * i9;
                if (y2 != y3 && i7 < k7 || y2 == y3 && i7 > i8) {
                    y1 -= y3;
                    y3 -= y2;
                    y2 = lineOffsets[y2];
                    while (--y3 >= 0) {
                        Rasterizer.drawTexturedScanline(raster, texels, y2, x1 >> 16, x2 >> 16, c1, c2, l4, k5, j6, i5, l5, k6, z2, depthSlope, bufferOffset);
                        z2 += depthScale;
                        x1 += i7;
                        x2 += k7;
                        c1 += j7;
                        c2 += l7;
                        y2 += width;
                        l4 += j5;
                        k5 += i6;
                        j6 += l6;
                    }
                    while (--y1 >= 0) {
                        Rasterizer.drawTexturedScanline(raster, texels, y2, x1 >> 16, x3 >> 16, c1, c3, l4, k5, j6, i5, l5, k6, z2, depthSlope, bufferOffset);
                        z2 += depthScale;
                        x1 += i7;
                        x3 += i8;
                        c1 += j7;
                        c3 += j8;
                        y2 += width;
                        l4 += j5;
                        k5 += i6;
                        j6 += l6;
                    }
                    return;
                }
                y1 -= y3;
                y3 -= y2;
                y2 = lineOffsets[y2];
                while (--y3 >= 0) {
                    Rasterizer.drawTexturedScanline(raster, texels, y2, x2 >> 16, x1 >> 16, c2, c1, l4, k5, j6, i5, l5, k6, z2, depthSlope, bufferOffset);
                    z2 += depthScale;
                    x1 += i7;
                    x2 += k7;
                    c1 += j7;
                    c2 += l7;
                    y2 += width;
                    l4 += j5;
                    k5 += i6;
                    j6 += l6;
                }
                while (--y1 >= 0) {
                    Rasterizer.drawTexturedScanline(raster, texels, y2, x3 >> 16, x1 >> 16, c3, c1, l4, k5, j6, i5, l5, k6, z2, depthSlope, bufferOffset);
                    z2 += depthScale;
                    x1 += i7;
                    x3 += i8;
                    c1 += j7;
                    c3 += j8;
                    y2 += width;
                    l4 += j5;
                    k5 += i6;
                    j6 += l6;
                }
                return;
            }
            x3 = x2 <<= 16;
            c3 = c2 <<= 16;
            if (y2 < 0) {
                x3 -= i7 * y2;
                z2 -= depthScale * (float)y2;
                x2 -= k7 * y2;
                c3 -= j7 * y2;
                c2 -= l7 * y2;
                y2 = 0;
            }
            x1 <<= 16;
            c1 <<= 16;
            if (y1 < 0) {
                x1 -= i8 * y1;
                c1 -= j8 * y1;
                y1 = 0;
            }
            int j9 = y2 - centerY;
            l4 += j5 * j9;
            k5 += i6 * j9;
            j6 += l6 * j9;
            if (i7 < k7) {
                y3 -= y1;
                y1 -= y2;
                y2 = lineOffsets[y2];
                while (--y1 >= 0) {
                    Rasterizer.drawTexturedScanline(raster, texels, y2, x3 >> 16, x2 >> 16, c3, c2, l4, k5, j6, i5, l5, k6, z2, depthSlope, bufferOffset);
                    z2 += depthScale;
                    x3 += i7;
                    x2 += k7;
                    c3 += j7;
                    c2 += l7;
                    y2 += width;
                    l4 += j5;
                    k5 += i6;
                    j6 += l6;
                }
                while (--y3 >= 0) {
                    Rasterizer.drawTexturedScanline(raster, texels, y2, x1 >> 16, x2 >> 16, c1, c2, l4, k5, j6, i5, l5, k6, z2, depthSlope, bufferOffset);
                    z2 += depthScale;
                    x1 += i8;
                    x2 += k7;
                    c1 += j8;
                    c2 += l7;
                    y2 += width;
                    l4 += j5;
                    k5 += i6;
                    j6 += l6;
                }
                return;
            }
            y3 -= y1;
            y1 -= y2;
            y2 = lineOffsets[y2];
            while (--y1 >= 0) {
                Rasterizer.drawTexturedScanline(raster, texels, y2, x2 >> 16, x3 >> 16, c2, c3, l4, k5, j6, i5, l5, k6, z2, depthSlope, bufferOffset);
                z2 += depthScale;
                x3 += i7;
                x2 += k7;
                c3 += j7;
                c2 += l7;
                y2 += width;
                l4 += j5;
                k5 += i6;
                j6 += l6;
            }
            while (--y3 >= 0) {
                Rasterizer.drawTexturedScanline(raster, texels, y2, x2 >> 16, x1 >> 16, c2, c1, l4, k5, j6, i5, l5, k6, z2, depthSlope, bufferOffset);
                z2 += depthScale;
                x1 += i8;
                x2 += k7;
                c1 += j8;
                c2 += l7;
                y2 += width;
                l4 += j5;
                k5 += i6;
                j6 += l6;
            }
            return;
        }
        if (y3 >= clipBottom) {
            return;
        }
        if (y1 > clipBottom) {
            y1 = clipBottom;
        }
        if (y2 > clipBottom) {
            y2 = clipBottom;
        }
        z3 = z3 - depthSlope * (float)x3 + depthSlope;
        if (y1 < y2) {
            x2 = x3 <<= 16;
            c2 = c3 <<= 16;
            if (y3 < 0) {
                x2 -= k7 * y3;
                x3 -= i8 * y3;
                z3 -= depthScale * (float)y3;
                c2 -= l7 * y3;
                c3 -= j8 * y3;
                y3 = 0;
            }
            x1 <<= 16;
            c1 <<= 16;
            if (y1 < 0) {
                x1 -= i7 * y1;
                c1 -= j7 * y1;
                y1 = 0;
            }
            int k9 = y3 - centerY;
            l4 += j5 * k9;
            k5 += i6 * k9;
            j6 += l6 * k9;
            if (k7 < i8) {
                y2 -= y1;
                y1 -= y3;
                y3 = lineOffsets[y3];
                while (--y1 >= 0) {
                    Rasterizer.drawTexturedScanline(raster, texels, y3, x2 >> 16, x3 >> 16, c2, c3, l4, k5, j6, i5, l5, k6, z3, depthSlope, bufferOffset);
                    z3 += depthScale;
                    x2 += k7;
                    x3 += i8;
                    c2 += l7;
                    c3 += j8;
                    y3 += width;
                    l4 += j5;
                    k5 += i6;
                    j6 += l6;
                }
                while (--y2 >= 0) {
                    Rasterizer.drawTexturedScanline(raster, texels, y3, x2 >> 16, x1 >> 16, c2, c1, l4, k5, j6, i5, l5, k6, z3, depthSlope, bufferOffset);
                    z3 += depthScale;
                    x2 += k7;
                    x1 += i7;
                    c2 += l7;
                    c1 += j7;
                    y3 += width;
                    l4 += j5;
                    k5 += i6;
                    j6 += l6;
                }
                return;
            }
            y2 -= y1;
            y1 -= y3;
            y3 = lineOffsets[y3];
            while (--y1 >= 0) {
                Rasterizer.drawTexturedScanline(raster, texels, y3, x3 >> 16, x2 >> 16, c3, c2, l4, k5, j6, i5, l5, k6, z3, depthSlope, bufferOffset);
                z3 += depthScale;
                x2 += k7;
                x3 += i8;
                c2 += l7;
                c3 += j8;
                y3 += width;
                l4 += j5;
                k5 += i6;
                j6 += l6;
            }
            while (--y2 >= 0) {
                Rasterizer.drawTexturedScanline(raster, texels, y3, x1 >> 16, x2 >> 16, c1, c2, l4, k5, j6, i5, l5, k6, z3, depthSlope, bufferOffset);
                z3 += depthScale;
                x2 += k7;
                x1 += i7;
                c2 += l7;
                c1 += j7;
                y3 += width;
                l4 += j5;
                k5 += i6;
                j6 += l6;
            }
            return;
        }
        x1 = x3 <<= 16;
        c1 = c3 <<= 16;
        if (y3 < 0) {
            x1 -= k7 * y3;
            x3 -= i8 * y3;
            z3 -= depthScale * (float)y3;
            c1 -= l7 * y3;
            c3 -= j8 * y3;
            y3 = 0;
        }
        x2 <<= 16;
        c2 <<= 16;
        if (y2 < 0) {
            x2 -= i7 * y2;
            c2 -= j7 * y2;
            y2 = 0;
        }
        int l9 = y3 - centerY;
        l4 += j5 * l9;
        k5 += i6 * l9;
        j6 += l6 * l9;
        if (k7 < i8) {
            y1 -= y2;
            y2 -= y3;
            y3 = lineOffsets[y3];
            while (--y2 >= 0) {
                Rasterizer.drawTexturedScanline(raster, texels, y3, x1 >> 16, x3 >> 16, c1, c3, l4, k5, j6, i5, l5, k6, z3, depthSlope, bufferOffset);
                z3 += depthScale;
                x1 += k7;
                x3 += i8;
                c1 += l7;
                c3 += j8;
                y3 += width;
                l4 += j5;
                k5 += i6;
                j6 += l6;
            }
            while (--y1 >= 0) {
                Rasterizer.drawTexturedScanline(raster, texels, y3, x2 >> 16, x3 >> 16, c2, c3, l4, k5, j6, i5, l5, k6, z3, depthSlope, bufferOffset);
                z3 += depthScale;
                x2 += i7;
                x3 += i8;
                c2 += j7;
                c3 += j8;
                y3 += width;
                l4 += j5;
                k5 += i6;
                j6 += l6;
            }
            return;
        }
        y1 -= y2;
        y2 -= y3;
        y3 = lineOffsets[y3];
        while (--y2 >= 0) {
            Rasterizer.drawTexturedScanline(raster, texels, y3, x3 >> 16, x1 >> 16, c3, c1, l4, k5, j6, i5, l5, k6, z3, depthSlope, bufferOffset);
            z3 += depthScale;
            x1 += k7;
            x3 += i8;
            c1 += l7;
            c3 += j8;
            y3 += width;
            l4 += j5;
            k5 += i6;
            j6 += l6;
        }
        while (--y1 >= 0) {
            Rasterizer.drawTexturedScanline(raster, texels, y3, x3 >> 16, x2 >> 16, c3, c2, l4, k5, j6, i5, l5, k6, z3, depthSlope, bufferOffset);
            z3 += depthScale;
            x2 += i7;
            x3 += i8;
            c2 += j7;
            c3 += j8;
            y3 += width;
            l4 += j5;
            k5 += i6;
            j6 += l6;
        }
    }

    private static void drawTexturedScanline(int[] dest, int[] src, int offset, int x1, int x2, int hsl1, int hsl2, int t1, int t2, int t3, int t4, int t5, int t6, float z1, float z2, int bufferOffset) {
        int darken = 0;
        int srcPos = 0;
        if (x1 >= x2) {
            return;
        }
        int dl = (hsl2 - hsl1) / (x2 - x1);
        if (restrict_edges) {
            if (x2 > DrawingArea.maxRight) {
                x2 = DrawingArea.maxRight;
            }
            if (x1 < 0) {
                hsl1 -= x1 * dl;
                x1 = 0;
            }
        }
        if (x1 >= x2) {
            return;
        }
        int n = x2 - x1 >> 3;
        offset += x1;
        z1 += z2 * (float)x1;
        int j4 = 0;
        int l4 = 0;
        int l6 = x1 - centerX;
        t1 += (t4 >> 3) * l6;
        t2 += (t5 >> 3) * l6;
        int l5 = (t3 += (t6 >> 3) * l6) >> 14;
        if (l5 != 0) {
            darken = t1 / l5;
            srcPos = t2 / l5;
            if (!repeatTexture) {
                if (darken < 0) {
                    darken = 0;
                } else if (darken > 16256) {
                    darken = 16256;
                }
            }
        }
        t1 += t4;
        t2 += t5;
        l5 = (t3 += t6) >> 14;
        if (l5 != 0) {
            j4 = t1 / l5;
            l4 = t2 / l5;
            if (!repeatTexture) {
                if (j4 < 7) {
                    j4 = 7;
                } else if (j4 > 16256) {
                    j4 = 16256;
                }
            }
        }
        int j7 = j4 - darken >> 3;
        int l7 = l4 - srcPos >> 3;
        if (aBoolean1463) {
            int l;
            int rgb;
            while (n-- > 0) {
                rgb = src[(srcPos & 0x3F80) + (darken >> 7)];
                l = hsl1 >> 16;
                if (z1 < depthBuffer[offset] || z1 < depthBuffer[offset] + (float)bufferOffset) {
                    dest[offset] = ((rgb & 0xFF00FF) * l & 0xFF00FF00) + ((rgb & 0xFF00) * l & 0xFF0000) >> 8;
                    Rasterizer.depthBuffer[offset] = z1;
                }
                ++offset;
                z1 += z2;
                rgb = src[repeatTexture ? (srcPos & 0x3F80) + (darken >> 7) & 0x3FFF : ((srcPos += l7) & 0x3F80) + ((darken += j7) >> 7)];
                l = (hsl1 += dl) >> 16;
                if (z1 < depthBuffer[offset] || z1 < depthBuffer[offset] + (float)bufferOffset) {
                    dest[offset] = ((rgb & 0xFF00FF) * l & 0xFF00FF00) + ((rgb & 0xFF00) * l & 0xFF0000) >> 8;
                    Rasterizer.depthBuffer[offset] = z1;
                }
                ++offset;
                z1 += z2;
                rgb = src[repeatTexture ? (srcPos & 0x3F80) + (darken >> 7) & 0x3FFF : ((srcPos += l7) & 0x3F80) + ((darken += j7) >> 7)];
                l = (hsl1 += dl) >> 16;
                if (z1 < depthBuffer[offset] || z1 < depthBuffer[offset] + (float)bufferOffset) {
                    dest[offset] = ((rgb & 0xFF00FF) * l & 0xFF00FF00) + ((rgb & 0xFF00) * l & 0xFF0000) >> 8;
                    Rasterizer.depthBuffer[offset] = z1;
                }
                ++offset;
                z1 += z2;
                rgb = src[repeatTexture ? (srcPos & 0x3F80) + (darken >> 7) & 0x3FFF : ((srcPos += l7) & 0x3F80) + ((darken += j7) >> 7)];
                l = (hsl1 += dl) >> 16;
                if (z1 < depthBuffer[offset] || z1 < depthBuffer[offset] + (float)bufferOffset) {
                    dest[offset] = ((rgb & 0xFF00FF) * l & 0xFF00FF00) + ((rgb & 0xFF00) * l & 0xFF0000) >> 8;
                    Rasterizer.depthBuffer[offset] = z1;
                }
                ++offset;
                z1 += z2;
                rgb = src[repeatTexture ? (srcPos & 0x3F80) + (darken >> 7) & 0x3FFF : ((srcPos += l7) & 0x3F80) + ((darken += j7) >> 7)];
                l = (hsl1 += dl) >> 16;
                if (z1 < depthBuffer[offset] || z1 < depthBuffer[offset] + (float)bufferOffset) {
                    dest[offset] = ((rgb & 0xFF00FF) * l & 0xFF00FF00) + ((rgb & 0xFF00) * l & 0xFF0000) >> 8;
                    Rasterizer.depthBuffer[offset] = z1;
                }
                ++offset;
                z1 += z2;
                rgb = src[repeatTexture ? (srcPos & 0x3F80) + (darken >> 7) & 0x3FFF : ((srcPos += l7) & 0x3F80) + ((darken += j7) >> 7)];
                l = (hsl1 += dl) >> 16;
                if (z1 < depthBuffer[offset] || z1 < depthBuffer[offset] + (float)bufferOffset) {
                    dest[offset] = ((rgb & 0xFF00FF) * l & 0xFF00FF00) + ((rgb & 0xFF00) * l & 0xFF0000) >> 8;
                    Rasterizer.depthBuffer[offset] = z1;
                }
                ++offset;
                z1 += z2;
                rgb = src[repeatTexture ? (srcPos & 0x3F80) + (darken >> 7) & 0x3FFF : ((srcPos += l7) & 0x3F80) + ((darken += j7) >> 7)];
                l = (hsl1 += dl) >> 16;
                if (z1 < depthBuffer[offset] || z1 < depthBuffer[offset] + (float)bufferOffset) {
                    dest[offset] = ((rgb & 0xFF00FF) * l & 0xFF00FF00) + ((rgb & 0xFF00) * l & 0xFF0000) >> 8;
                    Rasterizer.depthBuffer[offset] = z1;
                }
                ++offset;
                z1 += z2;
                rgb = src[repeatTexture ? (srcPos & 0x3F80) + (darken >> 7) & 0x3FFF : ((srcPos += l7) & 0x3F80) + ((darken += j7) >> 7)];
                l = (hsl1 += dl) >> 16;
                if (z1 < depthBuffer[offset] || z1 < depthBuffer[offset] + (float)bufferOffset) {
                    dest[offset] = ((rgb & 0xFF00FF) * l & 0xFF00FF00) + ((rgb & 0xFF00) * l & 0xFF0000) >> 8;
                    Rasterizer.depthBuffer[offset] = z1;
                }
                ++offset;
                z1 += z2;
                darken += j7;
                srcPos += l7;
                hsl1 += dl;
                t1 += t4;
                t2 += t5;
                int i6 = (t3 += t6) >> 14;
                if (i6 != 0) {
                    j4 = t1 / i6;
                    l4 = t2 / i6;
                    if (!repeatTexture) {
                        if (j4 < 7) {
                            j4 = 7;
                        } else if (j4 > 16256) {
                            j4 = 16256;
                        }
                    }
                }
                j7 = j4 - darken >> 3;
                l7 = l4 - srcPos >> 3;
                hsl1 += dl;
            }
            n = x2 - x1 & 7;
            while (n-- > 0) {
                rgb = src[repeatTexture ? (srcPos & 0x3F80) + (darken >> 7) & 0x3FFF : (srcPos & 0x3F80) + (darken >> 7)];
                l = hsl1 >> 16;
                if (z1 < depthBuffer[offset] || z1 < depthBuffer[offset] + (float)bufferOffset) {
                    dest[offset] = ((rgb & 0xFF00FF) * l & 0xFF00FF00) + ((rgb & 0xFF00) * l & 0xFF0000) >> 8;
                    Rasterizer.depthBuffer[offset] = z1;
                }
                z1 += z2;
                ++offset;
                darken += j7;
                srcPos += l7;
                hsl1 += dl;
            }
            return;
        }
        while (n-- > 0) {
            int l;
            int i9 = src[repeatTexture ? (srcPos & 0x3F80) + (darken >> 7) & 0x3FFF : (srcPos & 0x3F80) + (darken >> 7)];
            if (i9 != 0) {
                l = hsl1 >> 16;
                if (z1 < depthBuffer[offset] || z1 < depthBuffer[offset] + (float)bufferOffset) {
                    dest[offset] = ((i9 & 0xFF00FF) * l & 0xFF00FF00) + ((i9 & 0xFF00) * l & 0xFF0000) >> 8;
                    Rasterizer.depthBuffer[offset] = z1;
                }
            }
            z1 += z2;
            ++offset;
            hsl1 += dl;
            i9 = src[repeatTexture ? (srcPos & 0x3F80) + (darken >> 7) & 0x3FFF : ((srcPos += l7) & 0x3F80) + ((darken += j7) >> 7)];
            if (i9 != 0) {
                l = hsl1 >> 16;
                if (z1 < depthBuffer[offset] || z1 < depthBuffer[offset] + (float)bufferOffset) {
                    dest[offset] = ((i9 & 0xFF00FF) * l & 0xFF00FF00) + ((i9 & 0xFF00) * l & 0xFF0000) >> 8;
                    Rasterizer.depthBuffer[offset] = z1;
                }
            }
            z1 += z2;
            ++offset;
            hsl1 += dl;
            i9 = src[repeatTexture ? (srcPos & 0x3F80) + (darken >> 7) & 0x3FFF : ((srcPos += l7) & 0x3F80) + ((darken += j7) >> 7)];
            if (i9 != 0) {
                l = hsl1 >> 16;
                if (z1 < depthBuffer[offset] || z1 < depthBuffer[offset] + (float)bufferOffset) {
                    dest[offset] = ((i9 & 0xFF00FF) * l & 0xFF00FF00) + ((i9 & 0xFF00) * l & 0xFF0000) >> 8;
                    Rasterizer.depthBuffer[offset] = z1;
                }
            }
            z1 += z2;
            ++offset;
            hsl1 += dl;
            i9 = src[repeatTexture ? (srcPos & 0x3F80) + (darken >> 7) & 0x3FFF : ((srcPos += l7) & 0x3F80) + ((darken += j7) >> 7)];
            if (i9 != 0) {
                l = hsl1 >> 16;
                if (z1 < depthBuffer[offset] || z1 < depthBuffer[offset] + (float)bufferOffset) {
                    dest[offset] = ((i9 & 0xFF00FF) * l & 0xFF00FF00) + ((i9 & 0xFF00) * l & 0xFF0000) >> 8;
                    Rasterizer.depthBuffer[offset] = z1;
                }
            }
            z1 += z2;
            ++offset;
            hsl1 += dl;
            i9 = src[repeatTexture ? (srcPos & 0x3F80) + (darken >> 7) & 0x3FFF : ((srcPos += l7) & 0x3F80) + ((darken += j7) >> 7)];
            if (i9 != 0) {
                l = hsl1 >> 16;
                if (z1 < depthBuffer[offset] || z1 < depthBuffer[offset] + (float)bufferOffset) {
                    dest[offset] = ((i9 & 0xFF00FF) * l & 0xFF00FF00) + ((i9 & 0xFF00) * l & 0xFF0000) >> 8;
                    Rasterizer.depthBuffer[offset] = z1;
                }
            }
            z1 += z2;
            ++offset;
            hsl1 += dl;
            i9 = src[repeatTexture ? (srcPos & 0x3F80) + (darken >> 7) & 0x3FFF : ((srcPos += l7) & 0x3F80) + ((darken += j7) >> 7)];
            if (i9 != 0) {
                l = hsl1 >> 16;
                if (z1 < depthBuffer[offset] || z1 < depthBuffer[offset] + (float)bufferOffset) {
                    dest[offset] = ((i9 & 0xFF00FF) * l & 0xFF00FF00) + ((i9 & 0xFF00) * l & 0xFF0000) >> 8;
                    Rasterizer.depthBuffer[offset] = z1;
                }
            }
            z1 += z2;
            ++offset;
            hsl1 += dl;
            i9 = src[repeatTexture ? (srcPos & 0x3F80) + (darken >> 7) & 0x3FFF : ((srcPos += l7) & 0x3F80) + ((darken += j7) >> 7)];
            if (i9 != 0) {
                l = hsl1 >> 16;
                if (z1 < depthBuffer[offset] || z1 < depthBuffer[offset] + (float)bufferOffset) {
                    dest[offset] = ((i9 & 0xFF00FF) * l & 0xFF00FF00) + ((i9 & 0xFF00) * l & 0xFF0000) >> 8;
                    Rasterizer.depthBuffer[offset] = z1;
                }
            }
            z1 += z2;
            ++offset;
            hsl1 += dl;
            i9 = src[repeatTexture ? (srcPos & 0x3F80) + (darken >> 7) & 0x3FFF : ((srcPos += l7) & 0x3F80) + ((darken += j7) >> 7)];
            if (i9 != 0) {
                l = hsl1 >> 16;
                if (z1 < depthBuffer[offset] || z1 < depthBuffer[offset] + (float)bufferOffset) {
                    dest[offset] = ((i9 & 0xFF00FF) * l & 0xFF00FF00) + ((i9 & 0xFF00) * l & 0xFF0000) >> 8;
                    Rasterizer.depthBuffer[offset] = z1;
                }
            }
            z1 += z2;
            ++offset;
            darken += j7;
            srcPos += l7;
            hsl1 += dl;
            t1 += t4;
            t2 += t5;
            int j6 = (t3 += t6) >> 14;
            if (j6 != 0) {
                j4 = t1 / j6;
                l4 = t2 / j6;
                if (!repeatTexture) {
                    if (j4 < 7) {
                        j4 = 7;
                    } else if (j4 > 16256) {
                        j4 = 16256;
                    }
                }
            }
            j7 = j4 - darken >> 3;
            l7 = l4 - srcPos >> 3;
            hsl1 += dl;
        }
        int l3 = x2 - x1 & 7;
        while (l3-- > 0) {
            int j9 = src[repeatTexture ? (srcPos & 0x3F80) + (darken >> 7) & 0x3FFF : (srcPos & 0x3F80) + (darken >> 7)];
            if (j9 != 0) {
                int l = hsl1 >> 16;
                if (z1 < depthBuffer[offset] || z1 < depthBuffer[offset] + (float)bufferOffset) {
                    dest[offset] = ((j9 & 0xFF00FF) * l & 0xFF00FF00) + ((j9 & 0xFF00) * l & 0xFF0000) >> 8;
                    Rasterizer.depthBuffer[offset] = z1;
                }
            }
            z1 += z2;
            ++offset;
            darken += j7;
            srcPos += l7;
            hsl1 += dl;
        }
    }

    private static int texelPos(int defaultIndex) {
        int x = defaultIndex & 0x7F;
        int y = defaultIndex >> 7;
        return (x >>= textureMipmap) + ((y >>= textureMipmap) << 7 - textureMipmap);
    }

    public static void drawMaterializedTriangle(int y1, int y2, int y3, int x1, int x2, int x3, int hsl1, int hsl2, int hsl3, int tx1, int tx2, int tx3, int ty1, int ty2, int ty3, int tz1, int tz2, int tz3, int tex, float z1, float z2, float z3, int bufferOffset) {
        if (Texture.get(tex) == null) {
            Rasterizer.drawGouraudTriangle(y1, y2, y3, x1, x2, x3, hsl1, hsl2, hsl3, z1, z2, z3, bufferOffset);
            return;
        }
        int area = x1 * (y2 - y3) + x2 * (y3 - y1) + x3 * (y1 - y2) >> 1;
        if (area < 0) {
            area = -area;
        }
        textureMipmap = area > 4096 ? 1 : (area > 1024 ? 1 : (area > 256 ? 2 : (area > 64 ? 3 : (area > 16 ? 4 : (area > 4 ? 5 : (area > 1 ? 6 : 7))))));
        int[] texels = Texture.get((int)tex).mipmaps[textureMipmap];
        tx2 = tx1 - tx2;
        ty2 = ty1 - ty2;
        tz2 = tz1 - tz2;
        int l4 = (tx3 -= tx1) * ty1 - (ty3 -= ty1) * tx1 << 14;
        int i5 = (int)(((long)(ty3 * tz1 - (tz3 -= tz1) * ty1) << 3 << 14) / (long)fieldOfView);
        int j5 = (int)(((long)(tz3 * tx1 - tx3 * tz1) << 14) / (long)fieldOfView);
        int k5 = tx2 * ty1 - ty2 * tx1 << 14;
        int l5 = (int)(((long)(ty2 * tz1 - tz2 * ty1) << 3 << 14) / (long)fieldOfView);
        int i6 = (int)(((long)(tz2 * tx1 - tx2 * tz1) << 14) / (long)fieldOfView);
        int j6 = ty2 * tx3 - tx2 * ty3 << 14;
        int k6 = (int)(((long)(tz2 * ty3 - ty2 * tz3) << 3 << 14) / (long)fieldOfView);
        int l6 = (int)(((long)(tx2 * tz3 - tz2 * tx3) << 14) / (long)fieldOfView);
        int i7 = 0;
        int j7 = 0;
        if (y2 != y1) {
            i7 = (x2 - x1 << 16) / (y2 - y1);
            j7 = (hsl2 - hsl1 << 15) / (y2 - y1);
        }
        int k7 = 0;
        int l7 = 0;
        if (y3 != y2) {
            k7 = (x3 - x2 << 16) / (y3 - y2);
            l7 = (hsl3 - hsl2 << 15) / (y3 - y2);
        }
        int i8 = 0;
        int j8 = 0;
        if (y3 != y1) {
            i8 = (x1 - x3 << 16) / (y1 - y3);
            j8 = (hsl1 - hsl3 << 15) / (y1 - y3);
        }
        float x21 = x2 - x1;
        float y32 = y2 - y1;
        float x31 = x3 - x1;
        float y31 = y3 - y1;
        float z21 = z2 - z1;
        float z31 = z3 - z1;
        float div = x21 * y31 - x31 * y32;
        float depthSlope = (z21 * y31 - z31 * y32) / div;
        float depthScale = (z31 * x21 - z21 * x31) / div;
        if (y1 <= y2 && y1 <= y3) {
            if (y1 >= clipBottom) {
                return;
            }
            if (y2 > clipBottom) {
                y2 = clipBottom;
            }
            if (y3 > clipBottom) {
                y3 = clipBottom;
            }
            z1 = z1 - depthSlope * (float)x1 + depthSlope;
            if (y2 < y3) {
                x3 = x1 <<= 16;
                hsl3 = hsl1 <<= 15;
                if (y1 < 0) {
                    x3 -= i8 * y1;
                    x1 -= i7 * y1;
                    z1 -= depthScale * (float)y1;
                    hsl3 -= j8 * y1;
                    hsl1 -= j7 * y1;
                    y1 = 0;
                }
                x2 <<= 16;
                hsl2 <<= 15;
                if (y2 < 0) {
                    x2 -= k7 * y2;
                    hsl2 -= l7 * y2;
                    y2 = 0;
                }
                int k8 = y1 - centerY;
                l4 += j5 * k8;
                k5 += i6 * k8;
                j6 += l6 * k8;
                if (y1 != y2 && i8 < i7 || y1 == y2 && i8 > k7) {
                    y3 -= y2;
                    y2 -= y1;
                    y1 = lineOffsets[y1];
                    while (--y2 >= 0) {
                        Rasterizer.drawMaterializedScanline(raster, texels, y1, x3 >> 16, x1 >> 16, hsl3 >> 7, hsl1 >> 7, l4, k5, j6, i5, l5, k6, z1, depthSlope, bufferOffset);
                        x3 += i8;
                        x1 += i7;
                        z1 += depthScale;
                        hsl3 += j8;
                        hsl1 += j7;
                        y1 += width;
                        l4 += j5;
                        k5 += i6;
                        j6 += l6;
                    }
                    while (--y3 >= 0) {
                        Rasterizer.drawMaterializedScanline(raster, texels, y1, x3 >> 16, x2 >> 16, hsl3 >> 7, hsl2 >> 7, l4, k5, j6, i5, l5, k6, z1, depthSlope, bufferOffset);
                        x3 += i8;
                        x2 += k7;
                        z1 += depthScale;
                        hsl3 += j8;
                        hsl2 += l7;
                        y1 += width;
                        l4 += j5;
                        k5 += i6;
                        j6 += l6;
                    }
                    return;
                }
                y3 -= y2;
                y2 -= y1;
                y1 = lineOffsets[y1];
                while (--y2 >= 0) {
                    Rasterizer.drawMaterializedScanline(raster, texels, y1, x1 >> 16, x3 >> 16, hsl1 >> 7, hsl3 >> 7, l4, k5, j6, i5, l5, k6, z1, depthSlope, bufferOffset);
                    x3 += i8;
                    x1 += i7;
                    z1 += depthScale;
                    hsl3 += j8;
                    hsl1 += j7;
                    y1 += width;
                    l4 += j5;
                    k5 += i6;
                    j6 += l6;
                }
                while (--y3 >= 0) {
                    Rasterizer.drawMaterializedScanline(raster, texels, y1, x2 >> 16, x3 >> 16, hsl2 >> 7, hsl3 >> 7, l4, k5, j6, i5, l5, k6, z1, depthSlope, bufferOffset);
                    x3 += i8;
                    x2 += k7;
                    z1 += depthScale;
                    hsl3 += j8;
                    hsl2 += l7;
                    y1 += width;
                    l4 += j5;
                    k5 += i6;
                    j6 += l6;
                }
                return;
            }
            x2 = x1 <<= 16;
            hsl2 = hsl1 <<= 15;
            if (y1 < 0) {
                x2 -= i8 * y1;
                x1 -= i7 * y1;
                z1 -= depthScale * (float)y1;
                hsl2 -= j8 * y1;
                hsl1 -= j7 * y1;
                y1 = 0;
            }
            x3 <<= 16;
            hsl3 <<= 15;
            if (y3 < 0) {
                x3 -= k7 * y3;
                hsl3 -= l7 * y3;
                y3 = 0;
            }
            int l8 = y1 - centerY;
            l4 += j5 * l8;
            k5 += i6 * l8;
            j6 += l6 * l8;
            if (y1 != y3 && i8 < i7 || y1 == y3 && k7 > i7) {
                y2 -= y3;
                y3 -= y1;
                y1 = lineOffsets[y1];
                while (--y3 >= 0) {
                    Rasterizer.drawMaterializedScanline(raster, texels, y1, x2 >> 16, x1 >> 16, hsl2 >> 7, hsl1 >> 7, l4, k5, j6, i5, l5, k6, z1, depthSlope, bufferOffset);
                    x2 += i8;
                    x1 += i7;
                    z1 += depthScale;
                    hsl2 += j8;
                    hsl1 += j7;
                    y1 += width;
                    l4 += j5;
                    k5 += i6;
                    j6 += l6;
                }
                while (--y2 >= 0) {
                    Rasterizer.drawMaterializedScanline(raster, texels, y1, x3 >> 16, x1 >> 16, hsl3 >> 7, hsl1 >> 7, l4, k5, j6, i5, l5, k6, z1, depthSlope, bufferOffset);
                    x3 += k7;
                    x1 += i7;
                    z1 += depthScale;
                    hsl3 += l7;
                    hsl1 += j7;
                    y1 += width;
                    l4 += j5;
                    k5 += i6;
                    j6 += l6;
                }
                return;
            }
            y2 -= y3;
            y3 -= y1;
            y1 = lineOffsets[y1];
            while (--y3 >= 0) {
                Rasterizer.drawMaterializedScanline(raster, texels, y1, x1 >> 16, x2 >> 16, hsl1 >> 7, hsl2 >> 7, l4, k5, j6, i5, l5, k6, z1, depthSlope, bufferOffset);
                x2 += i8;
                x1 += i7;
                z1 += depthScale;
                hsl2 += j8;
                hsl1 += j7;
                y1 += width;
                l4 += j5;
                k5 += i6;
                j6 += l6;
            }
            while (--y2 >= 0) {
                Rasterizer.drawMaterializedScanline(raster, texels, y1, x1 >> 16, x3 >> 16, hsl1 >> 7, hsl3 >> 7, l4, k5, j6, i5, l5, k6, z1, depthSlope, bufferOffset);
                x3 += k7;
                x1 += i7;
                z1 += depthScale;
                hsl3 += l7;
                hsl1 += j7;
                y1 += width;
                l4 += j5;
                k5 += i6;
                j6 += l6;
            }
            return;
        }
        if (y2 <= y3) {
            if (y2 >= clipBottom) {
                return;
            }
            if (y3 > clipBottom) {
                y3 = clipBottom;
            }
            if (y1 > clipBottom) {
                y1 = clipBottom;
            }
            z2 = z2 - depthSlope * (float)x2 + depthSlope;
            if (y3 < y1) {
                x1 = x2 <<= 16;
                hsl1 = hsl2 <<= 15;
                if (y2 < 0) {
                    x1 -= i7 * y2;
                    x2 -= k7 * y2;
                    z2 -= depthScale * (float)y2;
                    hsl1 -= j7 * y2;
                    hsl2 -= l7 * y2;
                    y2 = 0;
                }
                x3 <<= 16;
                hsl3 <<= 15;
                if (y3 < 0) {
                    x3 -= i8 * y3;
                    hsl3 -= j8 * y3;
                    y3 = 0;
                }
                int i9 = y2 - centerY;
                l4 += j5 * i9;
                k5 += i6 * i9;
                j6 += l6 * i9;
                if (y2 != y3 && i7 < k7 || y2 == y3 && i7 > i8) {
                    y1 -= y3;
                    y3 -= y2;
                    y2 = lineOffsets[y2];
                    while (--y3 >= 0) {
                        Rasterizer.drawMaterializedScanline(raster, texels, y2, x1 >> 16, x2 >> 16, hsl1 >> 7, hsl2 >> 7, l4, k5, j6, i5, l5, k6, z2, depthSlope, bufferOffset);
                        x1 += i7;
                        x2 += k7;
                        z2 += depthScale;
                        hsl1 += j7;
                        hsl2 += l7;
                        y2 += width;
                        l4 += j5;
                        k5 += i6;
                        j6 += l6;
                    }
                    while (--y1 >= 0) {
                        Rasterizer.drawMaterializedScanline(raster, texels, y2, x1 >> 16, x3 >> 16, hsl1 >> 7, hsl3 >> 7, l4, k5, j6, i5, l5, k6, z2, depthSlope, bufferOffset);
                        x1 += i7;
                        x3 += i8;
                        z2 += depthScale;
                        hsl1 += j7;
                        hsl3 += j8;
                        y2 += width;
                        l4 += j5;
                        k5 += i6;
                        j6 += l6;
                    }
                    return;
                }
                y1 -= y3;
                y3 -= y2;
                y2 = lineOffsets[y2];
                while (--y3 >= 0) {
                    Rasterizer.drawMaterializedScanline(raster, texels, y2, x2 >> 16, x1 >> 16, hsl2 >> 7, hsl1 >> 7, l4, k5, j6, i5, l5, k6, z2, depthSlope, bufferOffset);
                    x1 += i7;
                    x2 += k7;
                    z2 += depthScale;
                    hsl1 += j7;
                    hsl2 += l7;
                    y2 += width;
                    l4 += j5;
                    k5 += i6;
                    j6 += l6;
                }
                while (--y1 >= 0) {
                    Rasterizer.drawMaterializedScanline(raster, texels, y2, x3 >> 16, x1 >> 16, hsl3 >> 7, hsl1 >> 7, l4, k5, j6, i5, l5, k6, z2, depthSlope, bufferOffset);
                    x1 += i7;
                    x3 += i8;
                    z2 += depthScale;
                    hsl1 += j7;
                    hsl3 += j8;
                    y2 += width;
                    l4 += j5;
                    k5 += i6;
                    j6 += l6;
                }
                return;
            }
            x3 = x2 <<= 16;
            hsl3 = hsl2 <<= 15;
            if (y2 < 0) {
                x3 -= i7 * y2;
                x2 -= k7 * y2;
                z2 -= depthScale * (float)y2;
                hsl3 -= j7 * y2;
                hsl2 -= l7 * y2;
                y2 = 0;
            }
            x1 <<= 16;
            hsl1 <<= 15;
            if (y1 < 0) {
                x1 -= i8 * y1;
                hsl1 -= j8 * y1;
                y1 = 0;
            }
            int j9 = y2 - centerY;
            l4 += j5 * j9;
            k5 += i6 * j9;
            j6 += l6 * j9;
            if (i7 < k7) {
                y3 -= y1;
                y1 -= y2;
                y2 = lineOffsets[y2];
                while (--y1 >= 0) {
                    Rasterizer.drawMaterializedScanline(raster, texels, y2, x3 >> 16, x2 >> 16, hsl3 >> 7, hsl2 >> 7, l4, k5, j6, i5, l5, k6, z2, depthSlope, bufferOffset);
                    x3 += i7;
                    x2 += k7;
                    z2 += depthScale;
                    hsl3 += j7;
                    hsl2 += l7;
                    y2 += width;
                    l4 += j5;
                    k5 += i6;
                    j6 += l6;
                }
                while (--y3 >= 0) {
                    Rasterizer.drawMaterializedScanline(raster, texels, y2, x1 >> 16, x2 >> 16, hsl1 >> 7, hsl2 >> 7, l4, k5, j6, i5, l5, k6, z2, depthSlope, bufferOffset);
                    x1 += i8;
                    x2 += k7;
                    z2 += depthScale;
                    hsl1 += j8;
                    hsl2 += l7;
                    y2 += width;
                    l4 += j5;
                    k5 += i6;
                    j6 += l6;
                }
                return;
            }
            y3 -= y1;
            y1 -= y2;
            y2 = lineOffsets[y2];
            while (--y1 >= 0) {
                Rasterizer.drawMaterializedScanline(raster, texels, y2, x2 >> 16, x3 >> 16, hsl2 >> 7, hsl3 >> 7, l4, k5, j6, i5, l5, k6, z2, depthSlope, bufferOffset);
                x3 += i7;
                x2 += k7;
                z2 += depthScale;
                hsl3 += j7;
                hsl2 += l7;
                y2 += width;
                l4 += j5;
                k5 += i6;
                j6 += l6;
            }
            while (--y3 >= 0) {
                Rasterizer.drawMaterializedScanline(raster, texels, y2, x2 >> 16, x1 >> 16, hsl2 >> 7, hsl1 >> 7, l4, k5, j6, i5, l5, k6, z2, depthSlope, bufferOffset);
                x1 += i8;
                x2 += k7;
                z2 += depthScale;
                hsl1 += j8;
                hsl2 += l7;
                y2 += width;
                l4 += j5;
                k5 += i6;
                j6 += l6;
            }
            return;
        }
        if (y3 >= clipBottom) {
            return;
        }
        if (y1 > clipBottom) {
            y1 = clipBottom;
        }
        if (y2 > clipBottom) {
            y2 = clipBottom;
        }
        z3 = z3 - depthSlope * (float)x3 + depthSlope;
        if (y1 < y2) {
            x2 = x3 <<= 16;
            hsl2 = hsl3 <<= 15;
            if (y3 < 0) {
                x2 -= k7 * y3;
                x3 -= i8 * y3;
                z3 -= depthScale * (float)y3;
                hsl2 -= l7 * y3;
                hsl3 -= j8 * y3;
                y3 = 0;
            }
            x1 <<= 16;
            hsl1 <<= 15;
            if (y1 < 0) {
                x1 -= i7 * y1;
                hsl1 -= j7 * y1;
                y1 = 0;
            }
            int k9 = y3 - centerY;
            l4 += j5 * k9;
            k5 += i6 * k9;
            j6 += l6 * k9;
            if (k7 < i8) {
                y2 -= y1;
                y1 -= y3;
                y3 = lineOffsets[y3];
                while (--y1 >= 0) {
                    Rasterizer.drawMaterializedScanline(raster, texels, y3, x2 >> 16, x3 >> 16, hsl2 >> 7, hsl3 >> 7, l4, k5, j6, i5, l5, k6, z3, depthSlope, bufferOffset);
                    x2 += k7;
                    x3 += i8;
                    z3 += depthScale;
                    hsl2 += l7;
                    hsl3 += j8;
                    y3 += width;
                    l4 += j5;
                    k5 += i6;
                    j6 += l6;
                }
                while (--y2 >= 0) {
                    Rasterizer.drawMaterializedScanline(raster, texels, y3, x2 >> 16, x1 >> 16, hsl2 >> 7, hsl1 >> 7, l4, k5, j6, i5, l5, k6, z3, depthSlope, bufferOffset);
                    x2 += k7;
                    x1 += i7;
                    z3 += depthScale;
                    hsl2 += l7;
                    hsl1 += j7;
                    y3 += width;
                    l4 += j5;
                    k5 += i6;
                    j6 += l6;
                }
                return;
            }
            y2 -= y1;
            y1 -= y3;
            y3 = lineOffsets[y3];
            while (--y1 >= 0) {
                Rasterizer.drawMaterializedScanline(raster, texels, y3, x3 >> 16, x2 >> 16, hsl3 >> 7, hsl2 >> 7, l4, k5, j6, i5, l5, k6, z3, depthSlope, bufferOffset);
                x2 += k7;
                x3 += i8;
                z3 += depthScale;
                hsl2 += l7;
                hsl3 += j8;
                y3 += width;
                l4 += j5;
                k5 += i6;
                j6 += l6;
            }
            while (--y2 >= 0) {
                Rasterizer.drawMaterializedScanline(raster, texels, y3, x1 >> 16, x2 >> 16, hsl1 >> 7, hsl2 >> 7, l4, k5, j6, i5, l5, k6, z3, depthSlope, bufferOffset);
                x2 += k7;
                x1 += i7;
                z3 += depthScale;
                hsl2 += l7;
                hsl1 += j7;
                y3 += width;
                l4 += j5;
                k5 += i6;
                j6 += l6;
            }
            return;
        }
        x1 = x3 <<= 16;
        hsl1 = hsl3 <<= 15;
        if (y3 < 0) {
            x1 -= k7 * y3;
            x3 -= i8 * y3;
            z3 -= depthScale * (float)y3;
            hsl1 -= l7 * y3;
            hsl3 -= j8 * y3;
            y3 = 0;
        }
        x2 <<= 16;
        hsl2 <<= 15;
        if (y2 < 0) {
            x2 -= i7 * y2;
            hsl2 -= j7 * y2;
            y2 = 0;
        }
        int l9 = y3 - centerY;
        l4 += j5 * l9;
        k5 += i6 * l9;
        j6 += l6 * l9;
        if (k7 < i8) {
            y1 -= y2;
            y2 -= y3;
            y3 = lineOffsets[y3];
            while (--y2 >= 0) {
                Rasterizer.drawMaterializedScanline(raster, texels, y3, x1 >> 16, x3 >> 16, hsl1 >> 7, hsl3 >> 7, l4, k5, j6, i5, l5, k6, z3, depthSlope, bufferOffset);
                x1 += k7;
                x3 += i8;
                z3 += depthScale;
                hsl1 += l7;
                hsl3 += j8;
                y3 += width;
                l4 += j5;
                k5 += i6;
                j6 += l6;
            }
            while (--y1 >= 0) {
                Rasterizer.drawMaterializedScanline(raster, texels, y3, x2 >> 16, x3 >> 16, hsl2 >> 7, hsl3 >> 7, l4, k5, j6, i5, l5, k6, z3, depthSlope, bufferOffset);
                x2 += i7;
                x3 += i8;
                z3 += depthScale;
                hsl2 += j7;
                hsl3 += j8;
                y3 += width;
                l4 += j5;
                k5 += i6;
                j6 += l6;
            }
            return;
        }
        y1 -= y2;
        y2 -= y3;
        y3 = lineOffsets[y3];
        while (--y2 >= 0) {
            Rasterizer.drawMaterializedScanline(raster, texels, y3, x3 >> 16, x1 >> 16, hsl3 >> 7, hsl1 >> 7, l4, k5, j6, i5, l5, k6, z3, depthSlope, bufferOffset);
            x1 += k7;
            x3 += i8;
            z3 += depthScale;
            hsl1 += l7;
            hsl3 += j8;
            y3 += width;
            l4 += j5;
            k5 += i6;
            j6 += l6;
        }
        while (--y1 >= 0) {
            Rasterizer.drawMaterializedScanline(raster, texels, y3, x3 >> 16, x2 >> 16, hsl3 >> 7, hsl2 >> 7, l4, k5, j6, i5, l5, k6, z3, depthSlope, bufferOffset);
            x2 += i7;
            x3 += i8;
            z3 += depthScale;
            hsl2 += j7;
            hsl3 += j8;
            y3 += width;
            l4 += j5;
            k5 += i6;
            j6 += l6;
        }
    }

    private static final void drawMaterializedScanline(int[] dest, int[] texels, int offset, int x1, int x2, int hsl1, int hsl2, int t1, int t2, int t3, int t4, int t5, int t6, float z1, float z2, int bufferOffset) {
        if (x2 <= x1) {
            return;
        }
        int texPos = 0;
        int rgb = 0;
        if (restrict_edges) {
            if (x2 > DrawingArea.maxRight) {
                x2 = DrawingArea.maxRight;
            }
            if (x1 < 0) {
                x1 = 0;
            }
        }
        if (x1 < x2) {
            int light;
            int i_61_;
            int i_60_;
            int i_59_;
            int i_58_;
            offset += x1;
            z1 += z2 * (float)x1;
            int n = x2 - x1 >> 2;
            int dhsl = 0;
            if (n > 0) {
                dhsl = (hsl2 - hsl1) * shadowDecay[n] >> 15;
            }
            int dist = x1 - centerX;
            t1 += (t4 >> 3) * dist;
            t2 += (t5 >> 3) * dist;
            int i_57_ = (t3 += (t6 >> 3) * dist) >> 14;
            if (i_57_ != 0) {
                i_58_ = t1 / i_57_;
                i_59_ = t2 / i_57_;
            } else {
                i_58_ = 0;
                i_59_ = 0;
            }
            t1 += t4;
            t2 += t5;
            i_57_ = (t3 += t6) >> 14;
            if (i_57_ != 0) {
                i_60_ = t1 / i_57_;
                i_61_ = t2 / i_57_;
            } else {
                i_60_ = 0;
                i_61_ = 0;
            }
            texPos = (i_58_ << 18) + i_59_;
            int dtexPos = (i_60_ - i_58_ >> 3 << 18) + (i_61_ - i_59_ >> 3);
            if ((n >>= 1) > 0) {
                do {
                    if ((light = (((hsl1 += dhsl) >> 8 & 0x7F) << 1) * ((((rgb = texels[Rasterizer.texelPos((texPos & 0x3F80) + (texPos >>> 25))]) >> 16 & 0xFF) + (rgb >> 8 & 0xFF) + (rgb & 0xFF)) / 3) / 384) > 127) {
                        light = 127;
                    }
                    texPos += dtexPos;
                    if (z1 < depthBuffer[offset] || z1 < depthBuffer[offset] + (float)bufferOffset) {
                        dest[offset] = hsl2rgb[hsl1 >> 8 & 0xFF80 | light];
                        Rasterizer.depthBuffer[offset] = z1;
                    }
                    z1 += z2;
                    ++offset;
                    rgb = texels[Rasterizer.texelPos((texPos & 0x3F80) + (texPos >>> 25))];
                    light = ((hsl1 >> 8 & 0x7F) << 1) * (((rgb >> 16 & 0xFF) + (rgb >> 8 & 0xFF) + (rgb & 0xFF)) / 3) / 384;
                    if (light > 127) {
                        light = 127;
                    }
                    texPos += dtexPos;
                    if (z1 < depthBuffer[offset] || z1 < depthBuffer[offset] + (float)bufferOffset) {
                        dest[offset] = hsl2rgb[hsl1 >> 8 & 0xFF80 | light];
                        Rasterizer.depthBuffer[offset] = z1;
                    }
                    z1 += z2;
                    ++offset;
                    rgb = texels[Rasterizer.texelPos((texPos & 0x3F80) + (texPos >>> 25))];
                    light = ((hsl1 >> 8 & 0x7F) << 1) * (((rgb >> 16 & 0xFF) + (rgb >> 8 & 0xFF) + (rgb & 0xFF)) / 3) / 384;
                    if (light > 127) {
                        light = 127;
                    }
                    texPos += dtexPos;
                    if (z1 < depthBuffer[offset] || z1 < depthBuffer[offset] + (float)bufferOffset) {
                        dest[offset] = hsl2rgb[hsl1 >> 8 & 0xFF80 | light];
                        Rasterizer.depthBuffer[offset] = z1;
                    }
                    z1 += z2;
                    ++offset;
                    rgb = texels[Rasterizer.texelPos((texPos & 0x3F80) + (texPos >>> 25))];
                    light = ((hsl1 >> 8 & 0x7F) << 1) * (((rgb >> 16 & 0xFF) + (rgb >> 8 & 0xFF) + (rgb & 0xFF)) / 3) / 384;
                    if (light > 127) {
                        light = 127;
                    }
                    texPos += dtexPos;
                    if (z1 < depthBuffer[offset] || z1 < depthBuffer[offset] + (float)bufferOffset) {
                        dest[offset] = hsl2rgb[hsl1 >> 8 & 0xFF80 | light];
                        Rasterizer.depthBuffer[offset] = z1;
                    }
                    z1 += z2;
                    ++offset;
                    rgb = texels[Rasterizer.texelPos((texPos & 0x3F80) + (texPos >>> 25))];
                    light = (((hsl1 += dhsl) >> 8 & 0x7F) << 1) * (((rgb >> 16 & 0xFF) + (rgb >> 8 & 0xFF) + (rgb & 0xFF)) / 3) / 384;
                    if (light > 127) {
                        light = 127;
                    }
                    texPos += dtexPos;
                    if (z1 < depthBuffer[offset] || z1 < depthBuffer[offset] + (float)bufferOffset) {
                        dest[offset] = hsl2rgb[hsl1 >> 8 & 0xFF80 | light];
                        Rasterizer.depthBuffer[offset] = z1;
                    }
                    z1 += z2;
                    ++offset;
                    rgb = texels[Rasterizer.texelPos((texPos & 0x3F80) + (texPos >>> 25))];
                    light = ((hsl1 >> 8 & 0x7F) << 1) * (((rgb >> 16 & 0xFF) + (rgb >> 8 & 0xFF) + (rgb & 0xFF)) / 3) / 384;
                    if (light > 127) {
                        light = 127;
                    }
                    texPos += dtexPos;
                    if (z1 < depthBuffer[offset] || z1 < depthBuffer[offset] + (float)bufferOffset) {
                        dest[offset] = hsl2rgb[hsl1 >> 8 & 0xFF80 | light];
                        Rasterizer.depthBuffer[offset] = z1;
                    }
                    z1 += z2;
                    ++offset;
                    rgb = texels[Rasterizer.texelPos((texPos & 0x3F80) + (texPos >>> 25))];
                    light = ((hsl1 >> 8 & 0x7F) << 1) * (((rgb >> 16 & 0xFF) + (rgb >> 8 & 0xFF) + (rgb & 0xFF)) / 3) / 384;
                    if (light > 127) {
                        light = 127;
                    }
                    texPos += dtexPos;
                    if (z1 < depthBuffer[offset] || z1 < depthBuffer[offset] + (float)bufferOffset) {
                        dest[offset] = hsl2rgb[hsl1 >> 8 & 0xFF80 | light];
                        Rasterizer.depthBuffer[offset] = z1;
                    }
                    z1 += z2;
                    ++offset;
                    rgb = texels[Rasterizer.texelPos((texPos & 0x3F80) + (texPos >>> 25))];
                    light = ((hsl1 >> 8 & 0x7F) << 1) * (((rgb >> 16 & 0xFF) + (rgb >> 8 & 0xFF) + (rgb & 0xFF)) / 3) / 384;
                    if (light > 127) {
                        light = 127;
                    }
                    texPos += dtexPos;
                    if (z1 < depthBuffer[offset] || z1 < depthBuffer[offset] + (float)bufferOffset) {
                        dest[offset] = hsl2rgb[hsl1 >> 8 & 0xFF80 | light];
                        Rasterizer.depthBuffer[offset] = z1;
                    }
                    z1 += z2;
                    ++offset;
                    i_58_ = i_60_;
                    i_59_ = i_61_;
                    t1 += t4;
                    t2 += t5;
                    i_57_ = (t3 += t6) >> 14;
                    if (i_57_ != 0) {
                        i_60_ = t1 / i_57_;
                        i_61_ = t2 / i_57_;
                    } else {
                        i_60_ = 0;
                        i_61_ = 0;
                    }
                    texPos = (i_58_ << 18) + i_59_;
                    dtexPos = (i_60_ - i_58_ >> 3 << 18) + (i_61_ - i_59_ >> 3);
                } while (--n > 0);
            }
            if ((n = x2 - x1 & 7) > 0) {
                do {
                    if ((n & 3) == 0) {
                        hsl1 += dhsl;
                    }
                    if ((light = ((hsl1 >> 8 & 0x7F) << 1) * ((((rgb = texels[Rasterizer.texelPos((texPos & 0x3F80) + (texPos >>> 25))]) >> 16 & 0xFF) + (rgb >> 8 & 0xFF) + (rgb & 0xFF)) / 3) / 384) > 127) {
                        light = 127;
                    }
                    texPos += dtexPos;
                    if (z1 < depthBuffer[offset] || z1 < depthBuffer[offset] + (float)bufferOffset) {
                        dest[offset] = hsl2rgb[hsl1 >> 8 & 0xFF80 | light];
                        Rasterizer.depthBuffer[offset] = z1;
                    }
                    z1 += z2;
                    ++offset;
                } while (--n > 0);
            }
        }
    }

    public static void nullify() {
        shadowDecay = null;
        shadowDecay = null;
        SINE = null;
        COSINE = null;
        lineOffsets = null;
        textures = null;
        aBooleanArray1475 = null;
        averageTextureRGB = null;
        texelPool = null;
        activeTexels = null;
        textureCycle = null;
        hsl2rgb = null;
        texturePalette = null;
    }

    public static void setBounds(int offSetX, int offSetY) {
        lineOffsets = new int[offSetY];
        for (int l = 0; l < offSetY; ++l) {
            Rasterizer.lineOffsets[l] = offSetX * l;
        }
        centerX = offSetX / 2;
        centerY = offSetY / 2;
    }

    static {
        textures = new Background[98];
        aBooleanArray1475 = new boolean[98];
        averageTextureRGB = new int[98];
        textureCycle = new int[98];
        hsl2rgb = new int[65536];
        activeTexels = new int[98][];
        texturePalette = new int[98][];
        lowDetail = false;
        notTextured = true;
        OFFSETS_512_334 = null;
        OFFSETS_765_503 = null;
        shadowDecay = new int[512];
        anIntArray1469 = new int[2048];
        SINE = new int[2479];
        COSINE = new int[2479];
        for (int i = 1; i < 512; ++i) {
            Rasterizer.shadowDecay[i] = 32768 / i;
        }
        for (int j = 1; j < 2048; ++j) {
            Rasterizer.anIntArray1469[j] = 65536 / j;
        }
        for (int k = 0; k < 2048; ++k) {
            Rasterizer.SINE[k] = (int)(65536.0 * Math.sin((double)k * 0.0030679615));
            Rasterizer.COSINE[k] = (int)(65536.0 * Math.cos((double)k * 0.0030679615));
        }
        repeatTexture = false;
        forceRepeat = false;
    }
}

