/*
 * Decompiled with CFR 0.152.
 */
package org.necrotic.client.world.background;

import org.necrotic.client.Client;

public class ScriptManager {
    private boolean loop;
    private double xCameraPos;
    private double yCameraPos;
    private double zCameraPos;
    private double xCameraCurve;
    private double yCameraCurve;
    private int cycles;
    private double xCameraPosRate;
    private double yCameraPosRate;
    private double zCameraPosRate;
    private double xCameraCurveRate;
    private double yCameraCurveRate;
    private int pos;
    private final Client instance;
    private int[] cameraIndex;
    public int terrainRegionX;
    public int terrainRegionY;
    public int regionPlane;

    private static double curve(double d, double d1) {
        double d2 = d - d1;
        double d3 = 2048.0 - d1 + d;
        double d4 = 2048.0 - d + d1;
        double d5 = Math.abs(d2);
        double d6 = Math.abs(d3);
        double d7 = Math.abs(d4);
        if (d5 < d6 && d5 < d7) {
            return d2;
        }
        if (d6 < d5 && d6 < d7) {
            return d3;
        }
        if (d7 < d5 && d7 < d6) {
            return d4;
        }
        return d2;
    }

    private static double p5(double d) {
        d = Math.abs(d);
        return d * d * d * d * d;
    }

    private static int round(double d) {
        d = d < 0.0 ? (d -= 0.5) : (d += 0.5);
        return (int)d;
    }

    private static double sgn(double d, double d1) {
        return (d %= d1) < 0.0 ? d + d1 : d;
    }

    private static final int warp(int speed) {
        return ~speed + 2;
    }

    public ScriptManager(Client client) {
        int generateLocation = (int)(Math.random() * 9.0);
        this.instance = client;
        int cycleSpeed = 0;
        switch (generateLocation) {
            case 0: {
                this.cameraMapping(401, 424, 0, false, new int[]{6711, 5920, -1901, 2032, 383, cycleSpeed, 6597, 7213, -665, 2034, 128, cycleSpeed, 6454, 8791, -715, 1983, 133, cycleSpeed, 6452, 9108, -1017, 1951, 208, cycleSpeed, 6131, 10220, -1420, 1794, 288, cycleSpeed, 6135, 11541, -1420, 1277, 288, cycleSpeed, 7432, 11543, -1420, 772, 288, cycleSpeed, 7440, 10224, -1420, 256, 288, cycleSpeed});
                break;
            }
            case 1: {
                this.cameraMapping(375, 422, 0, false, new int[]{7963, 6612, -425, 500, 128, cycleSpeed, 6431, 6612, -1073, 500, 128, cycleSpeed, 5792, 6612, -1145, 500, 128, cycleSpeed, 5792, 6612, -1145, 500, 128, cycleSpeed, 4500, 6612, -950, 500, 128, cycleSpeed, 2750, 6568, -1500, 556, 128, cycleSpeed, 2750, 6568, -1500, 2900, 150, ScriptManager.warp(4)});
                break;
            }
            case 2: {
                this.cameraMapping(395, 402, 0, false, new int[]{10000, 2000, -900, 300, 278, cycleSpeed, 7000, 11600, -1125, -300, 278, cycleSpeed, 3000, 7000, -1125, -300, 278, cycleSpeed});
                break;
            }
            case 3: {
                this.cameraMapping(354, 370, 0, false, new int[]{10000, 2000, -1200, 300, 278, cycleSpeed, 7000, 11600, -1305, -300, 308, cycleSpeed, 3000, 7000, -1305, -300, 308, cycleSpeed});
                break;
            }
            case 4: {
                this.cameraMapping(316, 411, 0, false, new int[]{10000, 2000, -900, 300, 278, cycleSpeed, 7000, 11600, -1125, -300, 278, cycleSpeed, 3000, 7000, -1125, -300, 278, cycleSpeed});
                break;
            }
            case 5: {
                this.cameraMapping(300, 388, 0, false, new int[]{10000, 2000, -1200, 300, 278, cycleSpeed, 7000, 11600, -1305, -300, 308, cycleSpeed, 3000, 7000, -1305, -300, 308, cycleSpeed});
            }
        }
        this.reset();
    }

    private void cameraMapping(int x, int y, int plane, boolean loop, int[] cameraIndex) {
        this.terrainRegionX = x;
        this.terrainRegionY = y;
        this.regionPlane = plane;
        this.loop = true;
        this.cameraIndex = cameraIndex;
    }

    public void cycle() {
        boolean justReset = false;
        while (this.cycles < 1) {
            if (this.cameraIndex == null) {
                return;
            }
            int total = this.cameraIndex.length / 6;
            if (this.pos < 0 || this.pos >= total) {
                if (this.loop && !justReset) {
                    justReset = true;
                    this.pos = 0;
                    this.cycles = 0;
                    if (this.instance.plane != this.regionPlane) {
                        this.instance.plane = this.regionPlane;
                    }
                    if (this.instance.terrainRegionX != this.terrainRegionX || this.instance.terrainRegionY != this.terrainRegionY) {
                        this.instance.generateWorld(this.terrainRegionX, this.terrainRegionY);
                    }
                    this.instance.resetWorld(1);
                }
                return;
            }
            int idx = (this.pos << 2) + (this.pos << 1);
            ++this.pos;
            if (this.cameraIndex[5 + idx] == Integer.MIN_VALUE) {
                this.instance.setNorth();
                if (this.instance.plane != this.cameraIndex[idx + 2]) {
                    this.instance.plane = this.cameraIndex[idx + 2];
                }
                if (this.instance.terrainRegionX != this.cameraIndex[idx] || this.instance.terrainRegionY != this.cameraIndex[idx + 1]) {
                    this.instance.generateWorld(this.cameraIndex[idx], this.cameraIndex[idx + 1]);
                }
                this.instance.resetWorld(1);
                break;
            }
            double xPos = (double)this.cameraIndex[idx] - this.xCameraPos;
            double yPos = (double)this.cameraIndex[1 + idx] - this.yCameraPos;
            double zPos = (double)this.cameraIndex[2 + idx] - this.zCameraPos;
            double xCurve = ScriptManager.curve(this.cameraIndex[3 + idx] & 0x7FF, this.xCameraCurve);
            double yCurve = ScriptManager.curve(this.cameraIndex[4 + idx] & 0x7FF, this.yCameraCurve);
            this.cycles = this.cameraIndex[5 + idx];
            if (this.cycles < 1) {
                int mult = ~this.cycles + 2;
                double cyclesD = Math.pow(ScriptManager.p5(xPos) + ScriptManager.p5(yPos) + ScriptManager.p5(zPos) + ScriptManager.p5(xCurve) + ScriptManager.p5(yCurve), 0.2);
                this.cycles = ScriptManager.round(cyclesD / 7.5);
                if (this.cycles < 1) {
                    this.cycles = 1;
                }
                this.cycles *= mult;
            }
            this.xCameraPosRate = xPos / (double)this.cycles;
            this.yCameraPosRate = yPos / (double)this.cycles;
            this.zCameraPosRate = zPos / (double)this.cycles;
            this.xCameraCurveRate = xCurve / (double)this.cycles;
            this.yCameraCurveRate = yCurve / (double)this.cycles;
        }
        if (this.cycles > 0) {
            this.xCameraPos += this.xCameraPosRate;
            this.yCameraPos += this.yCameraPosRate;
            this.zCameraPos += this.zCameraPosRate;
            this.xCameraCurve = ScriptManager.sgn(this.xCameraCurve + this.xCameraCurveRate, 2048.0);
            this.yCameraCurve = ScriptManager.sgn(this.yCameraCurve + this.yCameraCurveRate, 2048.0);
            this.update();
            --this.cycles;
        }
    }

    private void reset() {
        this.pos = 1;
        this.cycles = 0;
        if (this.cameraIndex == null) {
            return;
        }
        if (this.cameraIndex.length < 6) {
            return;
        }
        this.xCameraPos = this.cameraIndex[0];
        this.yCameraPos = this.cameraIndex[1];
        this.zCameraPos = this.cameraIndex[2];
        this.xCameraCurve = this.cameraIndex[3] & 0x7FF;
        this.yCameraCurve = this.cameraIndex[4] & 0x7FF;
        this.update();
    }

    public void update() {
        this.instance.xCameraPos = ScriptManager.round(this.xCameraPos);
        this.instance.yCameraPos = ScriptManager.round(this.yCameraPos);
        this.instance.zCameraPos = ScriptManager.round(this.zCameraPos);
        this.instance.xCameraCurve = ScriptManager.round(this.xCameraCurve) & 0x7FF;
        this.instance.yCameraCurve = ScriptManager.round(this.yCameraCurve) & 0x7FF;
    }
}

