/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.utils;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPasswordField;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JRootPane;
import javax.swing.JScrollBar;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ButtonUI;
import javax.swing.plaf.UIResource;
import javax.swing.text.JTextComponent;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.SubstanceCortex;
import org.pushingpixels.substance.api.SubstanceSkin;
import org.pushingpixels.substance.api.SubstanceSlices;
import org.pushingpixels.substance.api.UiThreadingViolationException;
import org.pushingpixels.substance.api.colorscheme.BottleGreenColorScheme;
import org.pushingpixels.substance.api.colorscheme.LightAquaColorScheme;
import org.pushingpixels.substance.api.colorscheme.SubstanceColorScheme;
import org.pushingpixels.substance.api.colorscheme.SunfireRedColorScheme;
import org.pushingpixels.substance.api.colorscheme.SunsetColorScheme;
import org.pushingpixels.substance.api.combo.ComboPopupPrototypeCallback;
import org.pushingpixels.substance.api.icon.IsHiDpiAware;
import org.pushingpixels.substance.api.icon.SubstanceIconUIResource;
import org.pushingpixels.substance.api.painter.border.SubstanceBorderPainter;
import org.pushingpixels.substance.api.painter.fill.SubstanceFillPainter;
import org.pushingpixels.substance.api.shaper.SubstanceButtonShaper;
import org.pushingpixels.substance.api.tabbed.TabCloseCallback;
import org.pushingpixels.substance.internal.animation.TransitionAwareUI;
import org.pushingpixels.substance.internal.contrib.intellij.JBHiDPIScaledImage;
import org.pushingpixels.substance.internal.contrib.intellij.UIUtil;
import org.pushingpixels.substance.internal.contrib.jgoodies.looks.LookUtils;
import org.pushingpixels.substance.internal.fonts.DefaultKDEFontPolicy;
import org.pushingpixels.substance.internal.painter.DecorationPainterUtils;
import org.pushingpixels.substance.internal.ui.SubstanceRootPaneUI;
import org.pushingpixels.substance.internal.utils.HashMapKey;
import org.pushingpixels.substance.internal.utils.MemoryAnalyzer;
import org.pushingpixels.substance.internal.utils.SubstanceColorResource;
import org.pushingpixels.substance.internal.utils.SubstanceColorSchemeUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceColorUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceImageCreator;
import org.pushingpixels.substance.internal.utils.SubstanceInternalButton;
import org.pushingpixels.substance.internal.utils.SubstanceInternalFrameTitlePane;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;
import org.pushingpixels.substance.internal.utils.SubstanceSpinnerButton;
import org.pushingpixels.substance.internal.utils.SubstanceTitleButton;
import org.pushingpixels.substance.internal.utils.TrackableThread;
import org.pushingpixels.substance.internal.utils.WidgetUtilities;
import org.pushingpixels.substance.internal.utils.combo.SubstanceComboPopup;
import org.pushingpixels.substance.internal.utils.icon.ArrowButtonTransitionAwareIcon;
import org.pushingpixels.substance.internal.utils.icon.TransitionAware;
import org.pushingpixels.substance.internal.utils.icon.TransitionAwareIcon;
import org.pushingpixels.substance.internal.utils.menu.SubstanceMenu;
import org.pushingpixels.substance.internal.utils.scroll.SubstanceScrollButton;
import org.pushingpixels.trident.swing.SwingRepaintCallback;

public class SubstanceCoreUtilities {
    public static final String IS_COVERED_BY_LIGHTWEIGHT_POPUPS = "substancelaf.internal.paint.isCoveredByLightweightPopups";
    public static final String TEXT_COMPONENT_AWARE = "substancelaf.internal.textComponentAware";
    private static Platform platform;

    private SubstanceCoreUtilities() {
    }

    public static String clipString(FontMetrics metrics, int availableWidth, String fullText) {
        if (metrics.stringWidth(fullText) <= availableWidth) {
            return fullText;
        }
        String ellipses = "...";
        int ellipsesWidth = metrics.stringWidth(ellipses);
        if (ellipsesWidth > availableWidth) {
            return "";
        }
        String starter = "";
        String ender = "";
        int w = fullText.length();
        int w2 = w / 2 + w % 2;
        String prevTitle = "";
        for (int i = 0; i < w2; ++i) {
            String newTitle;
            String newStarter = starter + fullText.charAt(i);
            String newEnder = ender;
            if (w - i > w2) {
                newEnder = fullText.charAt(w - i - 1) + newEnder;
            }
            if (metrics.stringWidth(newTitle = newStarter + ellipses + newEnder) > availableWidth) {
                return prevTitle;
            }
            starter = newStarter;
            ender = newEnder;
            prevTitle = newTitle;
        }
        return fullText;
    }

    public static boolean hasIcon(AbstractButton button) {
        return button.getIcon() != null;
    }

    public static boolean hasText(AbstractButton button) {
        String text = button.getText();
        return text != null && text.length() > 0;
    }

    public static boolean isComboBoxButton(AbstractButton button) {
        return SwingUtilities.getAncestorOfClass(JComboBox.class, button) != null;
    }

    public static boolean isScrollBarButton(AbstractButton button) {
        return SwingUtilities.getAncestorOfClass(JScrollBar.class, button) != null;
    }

    public static boolean isSpinnerButton(AbstractButton button) {
        if (!(button instanceof SubstanceSpinnerButton)) {
            return false;
        }
        return SwingUtilities.getAncestorOfClass(JSpinner.class, button) != null;
    }

    public static boolean isToolBarButton(JComponent component) {
        if (component.getClass().isAnnotationPresent(SubstanceInternalButton.class)) {
            return false;
        }
        return SwingUtilities.getAncestorOfClass(JToolBar.class, component) != null;
    }

    public static boolean isScrollButton(JComponent comp) {
        return comp instanceof SubstanceScrollButton;
    }

    public static boolean isButtonNeverPainted(JComponent button) {
        JComponent jparent;
        Object flatProperty;
        Container parent;
        if (button instanceof JCheckBox) {
            return false;
        }
        if (button instanceof JRadioButton) {
            return false;
        }
        Object prop = button.getClientProperty("substancelaf.internal.buttonNeverPaintBackground");
        if (prop != null) {
            if (Boolean.TRUE.equals(prop)) {
                return true;
            }
            if (Boolean.FALSE.equals(prop)) {
                return false;
            }
        }
        if (button != null && (parent = button.getParent()) instanceof JComponent && (flatProperty = (jparent = (JComponent)parent).getClientProperty("substancelaf.internal.buttonNeverPaintBackground")) != null) {
            if (Boolean.TRUE.equals(flatProperty)) {
                return true;
            }
            if (Boolean.FALSE.equals(flatProperty)) {
                return false;
            }
        }
        return Boolean.TRUE.equals(UIManager.get("substancelaf.internal.buttonNeverPaintBackground"));
    }

    public static SubstanceSlices.FocusKind getFocusKind(Component component) {
        while (component != null) {
            JComponent jcomp;
            Object jcompFocusKind;
            if (component instanceof JComponent && (jcompFocusKind = (jcomp = (JComponent)component).getClientProperty("substancelaf.internal.focusKind")) instanceof SubstanceSlices.FocusKind) {
                return (SubstanceSlices.FocusKind)((Object)jcompFocusKind);
            }
            component = component.getParent();
        }
        Object globalFocusKind = UIManager.get("substancelaf.internal.focusKind");
        if (globalFocusKind instanceof SubstanceSlices.FocusKind) {
            return (SubstanceSlices.FocusKind)((Object)globalFocusKind);
        }
        return SubstanceSlices.FocusKind.ALL_INNER;
    }

    public static boolean toDrawWatermark(Component component) {
        for (Component c = component; c != null; c = c.getParent()) {
            JComponent jcomp;
            Object obj;
            if (!(c instanceof JComponent) || (obj = (jcomp = (JComponent)component).getClientProperty("substancelaf.internal.watermarkVisible")) == null) continue;
            if (Boolean.TRUE.equals(obj)) {
                return true;
            }
            if (!Boolean.FALSE.equals(obj)) continue;
            return false;
        }
        Object obj = UIManager.get("substancelaf.internal.watermarkVisible");
        if (Boolean.TRUE.equals(obj)) {
            return true;
        }
        if (Boolean.FALSE.equals(obj)) {
            return false;
        }
        if (component instanceof JList) {
            return false;
        }
        if (component instanceof JTree) {
            return false;
        }
        if (component instanceof JTable) {
            return false;
        }
        return !(component instanceof JTextComponent);
    }

    public static SubstanceButtonShaper getButtonShaper(Component comp) {
        Object prop;
        if (comp instanceof JComponent && (prop = ((JComponent)comp).getClientProperty("substancelaf.internal.buttonShaper")) instanceof SubstanceButtonShaper) {
            return (SubstanceButtonShaper)prop;
        }
        SubstanceSkin skin = SubstanceCoreUtilities.getSkin(comp);
        if (skin == null) {
            return null;
        }
        return skin.getButtonShaper();
    }

    public static SubstanceFillPainter getFillPainter(Component comp) {
        return SubstanceCoreUtilities.getSkin(comp).getFillPainter();
    }

    public static boolean isTabModified(Component tabComponent) {
        if (tabComponent instanceof JComponent) {
            JComponent jc = (JComponent)tabComponent;
            return Boolean.TRUE.equals(jc.getClientProperty("substancelaf.internal.contentsModified"));
        }
        return false;
    }

    public static boolean isRootPaneModified(JRootPane rootPane) {
        return Boolean.TRUE.equals(rootPane.getClientProperty("substancelaf.internal.contentsModified"));
    }

    public static boolean hasCloseButton(JTabbedPane tabbedPane, int tabIndex) {
        Object tabProp;
        int tabCount = tabbedPane.getTabCount();
        if (tabIndex < 0 || tabIndex >= tabCount) {
            return false;
        }
        if (!tabbedPane.isEnabledAt(tabIndex)) {
            return false;
        }
        Component tabComponent = tabbedPane.getComponentAt(tabIndex);
        if (tabComponent instanceof JComponent) {
            Object compProp = ((JComponent)tabComponent).getClientProperty("substancelaf.internal.tabbedPaneHasCloseButtons");
            if (Boolean.TRUE.equals(compProp)) {
                return true;
            }
            if (Boolean.FALSE.equals(compProp)) {
                return false;
            }
        }
        if (Boolean.TRUE.equals(tabProp = tabbedPane.getClientProperty("substancelaf.internal.tabbedPaneHasCloseButtons"))) {
            return true;
        }
        if (Boolean.FALSE.equals(tabProp)) {
            return false;
        }
        return UIManager.getBoolean("substancelaf.internal.tabbedPaneHasCloseButtons");
    }

    public static int getCloseButtonSize(JTabbedPane tabbedPane, int tabIndex) {
        if (!SubstanceCoreUtilities.hasCloseButton(tabbedPane, tabIndex)) {
            return 0;
        }
        return SubstanceSizeUtils.getTabCloseIconSize(SubstanceSizeUtils.getComponentFontSize(tabbedPane));
    }

    public static SubstanceSlices.TabContentPaneBorderKind getContentBorderKind(JTabbedPane tabbedPane) {
        Object tabProp = tabbedPane.getClientProperty("substancelaf.internal.tabbedPaneContentBorderKind");
        if (tabProp instanceof SubstanceSlices.TabContentPaneBorderKind) {
            return (SubstanceSlices.TabContentPaneBorderKind)((Object)tabProp);
        }
        Object globalProp = UIManager.get("substancelaf.internal.tabbedPaneContentBorderKind");
        if (globalProp instanceof SubstanceSlices.TabContentPaneBorderKind) {
            return (SubstanceSlices.TabContentPaneBorderKind)((Object)globalProp);
        }
        return SubstanceSlices.TabContentPaneBorderKind.DOUBLE_PLACEMENT;
    }

    public static boolean toAnimateCloseIconOfModifiedTab(JTabbedPane tabbedPane, int tabIndex) {
        Object tabProp;
        int tabCount = tabbedPane.getTabCount();
        if (tabIndex < 0 || tabIndex >= tabCount) {
            return false;
        }
        if (!SubstanceCoreUtilities.hasCloseButton(tabbedPane, tabIndex)) {
            return false;
        }
        Component tabComponent = tabbedPane.getComponentAt(tabIndex);
        if (tabComponent instanceof JComponent) {
            Object compProp = ((JComponent)tabComponent).getClientProperty("substancelaf.internal.tabbedPaneCloseButtonsModifiedAnimation");
            if (Boolean.TRUE.equals(compProp)) {
                return true;
            }
            if (Boolean.FALSE.equals(compProp)) {
                return false;
            }
        }
        if (Boolean.TRUE.equals(tabProp = tabbedPane.getClientProperty("substancelaf.internal.tabbedPaneCloseButtonsModifiedAnimation"))) {
            return true;
        }
        if (Boolean.FALSE.equals(tabProp)) {
            return false;
        }
        return UIManager.getBoolean("substancelaf.internal.tabbedPaneCloseButtonsModifiedAnimation");
    }

    public static BufferedImage getBlankImage(int width, int height) {
        if (MemoryAnalyzer.isRunning() && (width >= 100 || height >= 100)) {
            StackTraceElement[] stack = Thread.currentThread().getStackTrace();
            StringBuffer sb = new StringBuffer();
            int count = 0;
            for (StackTraceElement stackEntry : stack) {
                if (count++ > 8) break;
                sb.append(stackEntry.getClassName() + ".");
                sb.append(stackEntry.getMethodName() + " [");
                sb.append(stackEntry.getLineNumber() + "]");
                sb.append("\n");
            }
            MemoryAnalyzer.enqueueUsage("Blank " + width + "*" + height + "\n" + sb.toString());
        }
        if (UIUtil.getScaleFactor() > 1.0) {
            return new JBHiDPIScaledImage(width, height, 2);
        }
        GraphicsEnvironment e = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice d = e.getDefaultScreenDevice();
        GraphicsConfiguration c = d.getDefaultConfiguration();
        return c.createCompatibleImage(width, height, 3);
    }

    public static BufferedImage getBlankUnscaledImage(int width, int height) {
        if (MemoryAnalyzer.isRunning() && (width >= 100 || height >= 100)) {
            StackTraceElement[] stack = Thread.currentThread().getStackTrace();
            StringBuffer sb = new StringBuffer();
            int count = 0;
            for (StackTraceElement stackEntry : stack) {
                if (count++ > 8) break;
                sb.append(stackEntry.getClassName() + ".");
                sb.append(stackEntry.getMethodName() + " [");
                sb.append(stackEntry.getLineNumber() + "]");
                sb.append("\n");
            }
            MemoryAnalyzer.enqueueUsage("Blank " + width + "*" + height + "\n" + sb.toString());
        }
        if (UIUtil.getScaleFactor() > 1.0) {
            JBHiDPIScaledImage result = new JBHiDPIScaledImage(null, width, height, 2);
            result.setIgnoreScaling();
            return result;
        }
        GraphicsEnvironment e = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice d = e.getDefaultScreenDevice();
        GraphicsConfiguration c = d.getDefaultConfiguration();
        return c.createCompatibleImage(width, height, 3);
    }

    public static BufferedImage getBlankUnscaledImage(BufferedImage image) {
        int imageWidth = image.getWidth();
        int imageHeight = image.getHeight();
        if (MemoryAnalyzer.isRunning() && (imageWidth >= 100 || imageHeight >= 100)) {
            StackTraceElement[] stack = Thread.currentThread().getStackTrace();
            StringBuffer sb = new StringBuffer();
            int count = 0;
            for (StackTraceElement stackEntry : stack) {
                if (count++ > 8) break;
                sb.append(stackEntry.getClassName() + ".");
                sb.append(stackEntry.getMethodName() + " [");
                sb.append(stackEntry.getLineNumber() + "]");
                sb.append("\n");
            }
            MemoryAnalyzer.enqueueUsage("Blank " + imageWidth + "*" + imageHeight + "\n" + sb.toString());
        }
        if (UIUtil.getScaleFactor() > 1.0) {
            JBHiDPIScaledImage result = new JBHiDPIScaledImage(null, imageWidth, imageHeight, 2);
            result.setIgnoreScaling();
            return result;
        }
        GraphicsEnvironment e = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice d = e.getDefaultScreenDevice();
        GraphicsConfiguration c = d.getDefaultConfiguration();
        return c.createCompatibleImage(imageWidth, imageHeight, 3);
    }

    public static boolean isHiDpiAwareImage(Image image) {
        return image instanceof IsHiDpiAware;
    }

    public static boolean hasNoMinSizeProperty(AbstractButton button) {
        Object noMinSizeProperty = button.getClientProperty("substancelaf.internal.buttonNoMinSize");
        if (Boolean.TRUE.equals(noMinSizeProperty)) {
            return true;
        }
        if (Boolean.FALSE.equals(noMinSizeProperty)) {
            return false;
        }
        Container parent = button.getParent();
        if (parent instanceof JComponent) {
            noMinSizeProperty = ((JComponent)parent).getClientProperty("substancelaf.internal.buttonNoMinSize");
            if (Boolean.TRUE.equals(noMinSizeProperty)) {
                return true;
            }
            if (Boolean.FALSE.equals(noMinSizeProperty)) {
                return false;
            }
        }
        return Boolean.TRUE.equals(UIManager.get("substancelaf.internal.buttonNoMinSize"));
    }

    public static void markButtonAsFlat(AbstractButton button) {
        SubstanceCortex.ComponentOrParentScope.setFlatBackground(button, true);
        button.setOpaque(false);
    }

    public static boolean hasFlatAppearance(Component comp, boolean defaultValue) {
        Object flatProperty;
        JComponent jparent;
        Object flatProperty2;
        Container parent;
        JComponent jcomp;
        Object flatProperty3;
        if (comp instanceof JCheckBox) {
            return defaultValue;
        }
        if (comp instanceof JRadioButton) {
            return defaultValue;
        }
        Component c = comp;
        if (c instanceof JComponent && (flatProperty3 = (jcomp = (JComponent)c).getClientProperty("substancelaf.internal.FlatLook")) != null) {
            if (Boolean.TRUE.equals(flatProperty3)) {
                return true;
            }
            if (Boolean.FALSE.equals(flatProperty3)) {
                return false;
            }
        }
        if (c != null && (parent = c.getParent()) instanceof JComponent && (flatProperty2 = (jparent = (JComponent)parent).getClientProperty("substancelaf.internal.FlatLook")) != null) {
            if (Boolean.TRUE.equals(flatProperty2)) {
                return true;
            }
            if (Boolean.FALSE.equals(flatProperty2)) {
                return false;
            }
        }
        if ((flatProperty = UIManager.get("substancelaf.internal.FlatLook")) != null) {
            if (Boolean.TRUE.equals(flatProperty)) {
                return true;
            }
            if (Boolean.FALSE.equals(flatProperty)) {
                return false;
            }
        }
        return defaultValue;
    }

    public static boolean hasFlatAppearance(AbstractButton button) {
        if (button instanceof JCheckBox) {
            return false;
        }
        if (button instanceof JRadioButton) {
            return false;
        }
        return SubstanceCoreUtilities.isToolBarButton(button) && SubstanceCoreUtilities.hasFlatAppearance(button, true) || SubstanceCoreUtilities.hasFlatAppearance(button, false);
    }

    public static int getPopupFlyoutOrientation(JComboBox combobox) {
        Object comboProperty = combobox.getClientProperty("substancelaf.internal.comboBoxPopupFlyoutOrientation");
        if (comboProperty instanceof Integer) {
            return (Integer)comboProperty;
        }
        Object globalProperty = UIManager.get("substancelaf.internal.comboBoxPopupFlyoutOrientation");
        if (globalProperty instanceof Integer) {
            return (Integer)globalProperty;
        }
        return 5;
    }

    public static void makeNonOpaque(Component comp, Map<Component, Boolean> opacitySnapshot) {
        if (comp instanceof JComponent) {
            JComponent jcomp = (JComponent)comp;
            opacitySnapshot.put(comp, jcomp.isOpaque());
            jcomp.setOpaque(false);
        }
        if (comp instanceof Container) {
            Container cont = (Container)comp;
            for (int i = 0; i < cont.getComponentCount(); ++i) {
                SubstanceCoreUtilities.makeNonOpaque(cont.getComponent(i), opacitySnapshot);
            }
        }
    }

    public static void restoreOpaque(Component comp, Map<Component, Boolean> opacitySnapshot) {
        if (comp instanceof JComponent) {
            JComponent jcomp = (JComponent)comp;
            if (opacitySnapshot.containsKey(comp)) {
                jcomp.setOpaque(opacitySnapshot.get(comp));
            } else {
                jcomp.setOpaque(true);
            }
        }
        if (comp instanceof Container) {
            Container cont = (Container)comp;
            for (int i = 0; i < cont.getComponentCount(); ++i) {
                SubstanceCoreUtilities.restoreOpaque(cont.getComponent(i), opacitySnapshot);
            }
        }
    }

    public static BufferedImage createCompatibleImage(BufferedImage image) {
        GraphicsEnvironment e = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice d = e.getDefaultScreenDevice();
        GraphicsConfiguration c = d.getDefaultConfiguration();
        BufferedImage compatibleImage = c.createCompatibleImage(image.getWidth(), image.getHeight(), 3);
        Graphics g2 = compatibleImage.getGraphics();
        g2.drawImage(image, 0, 0, null);
        g2.dispose();
        return compatibleImage;
    }

    public static boolean useThemedDefaultIcon(JComponent comp) {
        if (comp == null || comp.getClass().isAnnotationPresent(SubstanceInternalButton.class)) {
            return false;
        }
        return Boolean.TRUE.equals(UIManager.get("substancelaf.internal.useThemedDefaultIcons"));
    }

    public static TabCloseCallback getTabCloseCallback(MouseEvent me, JTabbedPane tabbedPane, int tabIndex) {
        Object compProp;
        int tabCount = tabbedPane.getTabCount();
        if (tabIndex < 0 || tabIndex >= tabCount) {
            return null;
        }
        Component tabComponent = tabbedPane.getComponentAt(tabIndex);
        if (tabComponent instanceof JComponent && (compProp = ((JComponent)tabComponent).getClientProperty("substancelaf.internal.tabbedPaneCloseCallback")) instanceof TabCloseCallback) {
            return (TabCloseCallback)compProp;
        }
        Object tabProp = tabbedPane.getClientProperty("substancelaf.internal.tabbedPaneCloseCallback");
        if (tabProp instanceof TabCloseCallback) {
            return (TabCloseCallback)tabProp;
        }
        Object globProp = UIManager.get("substancelaf.internal.tabbedPaneCloseCallback");
        if (globProp instanceof TabCloseCallback) {
            return (TabCloseCallback)globProp;
        }
        return null;
    }

    public static BufferedImage blendImagesVertical(BufferedImage imageTop, BufferedImage imageBottom, double start, double end) {
        int width = imageTop.getWidth();
        if (width != imageBottom.getWidth()) {
            throw new IllegalArgumentException("Widths are not the same: " + imageTop.getWidth() + " and " + imageBottom.getWidth());
        }
        int height = imageTop.getHeight();
        if (height != imageBottom.getHeight()) {
            throw new IllegalArgumentException("Heights are not the same: " + imageTop.getHeight() + " and " + imageBottom.getHeight());
        }
        BufferedImage result = SubstanceCoreUtilities.getBlankUnscaledImage(imageTop);
        Graphics2D graphics = result.createGraphics();
        int endY = (int)(end * (double)height);
        int startY = (int)(start * (double)height);
        int rampHeight = endY - startY;
        if (rampHeight == 0) {
            graphics.drawImage(imageTop, 0, 0, width, startY, 0, 0, width, startY, null);
            graphics.drawImage(imageBottom, 0, startY, width, height, 0, startY, width, height, null);
        } else {
            BufferedImage rampBottom = SubstanceCoreUtilities.getBlankUnscaledImage(width, rampHeight);
            Graphics2D rampBottomG = (Graphics2D)rampBottom.getGraphics();
            rampBottomG.setPaint(new GradientPaint(new Point(0, 0), new Color(0, 0, 0, 255), new Point(0, rampHeight), new Color(0, 0, 0, 0)));
            rampBottomG.fillRect(0, 0, width, rampHeight);
            BufferedImage tempBottom = SubstanceCoreUtilities.getBlankUnscaledImage(width, height - startY);
            Graphics2D tempBottomG = (Graphics2D)tempBottom.getGraphics();
            tempBottomG.drawImage(imageBottom, 0, 0, width, height - startY, 0, startY, width, height, null);
            tempBottomG.setComposite(AlphaComposite.DstOut);
            tempBottomG.drawImage((Image)rampBottom, 0, 0, null);
            tempBottomG.setComposite(AlphaComposite.SrcOver);
            graphics.drawImage((Image)imageTop, 0, 0, null);
            graphics.drawImage((Image)tempBottom, 0, startY, null);
        }
        graphics.dispose();
        return result;
    }

    public static BufferedImage blendImagesHorizontal(BufferedImage imageLeft, BufferedImage imageRight, double start, double end) {
        int width = imageLeft.getWidth();
        if (width != imageRight.getWidth()) {
            throw new IllegalArgumentException("Widths are not the same: " + imageLeft.getWidth() + " and " + imageRight.getWidth());
        }
        int height = imageLeft.getHeight();
        if (height != imageRight.getHeight()) {
            throw new IllegalArgumentException("Heights are not the same: " + imageLeft.getHeight() + " and " + imageRight.getHeight());
        }
        BufferedImage result = SubstanceCoreUtilities.getBlankUnscaledImage(imageLeft);
        Graphics2D graphics = result.createGraphics();
        int endX = (int)(end * (double)width);
        int startX = (int)(start * (double)width);
        int rampWidth = endX - startX;
        if (rampWidth == 0) {
            graphics.drawImage(imageLeft, 0, 0, startX, height, 0, 0, startX, height, null);
            graphics.drawImage(imageRight, startX, 0, width, height, startX, 0, width, height, null);
        } else {
            BufferedImage rampRight = SubstanceCoreUtilities.getBlankUnscaledImage(rampWidth, height);
            Graphics2D rampRightG = (Graphics2D)rampRight.getGraphics();
            rampRightG.setPaint(new GradientPaint(new Point(0, 0), new Color(0, 0, 0, 255), new Point(rampWidth, 0), new Color(0, 0, 0, 0)));
            rampRightG.fillRect(0, 0, rampWidth, height);
            BufferedImage tempRight = SubstanceCoreUtilities.getBlankUnscaledImage(width - startX, height);
            Graphics2D tempRightG = (Graphics2D)tempRight.getGraphics();
            tempRightG.drawImage(imageRight, 0, 0, width - startX, height, startX, 0, width, height, null);
            tempRightG.setComposite(AlphaComposite.DstOut);
            tempRightG.drawImage((Image)rampRight, 0, 0, null);
            tempRightG.setComposite(AlphaComposite.SrcOver);
            graphics.drawImage((Image)imageLeft, 0, 0, null);
            graphics.drawImage((Image)tempRight, startX, 0, null);
        }
        graphics.dispose();
        return result;
    }

    public static boolean shouldUseThemedIconsOnOptionPanes() {
        Object globalSetting = UIManager.get("substancelaf.internal.useThemedIconsOnOptionPanes");
        if (globalSetting instanceof Boolean) {
            return (Boolean)globalSetting;
        }
        return true;
    }

    public static SubstanceColorScheme getOptionPaneColorScheme(int messageType, SubstanceColorScheme mainScheme) {
        Object globalSetting = UIManager.get("substancelaf.internal.useThemedIconsOnOptionPanes");
        if (Boolean.FALSE.equals(globalSetting)) {
            return mainScheme;
        }
        switch (messageType) {
            case 1: {
                return new BottleGreenColorScheme();
            }
            case 3: {
                return new LightAquaColorScheme();
            }
            case 2: {
                return new SunsetColorScheme();
            }
            case 0: {
                return new SunfireRedColorScheme();
            }
        }
        return null;
    }

    public static Object getComboPopupPrototypeDisplayValue(JComboBox combo) {
        Object callback = combo.getClientProperty("substancelaf.internal.comboPopupPrototype");
        if (callback == null) {
            callback = UIManager.get("substancelaf.internal.comboPopupPrototype");
        }
        if (callback instanceof ComboPopupPrototypeCallback) {
            return ((ComboPopupPrototypeCallback)callback).getPopupPrototypeDisplayValue(combo);
        }
        Object displayValue = combo.getClientProperty("substancelaf.internal.comboPopupPrototype");
        if (displayValue == null) {
            displayValue = UIManager.get("substancelaf.internal.comboPopupPrototype");
        }
        return displayValue;
    }

    public static Set<SubstanceSlices.Side> getSides(JComponent component, String propertyName) {
        if (component == null) {
            return null;
        }
        Object prop = component.getClientProperty(propertyName);
        if (prop == null) {
            return null;
        }
        if (prop instanceof Set) {
            return (Set)prop;
        }
        if (prop != null && prop instanceof SubstanceSlices.Side) {
            EnumSet<SubstanceSlices.Side> result = EnumSet.noneOf(SubstanceSlices.Side.class);
            result.add((SubstanceSlices.Side)((Object)prop));
            return result;
        }
        return null;
    }

    public static float getToolbarButtonCornerRadius(JComponent button, float insets) {
        float height;
        JToolBar toolbar = null;
        for (Container c = button.getParent(); c != null; c = c.getParent()) {
            if (!(c instanceof JToolBar)) continue;
            toolbar = (JToolBar)c;
            break;
        }
        if (toolbar == null) {
            return 2.0f;
        }
        float width = (float)button.getWidth() - 2.0f * insets;
        float maxRadius = width > (height = (float)button.getHeight() - 2.0f * insets) ? height / 2.0f : width / 2.0f;
        Object buttonProp = button.getClientProperty("substancelaf.internal.toolbarButtonCornerRadius");
        if (buttonProp instanceof Float) {
            return Math.min(maxRadius, ((Float)buttonProp).floatValue());
        }
        Object toolbarProp = toolbar.getClientProperty("substancelaf.internal.toolbarButtonCornerRadius");
        if (toolbarProp instanceof Float) {
            return Math.min(maxRadius, ((Float)toolbarProp).floatValue());
        }
        Object globalProp = UIManager.get("substancelaf.internal.toolbarButtonCornerRadius");
        if (globalProp instanceof Float) {
            return Math.min(maxRadius, ((Float)globalProp).floatValue());
        }
        return 2.0f;
    }

    public static int getEchoPerChar(JPasswordField jpf) {
        int result;
        Object obj = jpf.getClientProperty("substancelaf.internal.passwordEchoPerChar");
        if (obj != null && obj instanceof Integer && (result = ((Integer)obj).intValue()) >= 1) {
            return result;
        }
        obj = UIManager.get("substancelaf.internal.passwordEchoPerChar");
        if (obj != null && obj instanceof Integer && (result = ((Integer)obj).intValue()) >= 1) {
            return result;
        }
        return 1;
    }

    public static BufferedImage softClip(int width, int height, BufferedImage source, Shape clipShape) {
        BufferedImage img = SubstanceCoreUtilities.getBlankImage(width, height);
        Graphics2D g2 = img.createGraphics();
        g2.setComposite(AlphaComposite.Clear);
        g2.fillRect(0, 0, width, height);
        g2.setComposite(AlphaComposite.Src);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setColor(Color.WHITE);
        g2.fill(clipShape);
        g2.setComposite(AlphaComposite.SrcAtop);
        g2.drawImage((Image)source, 0, 0, null);
        g2.dispose();
        return img;
    }

    public static boolean toShowExtraWidgets(Component component) {
        for (Component c = component; c != null; c = c.getParent()) {
            JComponent jcomp;
            Object componentProp;
            if (!(c instanceof JComponent) || (componentProp = (jcomp = (JComponent)c).getClientProperty("substancelaf.internal.showExtraWidgets")) == null) continue;
            if (Boolean.TRUE.equals(componentProp)) {
                return false;
            }
            if (!Boolean.FALSE.equals(componentProp)) continue;
            return true;
        }
        return Boolean.TRUE.equals(UIManager.get("substancelaf.internal.showExtraWidgets"));
    }

    public static SubstanceIconUIResource getThemedIcon(Component comp, Icon orig) {
        SubstanceColorScheme colorScheme = SubstanceColorSchemeUtilities.getColorScheme(comp, ComponentState.ENABLED);
        return SubstanceCoreUtilities.getThemedIcon(comp, orig, colorScheme);
    }

    public static SubstanceIconUIResource getThemedIcon(JTabbedPane tab, int tabIndex, Icon orig) {
        SubstanceColorScheme colorScheme = SubstanceColorSchemeUtilities.getColorScheme(tab, tabIndex, SubstanceSlices.ColorSchemeAssociationKind.TAB, ComponentState.ENABLED);
        return SubstanceCoreUtilities.getThemedIcon((Component)tab, orig, colorScheme);
    }

    public static SubstanceIconUIResource getThemedIcon(Component comp, Icon orig, SubstanceColorScheme colorScheme) {
        float brightnessFactor = colorScheme.isDark() ? 0.2f : 0.8f;
        return new SubstanceIconUIResource(SubstanceImageCreator.getColorSchemeImage(comp, orig, colorScheme, brightnessFactor));
    }

    public static Icon getOriginalIcon(AbstractButton b, Icon defaultIcon) {
        ButtonModel model = b.getModel();
        Icon icon = b.getIcon();
        if (icon == null) {
            icon = defaultIcon;
        }
        if (icon.getClass().isAnnotationPresent(TransitionAware.class)) {
            return icon;
        }
        Icon tmpIcon = null;
        if (icon != null) {
            if (!model.isEnabled()) {
                tmpIcon = model.isSelected() ? b.getDisabledSelectedIcon() : b.getDisabledIcon();
            } else if (model.isPressed() && model.isArmed()) {
                tmpIcon = b.getPressedIcon();
            } else if (b.isRolloverEnabled() && model.isRollover()) {
                if (model.isSelected()) {
                    tmpIcon = b.getRolloverSelectedIcon();
                    if (tmpIcon == null) {
                        tmpIcon = b.getSelectedIcon();
                    }
                } else {
                    tmpIcon = b.getRolloverIcon();
                }
            } else if (model.isSelected()) {
                tmpIcon = b.getSelectedIcon();
            }
            if (tmpIcon != null) {
                icon = tmpIcon;
            }
        }
        return icon;
    }

    public static SubstanceSlices.MenuGutterFillKind getMenuGutterFillKind() {
        Object globalSetting = UIManager.get("substancelaf.internal.menuGutterFillKind");
        if (globalSetting instanceof SubstanceSlices.MenuGutterFillKind) {
            return (SubstanceSlices.MenuGutterFillKind)((Object)globalSetting);
        }
        return SubstanceSlices.MenuGutterFillKind.HARD_FILL;
    }

    public static Container getHeaderParent(Component c) {
        Container result = null;
        for (Container comp = c.getParent(); comp != null; comp = comp.getParent()) {
            if (comp instanceof JLayeredPane && result == null) {
                result = comp;
            }
            if (result != null || !(comp instanceof Window)) continue;
            result = comp;
        }
        return result;
    }

    public static void paintFocus(Graphics g2, Component mainComp, Component focusedComp, TransitionAwareUI transitionAwareUI, Shape focusShape, Rectangle textRect, float maxAlphaCoef, float extraPadding) {
        float focusStrength = transitionAwareUI.getTransitionTracker().getFocusStrength(focusedComp.hasFocus());
        if (focusStrength == 0.0f) {
            return;
        }
        SubstanceSlices.FocusKind focusKind = SubstanceCoreUtilities.getFocusKind(mainComp);
        if (focusKind == SubstanceSlices.FocusKind.NONE) {
            return;
        }
        Graphics2D graphics = (Graphics2D)g2.create();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        float alpha = maxAlphaCoef * focusStrength;
        graphics.setComposite(WidgetUtilities.getAlphaComposite(mainComp, alpha, g2));
        Color color = SubstanceColorUtilities.getFocusColor(mainComp, transitionAwareUI);
        graphics.setColor(color);
        focusKind.paintFocus(mainComp, focusedComp, transitionAwareUI, graphics, focusShape, textRect, extraPadding);
        graphics.dispose();
    }

    public static boolean isTitleCloseButton(JComponent ab) {
        return ab instanceof SubstanceTitleButton && Boolean.TRUE.equals(ab.getClientProperty("substancelaf.internal.isTitleCloseButton"));
    }

    public static void uninstallMenu(JMenuItem menuItem) {
        SubstanceMenu sMenu;
        ButtonUI menuItemUI;
        if (menuItem instanceof JMenu) {
            JMenu menu = (JMenu)menuItem;
            for (Component comp : menu.getMenuComponents()) {
                if (!(comp instanceof JMenuItem)) continue;
                SubstanceCoreUtilities.uninstallMenu((JMenuItem)comp);
            }
        }
        if ((menuItemUI = menuItem.getUI()) instanceof SubstanceMenu && (sMenu = (SubstanceMenu)((Object)menuItemUI)).getAssociatedMenuItem() != null) {
            menuItemUI.uninstallUI(menuItem);
        }
        for (ActionListener actionListener : menuItem.getActionListeners()) {
            menuItem.removeActionListener(actionListener);
        }
        menuItem.removeAll();
    }

    public static ClassLoader getClassLoaderForResources() {
        ClassLoader cl = (ClassLoader)UIManager.get("ClassLoader");
        if (cl == null) {
            cl = Thread.currentThread().getContextClassLoader();
        }
        return cl;
    }

    public static boolean isCoveredByLightweightPopups(Component comp) {
        int popupIndexToStartWith;
        JRootPane rootPane = SwingUtilities.getRootPane(comp);
        if (rootPane == null) {
            return false;
        }
        Component[] popups = rootPane.getLayeredPane().getComponentsInLayer(JLayeredPane.POPUP_LAYER);
        if (popups == null) {
            return false;
        }
        Rectangle compBoundsConverted = SwingUtilities.convertRectangle(comp.getParent(), comp.getBounds(), rootPane.getLayeredPane());
        for (int i = popupIndexToStartWith = SubstanceCoreUtilities.getPopupParentIndexOf(comp, popups) - 1; i >= 0; --i) {
            Component popup = popups[i];
            if (!compBoundsConverted.intersects(popup.getBounds())) continue;
            return true;
        }
        return false;
    }

    public static int getPopupParentIndexOf(Component comp, Component[] popups) {
        for (int i = 0; i < popups.length; ++i) {
            Component popup = popups[i];
            for (Component currComp = comp; currComp != null; currComp = currComp.getParent()) {
                if (currComp != popup) continue;
                return i;
            }
        }
        return popups.length;
    }

    public static SubstanceBorderPainter getBorderPainter(Component comp) {
        return SubstanceCoreUtilities.getSkin(comp).getBorderPainter();
    }

    public static SubstanceBorderPainter getHighlightBorderPainter(Component comp) {
        SubstanceBorderPainter result = SubstanceCoreUtilities.getSkin(comp).getHighlightBorderPainter();
        if (result != null) {
            return result;
        }
        return SubstanceCoreUtilities.getBorderPainter(comp);
    }

    public static String getHierarchy(Component comp) {
        StringBuffer buffer = new StringBuffer();
        SubstanceCoreUtilities.getHierarchy(comp, buffer, 0);
        while (comp instanceof Window) {
            Window w = (Window)comp;
            if ((comp = w.getOwner()) == null) continue;
            buffer.append("Owner --->\n");
            SubstanceCoreUtilities.getHierarchy(comp, buffer, 0);
        }
        return buffer.toString();
    }

    public static void getHierarchy(Component comp, StringBuffer buffer, int level) {
        for (int i = 0; i < level; ++i) {
            buffer.append("   ");
        }
        String name = comp.getName();
        if (comp instanceof Dialog) {
            name = ((Dialog)comp).getTitle();
        }
        if (comp instanceof Frame) {
            name = ((Frame)comp).getTitle();
        }
        buffer.append(comp.getClass().getName() + "[" + name + "]\n");
        if (comp instanceof Container) {
            Container cont = (Container)comp;
            for (int i = 0; i < cont.getComponentCount(); ++i) {
                SubstanceCoreUtilities.getHierarchy(cont.getComponent(i), buffer, level + 1);
            }
        }
    }

    public static Icon getArrowIcon(AbstractButton button, int orientation) {
        ArrowButtonTransitionAwareIcon result = new ArrowButtonTransitionAwareIcon(button, orientation);
        return result;
    }

    public static Icon getArrowIcon(JComponent comp, TransitionAwareIcon.TransitionAwareUIDelegate transitionAwareUIDelegate, int orientation) {
        ArrowButtonTransitionAwareIcon result = new ArrowButtonTransitionAwareIcon(comp, transitionAwareUIDelegate, orientation);
        return result;
    }

    public static double getColorizationFactor(Component c) {
        Component invoker;
        JPopupMenu popupMenu = null;
        while (c != null) {
            JComponent jcomp;
            Object compProp;
            if (c instanceof JComponent && (compProp = (jcomp = (JComponent)c).getClientProperty("substancelaf.internal.colorizationFactor")) instanceof Double) {
                return (Double)compProp;
            }
            if (c instanceof JPopupMenu) {
                popupMenu = (JPopupMenu)c;
            }
            c = c.getParent();
        }
        if (popupMenu != null && popupMenu != (invoker = popupMenu.getInvoker())) {
            return SubstanceCoreUtilities.getColorizationFactor(popupMenu.getInvoker());
        }
        Object globalProp = UIManager.get("substancelaf.internal.colorizationFactor");
        if (globalProp instanceof Double) {
            return (Double)globalProp;
        }
        return 0.5;
    }

    public static SubstanceSkin getSkin(Component c) {
        Object skinProp;
        Container frame;
        if (!SubstanceCoreUtilities.isCurrentLookAndFeel()) {
            return null;
        }
        if (!SubstanceRootPaneUI.hasCustomSkinOnAtLeastOneRootPane()) {
            return SubstanceCortex.GlobalScope.getCurrentSkin();
        }
        SubstanceComboPopup comboPopup = (SubstanceComboPopup)SwingUtilities.getAncestorOfClass(SubstanceComboPopup.class, c);
        if (comboPopup != null) {
            return SubstanceCoreUtilities.getSkin(comboPopup.getCombobox());
        }
        JRootPane rootPane = SwingUtilities.getRootPane(c);
        if (c instanceof SubstanceInternalFrameTitlePane && (frame = c.getParent()) != null && frame instanceof JInternalFrame) {
            rootPane = ((JInternalFrame)frame).getRootPane();
        }
        if (c != null && c.getParent() instanceof SubstanceInternalFrameTitlePane && (frame = c.getParent().getParent()) != null && frame instanceof JInternalFrame) {
            rootPane = ((JInternalFrame)frame).getRootPane();
        }
        if (rootPane != null && (skinProp = rootPane.getClientProperty("substancelaf.internal.rootPaneSkin")) instanceof SubstanceSkin) {
            return (SubstanceSkin)skinProp;
        }
        return SubstanceCortex.GlobalScope.getCurrentSkin();
    }

    public static HashMapKey getHashKey(Object ... objects) {
        return new HashMapKey(objects);
    }

    public static void stopThreads() {
        TrackableThread.requestStopAllThreads();
    }

    public static String getVmParameter(String parameterName) {
        String paramValue = null;
        try {
            paramValue = System.getProperty(parameterName);
            return paramValue;
        }
        catch (Exception exc) {
            return null;
        }
    }

    public static void testComponentCreationThreadingViolation(Component comp) {
        if (!SwingUtilities.isEventDispatchThread()) {
            UiThreadingViolationException uiThreadingViolationError = new UiThreadingViolationException("Component creation must be done on Event Dispatch Thread");
            uiThreadingViolationError.printStackTrace(System.err);
            throw uiThreadingViolationError;
        }
    }

    public static void testComponentStateChangeThreadingViolation(Component comp) {
        if (!SwingUtilities.isEventDispatchThread()) {
            UiThreadingViolationException uiThreadingViolationError = new UiThreadingViolationException("Component state change must be done on Event Dispatch Thread");
            uiThreadingViolationError.printStackTrace(System.err);
            throw uiThreadingViolationError;
        }
    }

    public static void testWindowCloseThreadingViolation(Window w) {
        if (!SwingUtilities.isEventDispatchThread()) {
            UiThreadingViolationException uiThreadingViolationError = new UiThreadingViolationException("Window close must be done on Event Dispatch Thread");
            uiThreadingViolationError.printStackTrace(System.err);
            throw uiThreadingViolationError;
        }
    }

    public static void traceSubstanceApiUsage(Component comp, String message) {
        Window w = SwingUtilities.getWindowAncestor(comp);
        String wTitle = null;
        if (w instanceof Frame) {
            wTitle = ((Frame)w).getTitle();
        }
        if (w instanceof Dialog) {
            wTitle = ((Dialog)w).getTitle();
        }
        String wClassName = w != null ? w.getClass().getName() : null;
        throw new IllegalArgumentException(message + " [component " + comp.getClass().getSimpleName() + " in window " + wClassName + ":'" + wTitle + "' under " + UIManager.getLookAndFeel().getName() + "]");
    }

    public static BufferedImage getScaledIconImage(List<Image> imageList, int width, int height) {
        if (width == 0 || height == 0) {
            return null;
        }
        Image bestImage = null;
        int bestWidth = 0;
        int bestHeight = 0;
        double bestSimilarity = 3.0;
        for (Image im : imageList) {
            int ih;
            int iw;
            if (im == null) continue;
            try {
                iw = im.getWidth(null);
                ih = im.getHeight(null);
            }
            catch (Exception e) {
                continue;
            }
            if (SubstanceCoreUtilities.isHiDpiAwareImage(im)) {
                iw /= 2;
                ih /= 2;
            }
            if (iw <= 0 || ih <= 0) continue;
            double scaleFactor = Math.min((double)width / (double)iw, (double)height / (double)ih);
            int adjw = 0;
            int adjh = 0;
            double scaleMeasure = 1.0;
            if (scaleFactor >= 2.0) {
                scaleFactor = Math.floor(scaleFactor);
                adjw = iw * (int)scaleFactor;
                adjh = ih * (int)scaleFactor;
                scaleMeasure = 1.0 - 0.5 / scaleFactor;
            } else if (scaleFactor >= 1.0) {
                scaleFactor = 1.0;
                adjw = iw;
                adjh = ih;
                scaleMeasure = 0.0;
            } else if (scaleFactor >= 0.75) {
                scaleFactor = 0.75;
                adjw = iw * 3 / 4;
                adjh = ih * 3 / 4;
                scaleMeasure = 0.3;
            } else if (scaleFactor >= 0.6666) {
                scaleFactor = 0.6666;
                adjw = iw * 2 / 3;
                adjh = ih * 2 / 3;
                scaleMeasure = 0.33;
            } else {
                double scaleDivider = Math.ceil(1.0 / scaleFactor);
                scaleFactor = 1.0 / scaleDivider;
                adjw = (int)Math.round((double)iw / scaleDivider);
                adjh = (int)Math.round((double)ih / scaleDivider);
                scaleMeasure = 1.0 - 1.0 / scaleDivider;
            }
            double similarity = ((double)width - (double)adjw) / (double)width + ((double)height - (double)adjh) / (double)height + scaleMeasure;
            if (similarity < bestSimilarity) {
                bestSimilarity = similarity;
                bestImage = im;
                bestWidth = adjw;
                bestHeight = adjh;
            }
            if (similarity != 0.0) continue;
            break;
        }
        if (bestImage == null) {
            return null;
        }
        BufferedImage bimage = SubstanceCoreUtilities.getBlankImage(width, height);
        Graphics2D g2 = bimage.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        int x = (width - bestWidth) / 2;
        int y = (height - bestHeight) / 2;
        g2.drawImage(bestImage, x, y, bestWidth, bestHeight, null);
        g2.dispose();
        return bimage;
    }

    public static boolean canReplaceChildBackgroundColor(Color background) {
        return background instanceof UIResource || background instanceof SubstanceColorResource;
    }

    public static JTextComponent getTextComponentForTransitions(Component c) {
        if (!(c instanceof JComponent)) {
            return null;
        }
        TextComponentAware tcaui = (TextComponentAware)((JComponent)c).getClientProperty(TEXT_COMPONENT_AWARE);
        if (tcaui != null) {
            return tcaui.getTextComponent(c);
        }
        if (c instanceof JTextComponent) {
            return (JTextComponent)c;
        }
        return null;
    }

    public static SwingRepaintCallback getTextComponentRepaintCallback(JTextComponent textComponent) {
        for (Container c = textComponent; c != null; c = c.getParent()) {
            TextComponentAware tcaui;
            if (!(c instanceof JComponent) || (tcaui = (TextComponentAware)((JComponent)c).getClientProperty(TEXT_COMPONENT_AWARE)) == null) continue;
            return new SwingRepaintCallback(c);
        }
        return new SwingRepaintCallback(textComponent);
    }

    public static boolean isOpaque(JComponent c) {
        return c.isOpaque();
    }

    public static boolean isCurrentLookAndFeel() {
        return SubstanceCortex.GlobalScope.getCurrentSkin() != null;
    }

    public static int getButtonBarGravity(Container c) {
        boolean isLeftToRight = c.getComponentOrientation().isLeftToRight();
        SubstanceSlices.HorizontalGravity buttonBarGravity = SubstanceCortex.GlobalScope.getButtonBarGravity();
        switch (buttonBarGravity) {
            case PLATFORM: {
                return LookUtils.IS_OS_MAC ? (isLeftToRight ? 4 : 2) : 0;
            }
            case LEADING: {
                return isLeftToRight ? 2 : 4;
            }
            case CENTERED: 
            case SWING_DEFAULT: {
                return 0;
            }
            case TRAILING: {
                return isLeftToRight ? 4 : 2;
            }
        }
        throw new IllegalStateException("Unknown button alignment " + (Object)((Object)buttonBarGravity));
    }

    public static synchronized Platform getPlatform() {
        if (platform != null) {
            return platform;
        }
        if (LookUtils.IS_OS_WINDOWS) {
            platform = Platform.WINDOWS;
            return platform;
        }
        if (LookUtils.IS_OS_MAC) {
            platform = Platform.MACOS;
            return platform;
        }
        try {
            if (DefaultKDEFontPolicy.isKDERunning()) {
                platform = Platform.KDE;
                return platform;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            String desktop = AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return System.getProperty("sun.desktop");
                }
            });
            if ("gnome".equals(desktop)) {
                platform = Platform.GNOME;
                return platform;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        platform = Platform.DEFAULT;
        return platform;
    }

    public static JComponent getTitlePaneComponent(Window window) {
        JRootPane rootPane = SwingUtilities.getRootPane(window);
        if (rootPane != null) {
            SubstanceRootPaneUI ui = (SubstanceRootPaneUI)rootPane.getUI();
            return ui.getTitlePane();
        }
        return null;
    }

    public static void updateActiveUi() {
        for (Window window : Window.getWindows()) {
            SwingUtilities.updateComponentTreeUI(window);
        }
        for (MenuElement menuElement : MenuSelectionManager.defaultManager().getSelectedPath()) {
            if (!(menuElement instanceof JPopupMenu)) continue;
            SwingUtilities.updateComponentTreeUI((JPopupMenu)menuElement);
        }
    }

    public static Point getOffsetInRootPaneCoords(Component comp) {
        JLayeredPane layeredPane;
        if (comp == null) {
            throw new IllegalArgumentException("Cannot pass null component");
        }
        JRootPane rootPane = SwingUtilities.getRootPane(comp);
        int dx = 0;
        int dy = 0;
        if (rootPane != null && (layeredPane = rootPane.getLayeredPane()) != null) {
            Insets layeredPaneInsets = layeredPane.getInsets();
            if (comp.isShowing() && layeredPane.isShowing()) {
                dx += comp.getLocationOnScreen().x - layeredPane.getLocationOnScreen().x + layeredPaneInsets.left;
                dy += comp.getLocationOnScreen().y - layeredPane.getLocationOnScreen().y + layeredPaneInsets.top;
            } else {
                Component c;
                dx = 0;
                dy = 0;
                for (c = comp; c != rootPane; c = c.getParent()) {
                    dx += c.getX();
                    dy += c.getY();
                }
                c = layeredPane;
                if (c != null && c.getParent() != null) {
                    while (c != rootPane) {
                        dx -= c.getX();
                        dy -= c.getY();
                        c = c.getParent();
                    }
                }
                dx += layeredPaneInsets.left;
                dy += layeredPaneInsets.right;
            }
        }
        return new Point(dx, dy);
    }

    public static Component getTopMostParentWithDecorationAreaType(Component comp, SubstanceSlices.DecorationAreaType type) {
        Component c;
        if (comp == null) {
            throw new IllegalArgumentException("Component scope APIs do not accept null components");
        }
        Component topMostWithSameDecorationAreaType = c = comp;
        while (c != null) {
            if (DecorationPainterUtils.getImmediateDecorationType(c) == type) {
                topMostWithSameDecorationAreaType = c;
            }
            c = c.getParent();
        }
        return topMostWithSameDecorationAreaType;
    }

    public static interface TextComponentAware<T> {
        public JTextComponent getTextComponent(T var1);
    }

    public static enum Platform {
        MACOS,
        GNOME,
        KDE,
        WINDOWS,
        DEFAULT;

    }
}

